/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsPlan;
import org.cyclops.integratedterminals.part.PartTypeTerminalCraftingJob;
import org.cyclops.integratedterminals.part.PartTypes;

public class OpenCraftingJobsPlanGuiPacket
extends PacketCodec {
    @CodecField
    private BlockPos pos;
    @CodecField
    private Direction side;
    @CodecField
    private int channel;
    @CodecField
    private String craftingPlanHandler;
    @CodecField
    private CompoundTag craftingJobId;

    public OpenCraftingJobsPlanGuiPacket() {
    }

    public OpenCraftingJobsPlanGuiPacket(CraftingJobGuiData craftingPlanGuiData) {
        this.pos = craftingPlanGuiData.getPos();
        this.side = craftingPlanGuiData.getSide();
        this.channel = craftingPlanGuiData.getChannel();
        this.craftingPlanHandler = craftingPlanGuiData.getHandler().getId().toString();
        this.craftingJobId = new CompoundTag();
        this.craftingJobId.m_128365_("id", craftingPlanGuiData.getHandler().serializeCraftingJobId(craftingPlanGuiData.getCraftingJob()));
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ITerminalStorageTabIngredientCraftingHandler handler = this.getHandler();
        final CraftingJobGuiData craftingJobGuiData = new CraftingJobGuiData(this.pos, this.side, this.channel, handler, handler.deserializeCraftingJobId(this.craftingJobId.m_128423_("id")));
        final PartPos partPos = PartPos.of((Level)world, (BlockPos)this.pos, (Direction)this.side);
        MenuProvider containerProvider = new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)partPos);
                return new ContainerTerminalCraftingJobsPlan(id, playerInventory, (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (PartTypeTerminalCraftingJob)((Object)data.getMiddle()), craftingJobGuiData);
            }
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> {
            PacketCodec.write((FriendlyByteBuf)packetBuffer, (Object)partPos);
            packetBuffer.m_130070_(PartTypes.TERMINAL_CRAFTING_JOB.getUniqueName().toString());
            craftingJobGuiData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    protected ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(new ResourceLocation(this.craftingPlanHandler));
    }

    public static void send(BlockPos pos, Direction side, int channel, HandlerWrappedTerminalCraftingPlan craftingPlan) {
        CraftingJobGuiData data = new CraftingJobGuiData(pos, side, channel, craftingPlan.getHandler(), craftingPlan.getCraftingPlanFlat().getId());
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new OpenCraftingJobsPlanGuiPacket(data));
    }
}

