/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import java.util.List;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.AbstractPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.HatStandEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        registration.registerItemStorage(new HideItemsProvider(Supplementaries.res("present")), AbstractPresentBlockTile.class);
        registration.registerItemStorage(new HideItemsProvider(Supplementaries.res("safe")), SafeBlockTile.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerItemStorageClient(new HideItemsProvider(Supplementaries.res("present")));
        registration.registerItemStorageClient(new HideItemsProvider(Supplementaries.res("safe")));
        registration.registerEntityComponent((IEntityComponentProvider)new HatStandProvider(Supplementaries.res("hat_stand")), HatStandEntity.class);
    }

    public record HideItemsProvider<T extends BaseContainerBlockEntity>(ResourceLocation id) implements IServerExtensionProvider<T, ItemStack>,
    IClientExtensionProvider<ItemStack, ItemView>
    {
        public ResourceLocation getUid() {
            return this.id;
        }

        public List<ViewGroup<ItemStack>> getGroups(ServerPlayer player, ServerLevel world, T blockEntity, boolean showDetails) {
            if ((blockEntity instanceof SafeBlockTile || blockEntity instanceof AbstractPresentBlockTile) && blockEntity.m_7525_((Player)player)) {
                return ItemStorageProvider.INSTANCE.getGroups(player, world, blockEntity, showDetails);
            }
            return List.of();
        }

        public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
            return ClientViewGroup.map(groups, ItemView::new, null);
        }
    }

    public record HatStandProvider(ResourceLocation id) implements IEntityComponentProvider
    {
        public ResourceLocation getUid() {
            return this.id;
        }

        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            HatStandEntity entity = (HatStandEntity)accessor.getEntity();
            for (ItemStack stack : entity.m_6168_()) {
                if (stack.m_41619_()) continue;
                tooltip.add(IElementHelper.get().smallItem(stack));
                tooltip.append((Component)IDisplayHelper.get().stripColor(stack.m_41786_()));
            }
        }
    }
}

