/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientBoundParticlePacket
implements Message {
    public final Type type;
    @Nullable
    public final Vec3 pos;
    @Nullable
    public final Integer extraData;
    @Nullable
    public final Vec3 dir;

    public ClientBoundParticlePacket(FriendlyByteBuf buffer) {
        this.type = (Type)buffer.m_130066_(Type.class);
        this.extraData = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        this.pos = buffer.readBoolean() ? new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()) : null;
        this.dir = buffer.readBoolean() ? new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()) : null;
    }

    public ClientBoundParticlePacket(BlockPos pos, Type type) {
        this(Vec3.m_82512_((Vec3i)pos), type);
    }

    public ClientBoundParticlePacket(Vec3 pos, Type type) {
        this(pos, type, null);
    }

    public ClientBoundParticlePacket(Vec3 pos, Type type, Integer extraData) {
        this(pos, type, extraData, null);
    }

    public ClientBoundParticlePacket(Vec3 pos, Type type, Integer extraData, @Nullable Vec3 direction) {
        this.pos = pos;
        this.type = type;
        this.extraData = extraData;
        this.dir = direction;
    }

    public ClientBoundParticlePacket(Entity entity, Type type) {
        this(entity, type, null);
    }

    public ClientBoundParticlePacket(Entity entity, Type type, Vec3 dir) {
        this.extraData = entity.m_19879_();
        this.type = type;
        this.pos = null;
        this.dir = dir;
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        if (this.extraData != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.extraData.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.pos != null) {
            buffer.writeBoolean(true);
            buffer.writeDouble(this.pos.f_82479_);
            buffer.writeDouble(this.pos.f_82480_);
            buffer.writeDouble(this.pos.f_82481_);
        } else {
            buffer.writeBoolean(false);
        }
        if (this.dir != null) {
            buffer.writeBoolean(true);
            buffer.writeDouble(this.dir.f_82479_);
            buffer.writeDouble(this.dir.f_82480_);
            buffer.writeDouble(this.dir.f_82481_);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void handle(ChannelHandler.Context context) {
        ClientReceivers.handleSpawnBlockParticlePacket(this);
    }

    public static enum Type {
        BUBBLE_BLOW,
        BUBBLE_CLEAN,
        BUBBLE_CLEAN_ENTITY,
        BUBBLE_EAT,
        DISPENSER_MINECART,
        FLINT_BLOCK_IGNITE,
        WAX_ON,
        GLOW_ON,
        CONFETTI,
        CONFETTI_EXPLOSION,
        FEATHER,
        WRENCH_ROTATION,
        PEARL_TELEPORT;

    }
}

