/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.api.ritual.FocusItemPresentRequirement;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.RitualRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericRitualRecipe
extends RitualRecipe {
    ResourceLocation ritualRL;

    public GenericRitualRecipe(ResourceLocation id, ResourceLocation ritualRL, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, List<Ingredient> invariants, float healthRequirement) {
        super(id, reagent, pedestalItems, focusItems, invariants, healthRequirement);
        this.ritualRL = ritualRL;
    }

    @Override
    public Ritual getRitualWithRequirements() {
        Ritual ritual = super.getRitualWithRequirements();
        if (!this.invariantItems.isEmpty()) {
            ritual.addInvariants(this.invariantItems.stream().map(FocusItemPresentRequirement::new).collect(Collectors.toList()));
        }
        return ritual;
    }

    @Override
    public boolean isMatch(List<ItemStack> pedestalItems, List<ItemStack> focusItems, ItemStack reagent) {
        if (!this.invariantItems.isEmpty()) {
            focusItems.removeIf(i -> this.invariantItems.stream().anyMatch(ing -> ing.test(i)));
        }
        return super.isMatch(pedestalItems, focusItems, reagent);
    }

    @Override
    public Ritual getRitual() {
        return RitualRegistry.find(this.ritualRL);
    }

    @Override
    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon:ritual_brazier");
        jsonobject.addProperty("ritual", this.ritualRL.toString());
        GenericRitualRecipe.addRitualElements(this, jsonobject);
        return jsonobject;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.RITUAL_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.RITUAL_TYPE.get();
    }

    public static class Serializer
    extends RitualRecipe.Serializer<GenericRitualRecipe> {
        @NotNull
        public GenericRitualRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Ingredient reagent = Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"reagent"));
            float healthRequirement = json.has("healthRequirement") ? GsonHelper.m_13915_((JsonObject)json, (String)"healthRequirement") : 0.0f;
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            List<Ingredient> stacks = RitualRecipe.getPedestalItems(pedestalItems);
            JsonArray focusItems = GsonHelper.m_13933_((JsonObject)json, (String)"focusItems");
            List<Ingredient> foci = RitualRecipe.getPedestalItems(focusItems);
            ResourceLocation ritualRL = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"ritual"));
            ArrayList<Ingredient> invariants = json.has("invariantItems") ? RitualRecipe.getPedestalItems(GsonHelper.m_13933_((JsonObject)json, (String)"invariantItems")) : new ArrayList(0);
            return new GenericRitualRecipe(recipeId, ritualRL, reagent, stacks, foci, invariants, healthRequirement);
        }

        @Nullable
        public GenericRitualRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            int length = pBuffer.readInt();
            int length2 = pBuffer.readInt();
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            ArrayList<Ingredient> foci = new ArrayList<Ingredient>();
            for (int i = 0; i < length2; ++i) {
                try {
                    foci.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            float healthRequirement = pBuffer.readFloat();
            ResourceLocation ritualRL = pBuffer.m_130281_();
            int length3 = pBuffer.readInt();
            ArrayList<Ingredient> invariantItems = new ArrayList<Ingredient>();
            for (int i = 0; i < length3; ++i) {
                try {
                    invariantItems.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new GenericRitualRecipe(pRecipeId, ritualRL, reagent, stacks, foci, invariantItems, healthRequirement);
        }

        @Override
        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull GenericRitualRecipe recipe) {
            super.toNetwork(buf, recipe);
            buf.m_130085_(recipe.ritualRL);
            buf.writeInt(recipe.invariantItems.size());
            for (Ingredient i : recipe.invariantItems) {
                i.m_43923_(buf);
            }
        }
    }
}

