/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui;

import com.google.common.collect.Lists;
import elucent.eidolon.Config;
import elucent.eidolon.compat.CompatHandler;
import elucent.eidolon.compat.apotheosis.Apotheosis;
import elucent.eidolon.datagen.EidEnchantmentTagProvider;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;

public class SoulEnchanterContainer
extends AbstractContainerMenu {
    private static final String SOUL_ENCHANT_USES_TAG = "soul_enchant_uses";
    private final Container tableInventory = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            SoulEnchanterContainer.this.m_6199_((Container)this);
        }
    };
    private final ContainerLevelAccess worldPosCallable;
    private final Random rand = new Random();
    private final DataSlot xpSeed = DataSlot.m_39401_();
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] worldClue = new int[]{-1, -1, -1};

    public SoulEnchanterContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public SoulEnchanterContainer(int id, Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType)Registry.SOUL_ENCHANTER_CONTAINER.get(), id);
        this.worldPosCallable = worldPosCallable;
        this.m_38897_(new Slot(this.tableInventory, 0, 15, 47){

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.tableInventory, 1, 35, 47){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_41720_() == Registry.SOUL_SHARD.get();
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.xpSeed).m_6422_(playerInventory.f_35978_.m_36322_());
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)2));
        this.m_38895_(DataSlot.m_39406_((int[])this.worldClue, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.worldClue, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.worldClue, (int)2));
    }

    public void m_6199_(@NotNull Container inventoryIn) {
        if (inventoryIn == this.tableInventory) {
            ItemStack itemstack = inventoryIn.m_8020_(0);
            if (this.isValidItem(itemstack)) {
                this.worldPosCallable.m_39292_((world, pos) -> {
                    this.rand.setSeed(this.xpSeed.m_6501_());
                    for (int i1 = 0; i1 < 3; ++i1) {
                        this.enchantClue[i1] = -1;
                        this.worldClue[i1] = -1;
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        List<EnchantmentInstance> list = this.getEnchantmentList(itemstack, j1);
                        if (list.isEmpty()) continue;
                        EnchantmentInstance enchantmentdata = list.get(this.rand.nextInt(list.size()));
                        this.enchantClue[j1] = BuiltInRegistries.f_256876_.m_7447_((Object)enchantmentdata.f_44947_);
                        this.worldClue[j1] = enchantmentdata.f_44948_;
                    }
                    this.m_38946_();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.enchantClue[i] = -1;
                    this.worldClue[i] = -1;
                }
            }
        }
    }

    private boolean isValidItem(ItemStack itemStack) {
        return !itemStack.m_41619_() && this.canSoulEnchant(itemStack) && this.hasValidEnchantmentAmount(itemStack) && (itemStack.m_41792_() || itemStack.m_41793_() || itemStack.m_41720_() == Items.f_42690_);
    }

    private boolean hasValidEnchantmentAmount(ItemStack itemStack) {
        if ((Integer)Config.SOUL_ENCHANTER_MAXIMUM_ENCHANTMENTS.get() < 0) {
            return true;
        }
        return itemStack.getAllEnchantments().size() <= (Integer)Config.SOUL_ENCHANTER_MAXIMUM_ENCHANTMENTS.get();
    }

    private void incrementSoulEnchant(ItemStack enchantedItem) {
        if ((Integer)Config.SOUL_ENCHANTER_MAXIMUM_USES.get() < 0) {
            return;
        }
        CompoundTag tag = enchantedItem.m_41784_();
        tag.m_128405_(SOUL_ENCHANT_USES_TAG, tag.m_128451_(SOUL_ENCHANT_USES_TAG) + 1);
    }

    private boolean canSoulEnchant(ItemStack itemstack) {
        if ((Integer)Config.SOUL_ENCHANTER_MAXIMUM_USES.get() < 0) {
            return true;
        }
        CompoundTag tag = itemstack.m_41783_();
        if (tag != null) {
            int soulEnchantUses = tag.m_128451_(SOUL_ENCHANT_USES_TAG);
            return soulEnchantUses < (Integer)Config.SOUL_ENCHANTER_MAXIMUM_USES.get();
        }
        return true;
    }

    public boolean m_6366_(@NotNull Player playerIn, int id) {
        ItemStack itemstack = this.tableInventory.m_8020_(0);
        if (!this.isValidItem(itemstack)) {
            return false;
        }
        ItemStack soulShards = this.tableInventory.m_8020_(1);
        int i = id + 1;
        int experienceLevelCost = Math.min(5, this.worldClue[id]);
        if ((soulShards.m_41619_() || soulShards.m_41613_() < 1) && !playerIn.m_150110_().f_35937_) {
            return false;
        }
        if (itemstack.m_41619_() || playerIn.f_36078_ < experienceLevelCost && !playerIn.m_150110_().f_35937_) {
            return false;
        }
        this.worldPosCallable.m_39292_((p_217003_6_, p_217003_7_) -> {
            ItemStack itemstack2 = itemstack;
            List<EnchantmentInstance> list = this.getEnchantmentList(itemstack, id);
            if (!list.isEmpty()) {
                Map enchants;
                boolean flag;
                playerIn.m_7408_(itemstack, experienceLevelCost);
                boolean bl = flag = itemstack.m_41720_() == Items.f_42517_;
                if (flag) {
                    itemstack2 = new ItemStack((ItemLike)Items.f_42690_);
                    CompoundTag compoundnbt = itemstack.m_41783_();
                    if (compoundnbt != null) {
                        itemstack2.m_41751_(compoundnbt.m_6426_());
                    }
                    this.tableInventory.m_6836_(0, itemstack2);
                }
                if ((enchants = EnchantmentHelper.m_44831_((ItemStack)itemstack2)).size() > 0) {
                    for (EnchantmentInstance data : list) {
                        if (enchants.containsKey(data.f_44947_)) {
                            enchants.replace(data.f_44947_, data.f_44948_);
                            continue;
                        }
                        enchants.put(data.f_44947_, data.f_44948_);
                    }
                    EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)itemstack2);
                } else {
                    for (EnchantmentInstance data : list) {
                        if (flag) {
                            EnchantedBookItem.m_41153_((ItemStack)itemstack2, (EnchantmentInstance)data);
                            continue;
                        }
                        itemstack2.m_41663_(data.f_44947_, data.f_44948_);
                    }
                }
                if (!playerIn.m_150110_().f_35937_) {
                    this.incrementSoulEnchant(itemstack2);
                    soulShards.m_41774_(1);
                    if (soulShards.m_41619_()) {
                        this.tableInventory.m_6836_(1, ItemStack.f_41583_);
                    }
                }
                playerIn.m_36220_(Stats.f_12964_);
                if (playerIn instanceof ServerPlayer) {
                    CriteriaTriggers.f_10575_.m_27668_((ServerPlayer)playerIn, itemstack2, i);
                }
                this.tableInventory.m_6596_();
                this.xpSeed.m_6422_(playerIn.m_36322_());
                this.m_6199_(this.tableInventory);
                p_217003_6_.m_5594_(null, p_217003_7_, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, p_217003_6_.f_46441_.m_188501_() * 0.1f + 0.7f);
            }
        });
        return true;
    }

    public static int getEnchantmentLevel(Enchantment enchID, ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        ResourceLocation resourcelocation = BuiltInRegistries.f_256876_.m_7981_((Object)enchID);
        ListTag listnbt = stack.m_41720_() == Items.f_42690_ ? EnchantedBookItem.m_41163_((ItemStack)stack) : stack.m_41785_();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            ResourceLocation resourcelocation1 = ResourceLocation.m_135820_((String)compoundnbt.m_128461_("id"));
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            return Mth.m_14045_((int)compoundnbt.m_128451_("lvl"), (int)0, (int)255);
        }
        return 0;
    }

    private List<EnchantmentInstance> getEnchantmentList(ItemStack stack, int enchantSlot) {
        this.rand.setSeed(this.xpSeed.m_6501_() + enchantSlot);
        ItemStack test = stack.m_41777_();
        EnchantmentHelper.m_44865_(new HashMap(), (ItemStack)test);
        if (test.m_41720_() == Items.f_42690_) {
            test = new ItemStack((ItemLike)Items.f_42517_);
        }
        ItemStack finalTest = test;
        Map existing = EnchantmentHelper.m_44831_((ItemStack)stack);
        ArrayList valid = Lists.newArrayList((Iterable)ForgeRegistries.ENCHANTMENTS.getValues());
        ITag blacklist = Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.tags()).getTag(EidEnchantmentTagProvider.SOUL_ENCHANTER_BLACKLIST);
        valid.removeIf(enchantment -> {
            boolean canApply;
            if (blacklist.contains(enchantment)) {
                return true;
            }
            boolean bl = canApply = enchantment.m_6081_(finalTest) || finalTest.m_41720_() == Items.f_42517_ && enchantment.isAllowedOnBooks();
            if (!canApply || enchantment.m_6589_()) {
                return true;
            }
            if (CompatHandler.isModLoaded("apotheosis")) {
                return Apotheosis.isTreasureOnly(enchantment) || existing.containsKey(enchantment) && (Integer)existing.get(enchantment) >= Apotheosis.getMaxLevel(enchantment);
            }
            return enchantment.m_6591_() || existing.containsKey(enchantment) && (Integer)existing.get(enchantment) >= enchantment.m_6586_();
        });
        for (Map.Entry e : existing.entrySet()) {
            valid.removeIf(next -> !((Enchantment)e.getKey()).m_44695_(next) && e.getKey() != next);
        }
        ArrayList<EnchantmentInstance> enchants = new ArrayList<EnchantmentInstance>();
        if (valid.isEmpty()) {
            return enchants;
        }
        for (int i = 0; i < enchantSlot; ++i) {
            this.rand.nextInt(valid.size());
        }
        Enchantment enchant = (Enchantment)valid.get(this.rand.nextInt(valid.size()));
        int level = SoulEnchanterContainer.getEnchantmentLevel(enchant, stack);
        if (level > 0) {
            enchants.add(new EnchantmentInstance(enchant, level + 1));
        } else {
            enchants.add(new EnchantmentInstance(enchant, 1));
        }
        return enchants;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSoulShardAmount() {
        ItemStack itemstack = this.tableInventory.m_8020_(1);
        return itemstack.m_41619_() ? 0 : itemstack.m_41613_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getXPSeed() {
        return this.xpSeed.m_6501_();
    }

    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        this.worldPosCallable.m_39292_((world, pos) -> this.m_150411_(playerIn, this.tableInventory));
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return SoulEnchanterContainer.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)((Block)Registry.SOUL_ENCHANTER.get()));
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index == 1) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (itemstack1.m_41720_() == Registry.SOUL_SHARD.get()) {
                if (!this.m_38903_(itemstack1, 1, 2, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (((Slot)this.f_38839_.get(0)).m_6657_() || !((Slot)this.f_38839_.get(0)).m_5857_(itemstack1)) {
                    return ItemStack.f_41583_;
                }
                ItemStack itemstack2 = itemstack1.m_41777_();
                itemstack2.m_41764_(1);
                itemstack1.m_41774_(1);
                ((Slot)this.f_38839_.get(0)).m_5852_(itemstack2);
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }
}

