/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.network.CrystallizeEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class SummonRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = new ResourceLocation("eidolon", "particle/summon_ritual");
    final EntityType<?> entity;
    final int count;

    public EntityType<?> getEntityType() {
        return this.entity;
    }

    public int getCount() {
        return this.count;
    }

    public SummonRitual(EntityType<?> entity) {
        super(SYMBOL, ColorUtil.packColor(255, 121, 94, 255));
        this.entity = entity;
        this.count = 1;
    }

    public SummonRitual(EntityType<?> entity, int count) {
        super(SYMBOL, ColorUtil.packColor(255, 121, 94, 255));
        this.entity = entity;
        this.count = count;
    }

    @Override
    public Ritual cloneRitual() {
        return new SummonRitual(this.entity, this.count);
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            Networking.sendToTracking(world, pos, new CrystallizeEffectPacket(pos));
            for (int i = 0; i < this.count; ++i) {
                Entity e = this.entity.m_20615_(world);
                if (e == null) continue;
                e.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
                world.m_7967_(e);
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

