/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import com.mojang.datafixers.util.Pair;
import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.common.item.IRechargeableWand;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.common.item.SoulfireWandItem;
import elucent.eidolon.compat.CompatHandler;
import elucent.eidolon.compat.apotheosis.Apotheosis;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WandItem
extends ItemBase
implements IRechargeableWand {
    private static final double OFFSET = 1.5;

    public WandItem(Item.Properties properties) {
        super(properties);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 20;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return super.canApplyAtEnchantingTable(stack, enchant) || enchant == Enchantments.f_44986_ || enchant == Enchantments.f_44962_;
    }

    @Override
    public ItemStack recharge(ItemStack stack) {
        stack.m_41721_(0);
        return stack;
    }

    public InteractionResultHolder<ItemStack> handleCast(Level world, Player entity, InteractionHand hand, @NotNull EntityType<? extends SpellProjectileEntity> spellProjectile, SoundEvent soundEvent) {
        ItemStack stack = entity.m_21120_(hand);
        if (!world.m_5776_()) {
            Vec3 pos = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(0.5)).m_82520_(0.5 * Math.sin(Math.toRadians(225.0f - entity.f_20885_)), (double)(entity.m_20206_() * 2.0f / 3.0f), 0.5 * Math.cos(Math.toRadians(225.0f - entity.f_20885_)));
            Vec3 vel = entity.m_20299_(0.0f).m_82549_(entity.m_20154_().m_82490_(40.0)).m_82546_(pos).m_82490_(0.05);
            Pair affixData = CompatHandler.isModLoaded("apotheosis") ? Apotheosis.handleWandAffix(stack) : Pair.of((Object)1, (Object)0);
            int projectileAmount = (Integer)affixData.getFirst();
            int trackingAmount = (Integer)affixData.getSecond();
            for (int i = 0; i < projectileAmount; ++i) {
                SpellProjectileEntity spellProjectileEntity = (SpellProjectileEntity)spellProjectile.m_20615_(world);
                if (spellProjectileEntity == null) continue;
                if (trackingAmount > 0) {
                    spellProjectileEntity.isTracking = true;
                    --trackingAmount;
                }
                Vec3 randomized = Vec3.f_82478_;
                if (i > 0) {
                    randomized = new Vec3(SoulfireWandItem.random.nextDouble(-1.5, 1.5), SoulfireWandItem.random.nextDouble(-1.5, 1.5), SoulfireWandItem.random.nextDouble(-1.5, 1.5));
                    spellProjectileEntity.noImmunityFrame = true;
                }
                world.m_7967_(spellProjectileEntity.shoot(pos.f_82479_ + randomized.m_7096_(), pos.f_82480_ + randomized.m_7098_(), pos.f_82481_ + randomized.m_7094_(), vel.f_82479_, vel.f_82480_, vel.f_82481_, (Entity)entity, stack));
            }
            world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, soundEvent, SoundSource.NEUTRAL, 0.75f, SoulfireWandItem.random.nextFloat() * 0.2f + 0.9f);
            stack.m_41622_(1, (LivingEntity)entity, player -> player.m_21190_(hand));
            entity.m_36335_().m_41524_((Item)this, 15);
        }
        if (!entity.f_20911_) {
            entity.m_6674_(hand);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }
}

