/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.common.tile.WoodenStandTileEntity;
import elucent.eidolon.gui.WoodenBrewingStandContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class WoodenStandBlock
extends BrewingStandBlock {
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0));

    public WoodenStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new WoodenStandTileEntity(pos, state);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof WoodenStandTileEntity) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new WoodenBrewingStandContainer(id, inventory, (Container)((WoodenStandTileEntity)tileentity), ((WoodenStandTileEntity)tileentity).dataAccess), ((WoodenStandTileEntity)tileentity).m_5446_()), (BlockPos)pos);
            player.m_36220_(Stats.f_12948_);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = worldIn.m_7702_(pos)) instanceof WoodenStandTileEntity) {
            ((WoodenStandTileEntity)tileentity).m_58638_(stack.m_41786_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof WoodenStandTileEntity) {
                Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((WoodenStandTileEntity)tileentity));
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, pos, state1, tile) -> ((WoodenStandTileEntity)tile).tick();
    }
}

