/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;

public class HerbBlockBase
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)};

    public HerbBlockBase(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)AGE)];
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean canSustainPlant(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull IPlantable plantable) {
        return state.m_60713_((Block)Registry.PLANTER.get());
    }

    protected boolean m_6266_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return state.m_60713_((Block)Registry.PLANTER.get());
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 2;
    }

    public void m_213898_(@NotNull BlockState pState, @NotNull ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int i = this.getAge(pState);
        if (i < this.getMaxAge() && this.m_6266_(worldIn.m_8055_(pos.m_7495_()), (BlockGetter)worldIn, pos.m_7495_()) && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)pState, (random.m_188503_(20) == 0 ? 1 : 0) != 0)) {
            this.growCrops((Level)worldIn, pos, pState);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)pState);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    protected int getAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE);
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        int j;
        int i = this.getAge(pState) + 1;
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        pLevel.m_7731_(pPos, this.getStateForAge(i), 2);
    }

    private int getMaxAge() {
        return 2;
    }

    private boolean isMaxAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE) >= this.getMaxAge();
    }

    protected BlockState getStateForAge(int pAge) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(pAge));
    }

    public boolean m_7370_(@NotNull LevelReader pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, boolean pIsClient) {
        return !this.isMaxAge(pState);
    }

    public boolean m_214167_(@NotNull Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return (double)pRandom.m_188501_() < 0.35;
    }

    public void m_214148_(@NotNull ServerLevel pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.growCrops((Level)pLevel, pPos, pState);
    }
}

