/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon;

import com.google.common.collect.ImmutableSet;
import elucent.eidolon.Config;
import elucent.eidolon.client.ClientConfig;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.codex.CodexChapters;
import elucent.eidolon.common.item.AthameItem;
import elucent.eidolon.common.tile.BrazierTileRenderer;
import elucent.eidolon.common.tile.CenserRenderer;
import elucent.eidolon.common.tile.CrucibleTileRenderer;
import elucent.eidolon.common.tile.GobletTileRenderer;
import elucent.eidolon.common.tile.HandTileRenderer;
import elucent.eidolon.common.tile.NecroticFocusTileRenderer;
import elucent.eidolon.common.tile.SoulEnchanterTileRenderer;
import elucent.eidolon.compat.CompatHandler;
import elucent.eidolon.event.Events;
import elucent.eidolon.gui.ResearchTableScreen;
import elucent.eidolon.gui.SoulEnchanterScreen;
import elucent.eidolon.gui.WoodenBrewingStandScreen;
import elucent.eidolon.gui.WorktableScreen;
import elucent.eidolon.mixin.BlockEntityTypeAccessor;
import elucent.eidolon.network.Networking;
import elucent.eidolon.proxy.ClientProxy;
import elucent.eidolon.proxy.ISidedProxy;
import elucent.eidolon.proxy.ServerProxy;
import elucent.eidolon.registries.AltarEntries;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Researches;
import elucent.eidolon.registries.RitualRegistry;
import elucent.eidolon.registries.Runes;
import elucent.eidolon.registries.Spells;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="eidolon")
public class Eidolon {
    public static final ISidedProxy proxy = (ISidedProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final String MODID = "eidolon";
    public static final Logger LOG = LogManager.getLogger((String)"Eidolon Repraised");
    public static boolean trueMobType = false;

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static MobType getTrueMobType(LivingEntity e) {
        trueMobType = true;
        MobType type = e.m_6336_();
        trueMobType = false;
        return type;
    }

    public Eidolon() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::sendImc);
        modEventBus.addListener(this::spawnPlacements);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.register((Object)new Registry());
        Registry.init();
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        CompatHandler.initialize();
    }

    public void setup(FMLCommonSetupEvent event) {
        Networking.init();
        event.enqueueWork(() -> {
            Spells.init();
            RitualRegistry.init();
            EidolonRecipes.ritualRecipeTypes.addAll(List.of((RecipeType)EidolonRecipes.CRAFTING_RITUAL_TYPE.get(), (RecipeType)EidolonRecipes.SUMMON_RITUAL_TYPE.get(), (RecipeType)EidolonRecipes.COMMAND_RITUAL_TYPE.get(), (RecipeType)EidolonRecipes.LOCATION_RITUAL_TYPE.get(), (RecipeType)EidolonRecipes.RITUAL_TYPE.get()));
            EidolonPotions.addBrewingRecipes();
            AltarEntries.init();
            Researches.init();
            Runes.init();
            AthameItem.initHarvestables();
            Raid.RaiderType.create((String)"eidolon:necromancer", (EntityType)((EntityType)EidolonEntities.NECROMANCER.get()), (int[])new int[]{0, 0, 0, 0, 0, 1, 0, 1});
            Eidolon.addBlocksToTile(BlockEntityType.f_58924_, new Block[]{Registry.ILLWOOD_PLANKS.getStandingSign(), Registry.ILLWOOD_PLANKS.getWallSign(), Registry.POLISHED_PLANKS.getStandingSign(), Registry.POLISHED_PLANKS.getWallSign()});
            Eidolon.addBlocksToTile(BlockEntityType.f_244529_, new Block[]{Registry.ILLWOOD_PLANKS.getHangingSign(), Registry.ILLWOOD_PLANKS.getHangingWallSign(), Registry.POLISHED_PLANKS.getHangingSign(), Registry.POLISHED_PLANKS.getHangingWallSign()});
        });
    }

    public static void addBlocksToTile(BlockEntityType<?> bet, Block ... blocksToAdd) {
        Set<Block> oldSet = ((BlockEntityTypeAccessor)bet).getValidBlocks();
        if (oldSet instanceof ImmutableSet) {
            HashSet<Block> newSet = new HashSet<Block>();
            Collections.addAll(newSet, blocksToAdd);
            newSet.addAll(oldSet);
            ((BlockEntityTypeAccessor)bet).setValidBlocks(newSet);
        } else {
            Collections.addAll(oldSet, blocksToAdd);
        }
    }

    public void spawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)EidolonEntities.ZOMBIE_BRUTE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)EidolonEntities.WRAITH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)EidolonEntities.GIANT_SKEL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (pType, pLevel, pSpawnType, pPos, pRandom) -> pLevel.m_46791_() != Difficulty.PEACEFUL && Mob.m_217057_((EntityType)pType, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom), SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)EidolonEntities.RAVEN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)EidolonEntities.SLIMY_SLUG.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (e, w, t, pos, rand) -> true, SpawnPlacementRegisterEvent.Operation.AND);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.HAND_TILE_ENTITY.get()), trd -> new HandTileRenderer());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.BRAZIER_TILE_ENTITY.get()), trd -> new BrazierTileRenderer());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.NECROTIC_FOCUS_TILE_ENTITY.get()), trd -> new NecroticFocusTileRenderer());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.CRUCIBLE_TILE_ENTITY.get()), trd -> new CrucibleTileRenderer());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.SOUL_ENCHANTER_TILE_ENTITY.get()), trd -> new SoulEnchanterTileRenderer());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.GOBLET_TILE_ENTITY.get()), trd -> new GobletTileRenderer());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Registry.CENSER_TILE_ENTITY.get()), trd -> new CenserRenderer());
        event.enqueueWork(() -> {
            CodexChapters.init();
            MenuScreens.m_96206_((MenuType)((MenuType)Registry.WORKTABLE_CONTAINER.get()), WorktableScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registry.SOUL_ENCHANTER_CONTAINER.get()), SoulEnchanterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registry.WOODEN_STAND_CONTAINER.get()), WoodenBrewingStandScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registry.RESEARCH_TABLE_CONTAINER.get()), ResearchTableScreen::new);
            ClientRegistry.initCurios();
            Sheets.addWoodType((WoodType)Registry.ILLWOOD);
            Sheets.addWoodType((WoodType)Registry.POLISHED);
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = Events.rightClickLectern(e.getEntity(), e.getLevel(), e.getHitVec());
            if (result.m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerOverlays(RegisterGuiOverlaysEvent evt) {
        evt.registerAbove(VanillaGuiOverlay.PLAYER_HEALTH.id(), "hearts", (IGuiOverlay)new ClientRegistry.EidolonHearts());
        evt.registerBelow(VanillaGuiOverlay.CHAT_PANEL.id(), "mana_bar", (IGuiOverlay)new ClientRegistry.EidolonManaBar());
        evt.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "raven_charge", (IGuiOverlay)new ClientRegistry.EidolonRavenCharge());
    }

    public void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"consecration", (String)"holy_material", () -> "silver");
    }
}

