/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.structure.condition.StructureCondition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public record SampleDensityStructureCondition(Holder<DensityFunction> densityFunction, Optional<Double> minInclusive, Optional<Double> maxInclusive) implements StructureCondition
{
    public static final MapCodec<SampleDensityStructureCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208217_.fieldOf("density_function").forGetter(SampleDensityStructureCondition::densityFunction), (App)Codec.DOUBLE.optionalFieldOf("min_inclusive").forGetter(SampleDensityStructureCondition::minInclusive), (App)Codec.DOUBLE.optionalFieldOf("max_inclusive").forGetter(SampleDensityStructureCondition::maxInclusive)).apply((Applicative)instance, SampleDensityStructureCondition::new));

    @Override
    public boolean test(Structure.GenerationContext context, BlockPos pos) {
        ChunkGenerator chunkGenerator = context.f_226622_();
        if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) {
            return false;
        }
        NoiseBasedChunkGenerator chunkGenerator2 = (NoiseBasedChunkGenerator)chunkGenerator;
        DensityFunction df = ((DensityFunction)this.densityFunction.m_203334_()).m_207456_((DensityFunction.Visitor)new NoiseWiringHelper(context.f_226627_(), ((NoiseGeneratorSettings)chunkGenerator2.f_64318_.m_203334_()).f_209354_(), context.f_226624_(), ((RandomStateAccessor)context.f_226624_()).getRandom()));
        double density = df.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        boolean min = this.minInclusive.isEmpty() || density >= this.minInclusive.get();
        boolean max = this.maxInclusive.isEmpty() || density <= this.maxInclusive.get();
        return min && max;
    }

    @Override
    public MapCodec<? extends StructureCondition> codec() {
        return CODEC;
    }

    private static class NoiseWiringHelper
    implements DensityFunction.Visitor {
        private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
        private final boolean useLegacySource;
        private final long seed;
        final RandomState randomState;
        final PositionalRandomFactory random;

        private RandomSource newLegacyInstance(long noiseSeed) {
            return new LegacyRandomSource(this.seed + noiseSeed);
        }

        NoiseWiringHelper(long seed, boolean useLegacySource, RandomState randomState, PositionalRandomFactory random) {
            this.seed = seed;
            this.useLegacySource = useLegacySource;
            this.randomState = randomState;
            this.random = random;
        }

        public DensityFunction.NoiseHolder m_213918_(DensityFunction.NoiseHolder noiseHolder) {
            Holder noiseData = noiseHolder.f_223997_();
            if (this.useLegacySource) {
                if (noiseData.m_203565_(Noises.f_189269_)) {
                    NormalNoise noise = NormalNoise.m_230508_((RandomSource)this.newLegacyInstance(0L), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-7, 1.0, new double[]{1.0}));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
                if (noiseData.m_203565_(Noises.f_189278_)) {
                    NormalNoise noise = NormalNoise.m_230508_((RandomSource)this.newLegacyInstance(1L), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-7, 1.0, new double[]{1.0}));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
                if (noiseData.m_203565_(Noises.f_189286_)) {
                    NormalNoise noise = NormalNoise.m_230511_((RandomSource)this.random.m_224540_(Noises.f_189286_.m_135782_()), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(0, 0.0, new double[0]));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
            }
            NormalNoise noise = this.randomState.m_224560_((ResourceKey)noiseData.m_203543_().orElseThrow());
            return new DensityFunction.NoiseHolder(noiseData, noise);
        }

        private DensityFunction wrapNew(DensityFunction densityFunction) {
            if (densityFunction instanceof BlendedNoise) {
                BlendedNoise $$1 = (BlendedNoise)densityFunction;
                RandomSource $$2x = this.useLegacySource ? this.newLegacyInstance(0L) : this.random.m_224540_(new ResourceLocation("terrain"));
                return $$1.m_230483_($$2x);
            }
            return densityFunction instanceof DensityFunctions.EndIslandDensityFunction ? new DensityFunctions.EndIslandDensityFunction(this.seed) : densityFunction;
        }

        public DensityFunction m_214017_(DensityFunction densityFunction) {
            return this.wrapped.computeIfAbsent(densityFunction, this::wrapNew);
        }
    }
}

