/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.structure.condition.StructureCondition;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.levelgen.structure.Structure;

public record MultipleOfStructureCondition(List<StructureCondition> conditions, InclusiveRange<Integer> allowedCount) implements StructureCondition
{
    public static final MapCodec<MultipleOfStructureCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructureCondition.BASE_CODEC.listOf().fieldOf("conditions").forGetter(MultipleOfStructureCondition::conditions), (App)InclusiveRange.f_184562_.fieldOf("allowed_count").forGetter(MultipleOfStructureCondition::allowedCount)).apply((Applicative)instance, MultipleOfStructureCondition::new));

    @Override
    public boolean test(Structure.GenerationContext context, BlockPos pos) {
        int count = 0;
        for (StructureCondition condition : this.conditions) {
            if (!condition.test(context, pos) || (Integer)this.allowedCount.f_184564_() >= ++count) continue;
            return false;
        }
        return this.allowedCount.m_184578_((Comparable)Integer.valueOf(count));
    }

    @Override
    public MapCodec<? extends StructureCondition> codec() {
        return CODEC;
    }
}

