/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.structure.condition.StructureCondition;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;

public record HeightFilterStructureCondition(RangeType rangeType, Optional<Heightmap.Types> heightmap, InclusiveRange<Integer> permittedRange) implements StructureCondition
{
    public static final MapCodec<HeightFilterStructureCondition> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)RangeType.CODEC.fieldOf("range_type").forGetter(HeightFilterStructureCondition::rangeType), (App)Heightmap.Types.f_64274_.optionalFieldOf("heightmap").forGetter(HeightFilterStructureCondition::heightmap), (App)InclusiveRange.f_184562_.fieldOf("permitted_range").forGetter(HeightFilterStructureCondition::permittedRange)).apply((Applicative)instance, HeightFilterStructureCondition::new)), HeightFilterStructureCondition::validate);

    private DataResult<HeightFilterStructureCondition> validate() {
        if (this.rangeType == RangeType.HEIGHTMAP_RELATIVE && this.heightmap.isEmpty()) {
            return DataResult.error(() -> "Heightmap relative range type must be used with a heightmap");
        }
        return DataResult.success((Object)this);
    }

    @Override
    public boolean test(Structure.GenerationContext context, BlockPos pos) {
        if (this.heightmap.isEmpty()) {
            return this.permittedRange.m_184578_((Comparable)Integer.valueOf(pos.m_123342_()));
        }
        int heightmapY = context.f_226622_().m_223221_(pos.m_123341_(), pos.m_123343_(), this.heightmap.get(), context.f_226629_(), context.f_226624_());
        int y = this.rangeType == RangeType.ABSOLUTE ? heightmapY : pos.m_123342_() - heightmapY;
        return this.permittedRange.m_184578_((Comparable)Integer.valueOf(y));
    }

    @Override
    public MapCodec<? extends StructureCondition> codec() {
        return CODEC;
    }

    public static enum RangeType implements StringRepresentable
    {
        ABSOLUTE("absolute"),
        HEIGHTMAP_RELATIVE("heightmap_relative");

        public static final Codec<RangeType> CODEC;
        private final String name;

        private RangeType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(RangeType::values);
        }
    }
}

