/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.registry.LithostitchedForgeBiomeModifiers;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.AddBiomeSpawnsModifier;
import dev.worldgen.lithostitched.worldgen.modifier.AddFeaturesModifier;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.RemoveBiomeSpawnsModifier;
import dev.worldgen.lithostitched.worldgen.modifier.RemoveFeaturesModifier;
import dev.worldgen.lithostitched.worldgen.modifier.ReplaceClimateModifier;
import dev.worldgen.lithostitched.worldgen.modifier.ReplaceEffectsModifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.processor.condition.ProcessorCondition;
import dev.worldgen.lithostitched.worldgen.structure.condition.StructureCondition;
import dev.worldgen.lithostitched.worldgen.surface.LithostitchedSurfaceRules;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;

public final class LithostitchedBuiltInRegistries {
    private static final DeferredRegister<Codec<? extends Modifier>> DEFERRED_MODIFIER_TYPES = DeferredRegister.create(LithostitchedRegistryKeys.MODIFIER_TYPE, (String)"lithostitched");
    public static final Supplier<IForgeRegistry<Codec<? extends Modifier>>> MODIFIER_TYPE = DEFERRED_MODIFIER_TYPES.makeRegistry(() -> new RegistryBuilder().hasTags().disableSync().disableSaving());
    private static final DeferredRegister<Codec<? extends ModifierPredicate>> DEFERRED_MODIFIER_PREDICATE_TYPES = DeferredRegister.create(LithostitchedRegistryKeys.MODIFIER_PREDICATE_TYPE, (String)"lithostitched");
    public static final Supplier<IForgeRegistry<Codec<? extends ModifierPredicate>>> MODIFIER_PREDICATE_TYPE = DEFERRED_MODIFIER_PREDICATE_TYPES.makeRegistry(() -> new RegistryBuilder().hasTags().disableSync().disableSaving());
    private static final DeferredRegister<MapCodec<? extends StructureCondition>> DEFERRED_STRUCTURE_CONDITION_TYPES = DeferredRegister.create(LithostitchedRegistryKeys.STRUCTURE_CONDITION_TYPE, (String)"lithostitched");
    public static final Supplier<IForgeRegistry<MapCodec<? extends StructureCondition>>> STRUCTURE_CONDITION_TYPE = DEFERRED_STRUCTURE_CONDITION_TYPES.makeRegistry(() -> new RegistryBuilder().hasTags().disableSync().disableSaving());
    private static final DeferredRegister<MapCodec<? extends ProcessorCondition>> DEFERRED_PROCESSOR_CONDITION_TYPES = DeferredRegister.create(LithostitchedRegistryKeys.PROCESSOR_CONDITION_TYPE, (String)"lithostitched");
    public static final Supplier<IForgeRegistry<MapCodec<? extends ProcessorCondition>>> PROCESSOR_CONDITION_TYPE = DEFERRED_PROCESSOR_CONDITION_TYPES.makeRegistry(() -> new RegistryBuilder().hasTags().disableSync().disableSaving());
    private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"lithostitched");

    public static void init(IEventBus bus) {
        bus.addListener(event -> {
            event.register(Registries.f_256815_, helper -> helper.register(LithostitchedCommon.createResourceKey(Registries.f_256815_, "transient_merged"), (Object)LithostitchedSurfaceRules.TransientMergedRuleSource.CODEC.f_216232_()));
            LithostitchedCommon.registerCommonBlockPredicateTypes((name, type) -> LithostitchedBuiltInRegistries.register(event, Registries.f_256774_, name, type));
            LithostitchedCommon.registerCommonStateProviders((name, type) -> LithostitchedBuiltInRegistries.register(event, Registries.f_256891_, name, type));
            LithostitchedCommon.registerCommonPlacementModifiers((name, type) -> LithostitchedBuiltInRegistries.register(event, Registries.f_256843_, name, type));
            LithostitchedCommon.registerCommonFeatureTypes((name, feature) -> LithostitchedBuiltInRegistries.register(event, Registries.f_256833_, name, feature));
            LithostitchedCommon.registerCommonPoolElementTypes((name, type) -> LithostitchedBuiltInRegistries.register(event, Registries.f_257024_, name, type));
            LithostitchedCommon.registerCommonDensityFunctions((name, codec) -> LithostitchedBuiltInRegistries.register(event, Registries.f_256746_, name, codec));
            LithostitchedCommon.registerCommonStructureTypes((name, type) -> LithostitchedBuiltInRegistries.register(event, Registries.f_256938_, name, type));
            LithostitchedCommon.registerCommonStructureProcessors((name, type) -> LithostitchedBuiltInRegistries.register(event, Registries.f_256983_, name, type));
            LithostitchedCommon.registerCommonBlockEntityModifiers((name, type) -> LithostitchedBuiltInRegistries.register(event, Registries.f_276428_, name, type));
        });
        bus.addListener(event -> event.dataPackRegistry(LithostitchedRegistryKeys.WORLDGEN_MODIFIER, Modifier.CODEC));
        LithostitchedCommon.registerCommonModifiers((name, codec) -> DEFERRED_MODIFIER_TYPES.register(name, () -> codec));
        LithostitchedBuiltInRegistries.registerForgeModifiers((name, codec) -> DEFERRED_MODIFIER_TYPES.register(name, () -> codec));
        DEFERRED_MODIFIER_TYPES.register(bus);
        LithostitchedCommon.registerCommonModifierPredicates((name, codec) -> DEFERRED_MODIFIER_PREDICATE_TYPES.register(name, () -> codec));
        DEFERRED_MODIFIER_PREDICATE_TYPES.register(bus);
        LithostitchedCommon.registerCommonStructureConditions((name, codec) -> DEFERRED_STRUCTURE_CONDITION_TYPES.register(name, () -> codec));
        DEFERRED_STRUCTURE_CONDITION_TYPES.register(bus);
        LithostitchedCommon.registerCommonProcessorConditions((name, codec) -> DEFERRED_PROCESSOR_CONDITION_TYPES.register(name, () -> codec));
        DEFERRED_PROCESSOR_CONDITION_TYPES.register(bus);
        LithostitchedBuiltInRegistries.registerForgeBiomeModifiers((name, codec) -> BIOME_MODIFIER_TYPES.register(name, () -> codec));
        BIOME_MODIFIER_TYPES.register(bus);
    }

    private static <T> void register(RegisterEvent event, ResourceKey<Registry<T>> registry, String name, T object) {
        event.register(registry, helper -> helper.register(LithostitchedCommon.createResourceKey(registry, name), object));
    }

    public static void registerForgeModifiers(BiConsumer<String, Codec<? extends Modifier>> consumer) {
        consumer.accept("add_biome_spawns", AddBiomeSpawnsModifier.CODEC);
        consumer.accept("add_features", AddFeaturesModifier.CODEC);
        consumer.accept("remove_biome_spawns", RemoveBiomeSpawnsModifier.CODEC);
        consumer.accept("remove_features", RemoveFeaturesModifier.CODEC);
        consumer.accept("replace_climate", ReplaceClimateModifier.CODEC);
        consumer.accept("replace_effects", ReplaceEffectsModifier.CODEC);
    }

    public static void registerForgeBiomeModifiers(BiConsumer<String, Codec<? extends BiomeModifier>> consumer) {
        consumer.accept("replace_climate", LithostitchedForgeBiomeModifiers.ReplaceClimateBiomeModifier.CODEC);
        consumer.accept("replace_effects", LithostitchedForgeBiomeModifiers.ReplaceEffectsBiomeModifier.CODEC);
    }
}

