/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedFallbackRuntime;
import com.almostreliable.unified.compat.HideHelper;
import com.almostreliable.unified.compat.RecipeIndicator;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.recipe.CRTLookup;
import com.almostreliable.unified.recipe.ClientRecipeTracker;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeDecorator;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@EmiEntrypoint
public class AlmostEMI
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addRecipeDecorator((EmiRecipeDecorator)new IndicatorDecorator());
        AlmostUnifiedFallbackRuntime.getInstance().reload();
        Boolean emiDisabled = AlmostUnified.getRuntime().getUnifyConfig().map(UnifyConfig::reiOrJeiDisabled).orElse(false);
        if (emiDisabled.booleanValue()) {
            return;
        }
        for (ItemStack item : HideHelper.getStacksToHide()) {
            registry.removeEmiStacks(EmiStack.of((ItemStack)item));
        }
    }

    private static class IndicatorDecorator
    implements EmiRecipeDecorator {
        private IndicatorDecorator() {
        }

        public void decorateRecipe(EmiRecipe recipe, WidgetHolder widgets) {
            ResourceLocation recipeId = recipe.getId();
            if (recipeId == null) {
                return;
            }
            ClientRecipeTracker.ClientRecipeLink link = CRTLookup.getLink(recipeId);
            if (link == null) {
                return;
            }
            int pX = recipe.getDisplayWidth() - 5;
            int pY = recipe.getDisplayHeight() - 3;
            int size = 9;
            widgets.addDrawable(0, 0, 0, 0, (guiGraphics, mX, mY, delta) -> RecipeIndicator.renderIndicator(guiGraphics, pX, pY, size));
            widgets.addTooltipText(RecipeIndicator.constructTooltip(link), pX, pY, size, size);
        }
    }
}

