/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.compat;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.fluid.DelightfulFluids;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.IConfigured;
import net.brnbrd.delightful.common.item.food.GreenTeaLeavesItem;
import net.brnbrd.delightful.common.item.knife.DelightfulKnifeItem;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.utility.TextUtils;

@ParametersAreNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Util.rl("delightful", "jei_plugin");

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<ItemStack> hidden = new ArrayList<ItemStack>(DelightfulItems.ITEMS.getEntries().stream().filter(i -> {
            IConfigured c;
            Object patt1607$temp = i.get();
            return patt1607$temp instanceof IConfigured ? !(c = (IConfigured)patt1607$temp).enabled() : !Util.enabled((RegistryObject<Item>)i);
        }).map(Util::gs).toList());
        this.hide(hidden, "vintagedelight", "pb_j", new String[0]);
        this.hide(hidden, "undergardendelight", "gloomgourd_pie_slice", new String[0]);
        this.hide(hidden, "incubation", "fried_egg", new String[0]);
        this.hide(hidden, "naturalist", "cooked_egg", new String[0]);
        this.hide(hidden, "additionaladditions", "fried_egg", new String[0]);
        this.hide(hidden, "additionaladditions", "honeyed_apple", "buzzier_bees");
        this.hide(hidden, "moredelight", "bread_slice", "some_assembly_required");
        this.hide(hidden, "moredelight", "toast", "some_assembly_required");
        this.hide(hidden, "cratedelight", "berry_crate", "berry_good");
        this.hide(hidden, "cratedelight", "glowberry_crate", "berry_good");
        this.hide(hidden, "cratedelight", "cod_crate", "crabbersdelight");
        this.hide(hidden, "cratedelight", "salmon_crate", "crabbersdelight");
        this.hide(hidden, "cratedelight", "egg_crate", "incubation");
        this.hide(hidden, "cratedelight", "sugar_bag", "supplementaries");
        this.hide(hidden, "cratedelight", "apple_crate", "fruitsdelight");
        if (!hidden.isEmpty()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hidden);
        }
        if (!Mods.loaded("farmersrespite")) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack((Fluid)DelightfulFluids.AZALEA_TEA.get(), 1000), new FluidStack((Fluid)DelightfulFluids.LAVENDER_TEA.get(), 1000)));
        }
        DelightfulItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(k -> {
            DelightfulKnifeItem dk;
            return k instanceof DelightfulKnifeItem && (dk = (DelightfulKnifeItem)k).enabled();
        }).map(ItemStack::new).forEach(i -> registration.addIngredientInfo(i, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.knife", (Object[])new Object[0])}));
        if (Util.enabled(DelightfulItems.SALMONBERRIES)) {
            registration.addIngredientInfo(List.of(Util.gs(DelightfulItems.SALMONBERRIES), Util.gs(DelightfulItems.WILD_SALMONBERRIES)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.salmonberries.desc")});
        }
        if (((GreenTeaLeavesItem)DelightfulItems.GREEN_TEA_LEAF.get()).enabled()) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.GREEN_TEA_LEAF), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.green_tea_leaf.desc")});
        }
        if (Util.enabled(DelightfulItems.ACORN)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.ACORN), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.acorn.desc")});
        }
        if (Util.enabled(DelightfulItems.MINI_MELON)) {
            registration.addIngredientInfo(List.of(new ItemStack((ItemLike)Items.f_42575_), Util.gs(DelightfulItems.MINI_MELON)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.mini_melon.desc")});
        }
        if (Util.enabled(DelightfulItems.CANTALOUPE)) {
            registration.addIngredientInfo(List.of(Util.gs(DelightfulItems.CANTALOUPE_SLICE), Util.gs(DelightfulItems.CANTALOUPE)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.cantaloupe.desc").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"delightful.sliceable.desc"))});
        }
        if (Util.enabled(DelightfulItems.CANTALOUPE_SEEDS)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.CANTALOUPE_SEEDS), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.cantaloupe_seeds.desc")});
        }
        if (Util.enabled(DelightfulItems.ANIMAL_FAT)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.ANIMAL_FAT), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.animal_fat.desc")});
        }
        if (Util.enabled(DelightfulItems.ANIMAL_OIL_BOTTLE)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.ANIMAL_OIL_BOTTLE), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.animal_oil_bottle.desc")});
        }
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)Items.f_42028_), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.sliceable.desc")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)Items.f_42046_), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.sliceable.desc")});
    }

    private void hide(List<ItemStack> hiddenList, String modid, String item, String ... conflicts) {
        Item found;
        if (Mods.loaded(modid) && Mods.orLoaded(false, conflicts) && (found = Util.item(modid, item)) != null) {
            hiddenList.add(new ItemStack((ItemLike)found));
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

