/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.loot.DelightfulLootModifiers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemLootModifier
extends LootModifier {
    public static final Codec<AddItemLootModifier> CODEC = RecordCodecBuilder.create(inst -> AddItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(g -> g.item)).and((App)Codec.INT.fieldOf("minAmount").forGetter(g -> g.minAmount)).and((App)Codec.INT.fieldOf("maxAmount").forGetter(g -> g.maxAmount)).and((App)Codec.BOOL.fieldOf("unique").forGetter(g -> g.unique)).apply((Applicative)inst, AddItemLootModifier::new));
    protected final Item item;
    protected final int minAmount;
    protected final int maxAmount;
    protected final boolean unique;

    public AddItemLootModifier(LootItemCondition[] conditions, Item item, int minAmount, int maxAmount, boolean unique) {
        super(conditions);
        this.item = item;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.unique = unique;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.unique && generatedLoot.stream().anyMatch(stack -> stack.m_41720_().equals(this.item)) || this.maxAmount < 1) {
            return generatedLoot;
        }
        int amount = this.minAmount == this.maxAmount ? this.minAmount : context.m_230907_().m_188503_(this.maxAmount + 1 - this.minAmount) + this.minAmount;
        return amount >= 1 ? Util.with(generatedLoot, new ItemStack((ItemLike)this.item, amount)) : generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)DelightfulLootModifiers.ADD_ITEM.get();
    }
}

