/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.block;

import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;

public class SalmonberryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;
    private static final VoxelShape SAPLING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public SalmonberryBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return (Integer)state.m_61143_((Property)AGE) <= 2 ? Util.gs(DelightfulItems.SALMONBERRY_PIPS) : ((Item)DelightfulItems.SALMONBERRIES.get()).m_7968_();
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        if ((Integer)state.m_61143_((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return this.isMaxAge(state) ? super.m_5940_(state, pLevel, pPos, pContext) : MID_GROWTH_SHAPE;
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int i = (Integer)pState.m_61143_((Property)AGE);
        if (i < 4 && pLevel.m_45524_(pPos.m_7494_(), 0) >= 8) {
            int speed = 20;
            Biome biome = (Biome)pLevel.m_204166_(pPos).m_203334_();
            if (pLevel.m_46758_(pPos) && biome.m_264600_(pPos) == Biome.Precipitation.RAIN && biome.m_198906_(pPos)) {
                speed -= 15;
            } else if (pLevel.m_46471_()) {
                speed -= 12;
            }
            if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_(speed) == 0 ? 1 : 0) != 0)) {
                BlockState blockstate = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
                pLevel.m_7731_(pPos, blockstate, 2);
                pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)blockstate));
                ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        boolean flag = this.isMaxAge(state);
        if (!flag && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if ((Integer)state.m_61143_((Property)AGE) > 2) {
            SalmonberryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)Util.gs(DelightfulItems.SALMONBERRIES, flag ? 2 + level.f_46441_.m_188503_(2) : 1));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, blockstate, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(@NotNull LevelReader pLevel, @NotNull BlockPos pPos, @NotNull BlockState state, boolean pIsClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(@NotNull Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, BlockState pState) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(4, (Integer)pState.m_61143_((Property)AGE) + 1))), 2);
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) >= 4;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }
}

