/*
 * Decompiled with CFR 0.152.
 */
package dev.tonimatas.packetfixer.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;

public class Config {
    private static Properties properties = null;

    public static void runProperties() {
        try {
            File configFolder = new File("config");
            if (!configFolder.exists()) {
                configFolder.mkdirs();
            }
            File propertiesFile = new File(configFolder, "packetfixer.properties");
            properties = new Properties();
            if (!propertiesFile.exists()) {
                propertiesFile.createNewFile();
                properties.setProperty("nbtMaxSize", Long.toString(0xC800000L));
                properties.setProperty("packetSize", Integer.toString(0x6400000));
                properties.setProperty("decoderSize", Integer.toString(0x32000000));
                properties.setProperty("varInt21", Integer.toString(8));
                properties.setProperty("utfSize", Integer.toString(Short.MAX_VALUE));
                Config.save(propertiesFile);
            }
            properties.load(Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]));
            Config.checkVariable("nbtMaxSize", Long.toString(0xC800000L));
            Config.checkVariable("packetSize", Integer.toString(0x6400000));
            Config.checkVariable("decoderSize", Integer.toString(0x32000000));
            Config.checkVariable("varInt21", Integer.toString(8));
            Config.checkVariable("utfSize", Integer.toString(3276700));
            Config.save(propertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getNbtMaxSize() {
        if (properties == null) {
            Config.runProperties();
        }
        return Long.parseLong(properties.getProperty("nbtMaxSize"));
    }

    public static int getPacketSize() {
        if (properties == null) {
            Config.runProperties();
        }
        return Integer.parseInt(properties.getProperty("packetSize"));
    }

    public static int getDecoderSize() {
        if (properties == null) {
            Config.runProperties();
        }
        return Integer.parseInt(properties.getProperty("decoderSize"));
    }

    public static int getVarInt21Size() {
        if (properties == null) {
            Config.runProperties();
        }
        return Integer.parseInt(properties.getProperty("varInt21"));
    }

    public static int getUtf8Size() {
        if (properties == null) {
            Config.runProperties();
        }
        return Integer.parseInt(properties.getProperty("utfSize"));
    }

    private static void checkVariable(String variable, String defaultValue) {
        if (properties.getProperty(variable) == null) {
            properties.setProperty(variable, defaultValue);
        }
    }

    private static void save(File propertiesFile) throws IOException {
        properties.store(Files.newOutputStream(propertiesFile.toPath(), new OpenOption[0]), "Packet Fixer config file.\nDefault values (minecraft default): nbtMaxSize 2097152, packetSize 1048576, decoderSize 2097152 and varInt21Size 3.\nMax values are 2147483647 for packetSize/decoderSize/varInt21 and 9223372036854775807 for nbtMaxSize.");
    }
}

