/*
 * Decompiled with CFR 0.152.
 */
package com.nothome.delta.text;

import gnu.trove.TLongIntHashMap;
import gnu.trove.decorator.TLongIntHashMapDecorator;
import java.io.IOException;
import java.nio.CharBuffer;

public class Checksum {
    public static boolean debug = false;
    protected TLongIntHashMap checksums = new TLongIntHashMap();
    private static final char[] single_hash = com.nothome.delta.Checksum.getSingleHash();

    public Checksum(Readable source, int chunkSize) throws IOException {
        CharBuffer bb = CharBuffer.allocate(chunkSize * 2);
        int count = 0;
        while (true) {
            source.read(bb);
            bb.flip();
            if (bb.remaining() < chunkSize) break;
            while (bb.remaining() >= chunkSize) {
                long queryChecksum = Checksum.queryChecksum0(bb, chunkSize);
                this.checksums.put(queryChecksum, count++);
            }
            bb.compact();
        }
    }

    public static long queryChecksum(CharBuffer bb, int len) {
        bb.mark();
        long sum = Checksum.queryChecksum0(bb, len);
        bb.reset();
        return sum;
    }

    private static byte b(char c) {
        return (byte)c;
    }

    private static long queryChecksum0(CharBuffer bb, int len) {
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            high += (low += single_hash[Checksum.b(bb.get()) + 128]);
        }
        return (high & 0xFFFF) << 16 | low & 0xFFFF;
    }

    public static long incrementChecksum(long checksum, char out, char in, int chunkSize) {
        char old_c = single_hash[Checksum.b(out) + 128];
        char new_c = single_hash[Checksum.b(in) + 128];
        int low = (int)(checksum & 0xFFFFL) - old_c + new_c & 0xFFFF;
        int high = (int)(checksum >> 16) - old_c * chunkSize + low & 0xFFFF;
        return high << 16 | low & 0xFFFF;
    }

    public int findChecksumIndex(long hashf) {
        if (!this.checksums.contains(hashf)) {
            return -1;
        }
        return this.checksums.get(hashf);
    }

    public String toString() {
        return super.toString() + " checksums=" + new TLongIntHashMapDecorator(this.checksums) + "";
    }
}

