/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.forge.lootmanager;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class DetectRSLootTables
implements LootItemCondition {
    public static final LootItemConditionType DETECT_RS_LOOT_TABLES = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    private final Set<ResourceLocation> blacklistedLootTableIds;

    private DetectRSLootTables(Set<ResourceLocation> blacklistedLootTableIds) {
        this.blacklistedLootTableIds = blacklistedLootTableIds;
    }

    public LootItemConditionType m_7940_() {
        return DETECT_RS_LOOT_TABLES;
    }

    public boolean test(LootContext lootContext) {
        ResourceLocation lootTableID = lootContext.getQueriedLootTableId();
        return !this.blacklistedLootTableIds.contains(lootTableID);
    }

    public static Builder builder(Set<ResourceLocation> blacklistedLootTableIds) {
        return new Builder(blacklistedLootTableIds);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Set<ResourceLocation> blacklistedLootTableIds;

        public Builder(Set<ResourceLocation> blacklistedLootTableIds) {
            if (blacklistedLootTableIds == null) {
                throw new IllegalArgumentException("Blacklisted loot table must not be null. Use \"blacklisted_loot_tables\":[] to denote no blacklist.");
            }
            this.blacklistedLootTableIds = blacklistedLootTableIds;
        }

        public LootItemCondition m_6409_() {
            return new DetectRSLootTables(this.blacklistedLootTableIds);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<DetectRSLootTables> {
        Gson gson = new Gson();
        Type type = new TypeToken<List<String>>(){}.getType();

        public void serialize(JsonObject object, DetectRSLootTables instance, JsonSerializationContext ctx) {
            object.addProperty("loot_table_id", instance.blacklistedLootTableIds.toString());
        }

        public DetectRSLootTables deserialize(JsonObject object, JsonDeserializationContext ctx) {
            List unconvertedLootTableStrings = (List)this.gson.fromJson((JsonElement)GsonHelper.m_13933_((JsonObject)object, (String)"blacklisted_loot_tables"), this.type);
            Set<ResourceLocation> convertedLootTableStrings = unconvertedLootTableStrings.stream().map(ResourceLocation::new).collect(Collectors.toSet());
            return new DetectRSLootTables(convertedLootTableStrings);
        }
    }
}

