/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import earth.terrarium.adastra.client.dimension.ModDimensionSpecialEffects;
import earth.terrarium.adastra.client.dimension.MovementType;
import earth.terrarium.adastra.client.dimension.PlanetRenderer;
import earth.terrarium.adastra.client.utils.DimensionRenderingUtils;
import earth.terrarium.adastra.mixins.client.LevelRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ModSkyRenderer {
    private final PlanetRenderer renderer;
    @Nullable
    private VertexBuffer starBuffer;

    public ModSkyRenderer(PlanetRenderer renderer) {
        this.renderer = renderer;
    }

    public void render(ClientLevel level, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        setupFog.run();
        if (isFoggy || this.inFog(camera)) {
            return;
        }
        if (!this.renderer.renderInRain() && level.m_46471_()) {
            return;
        }
        if (this.starBuffer == null) {
            this.createStars();
        }
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        this.setSkyColor(level, camera, partialTick);
        RenderSystem.depthMask((boolean)false);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        this.renderSky(bufferBuilder, level, partialTick, poseStack, projectionMatrix);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_85836_();
        this.renderStars(level, partialTick, poseStack, projectionMatrix, setupFog);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderer.skyRenderables().forEach(renderable -> {
            Vec3 globalRotation = switch (renderable.movementType()) {
                default -> throw new IncompatibleClassChangeError();
                case MovementType.STATIC -> renderable.globalRotation();
                case MovementType.TIME_OF_DAY -> renderable.globalRotation().m_82520_(0.0, 0.0, (double)(level.m_46942_(partialTick) * 360.0f));
                case MovementType.TIME_OF_DAY_REVERSED -> renderable.globalRotation().m_82520_(0.0, 0.0, (double)(-level.m_46942_(partialTick) * 360.0f));
            };
            this.renderSkyRenderable(bufferBuilder, poseStack, renderable.localRotation(), globalRotation, renderable.scale(), renderable.texture(), renderable.blend());
            if (renderable.backLightScale() > 0.0f) {
                this.setSkyRenderableColor(level, partialTick, renderable.backLightColor());
                this.renderSkyRenderable(bufferBuilder, poseStack, renderable.localRotation(), globalRotation, renderable.backLightScale(), DimensionRenderingUtils.BACKLIGHT, true);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85849_();
        RenderSystem.depthMask((boolean)true);
    }

    public boolean inFog(Camera camera) {
        LevelRendererAccessor levelRenderer = (LevelRendererAccessor)Minecraft.m_91087_().f_91060_;
        FogType fogType = camera.m_167685_();
        return fogType == FogType.POWDER_SNOW || fogType == FogType.LAVA || levelRenderer.invokeDoesMobEffectBlockSky(camera);
    }

    public void setSkyColor(ClientLevel level, Camera camera, float partialTick) {
        Vec3 skyColor = level.m_171660_(camera.m_90583_(), partialTick);
        float r = (float)skyColor.f_82479_;
        float g = (float)skyColor.f_82480_;
        float b = (float)skyColor.f_82481_;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
    }

    public void renderSky(BufferBuilder bufferBuilder, ClientLevel level, float partialTick, PoseStack poseStack, Matrix4f projectionMatrix) {
        FogRenderer.m_109036_();
        ShaderInstance shader = RenderSystem.getShader();
        if (shader == null) {
            return;
        }
        VertexBuffer skyBuffer = ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getSkyBuffer();
        skyBuffer.m_85921_();
        skyBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shader);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        float[] color = ModDimensionSpecialEffects.getSunriseColor(level.m_46942_(partialTick), partialTick, this.renderer.sunriseColor());
        if (color != null) {
            this.renderSunrise(bufferBuilder, level, partialTick, poseStack, color);
        }
    }

    public void renderSunrise(BufferBuilder bufferBuilder, ClientLevel level, float partialTick, PoseStack poseStack, float[] color) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.renderer.sunriseAngle()));
        float sunAngle = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
        poseStack.m_252781_(Axis.f_252403_.m_252977_(sunAngle));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        float r = color[0];
        float g = color[1];
        float b = color[2];
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix, 0.0f, 100.0f, 0.0f).m_85950_(r, g, b, color[3]).m_5752_();
        for (int i = 0; i <= 16; ++i) {
            float angle = (float)i * ((float)Math.PI * 2) / 16.0f;
            float x = Mth.m_14031_((float)angle);
            float y = Mth.m_14089_((float)angle);
            bufferBuilder.m_252986_(matrix, x * 120.0f, y * 120.0f, -y * 40.0f * color[3]).m_85950_(r, g, b, 0.0f).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
    }

    public void renderSkyRenderable(BufferBuilder bufferBuilder, PoseStack poseStack, Vec3 localRotation, Vec3 globalRotation, float scale, ResourceLocation texture, boolean blend) {
        if (blend) {
            RenderSystem.enableBlend();
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)globalRotation.f_82479_));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)globalRotation.f_82480_));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)globalRotation.f_82481_));
        poseStack.m_252880_(0.0f, 100.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)localRotation.f_82479_));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)localRotation.f_82480_));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)localRotation.f_82481_));
        poseStack.m_252880_(0.0f, -100.0f, 0.0f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, -scale, 100.0f, -scale).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, scale, 100.0f, -scale).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, scale, 100.0f, scale).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, -scale, 100.0f, scale).m_7421_(1.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    public void setSkyRenderableColor(ClientLevel level, float partialTick, int color) {
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float a = this.renderer.renderInRain() ? 1.0f : 1.0f - level.m_46722_(partialTick);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public void renderStars(ClientLevel level, float partialTick, PoseStack poseStack, Matrix4f projectionMatrix, Runnable setupFog) {
        float starLight = this.renderer.starBrightness().orElseGet(() -> {
            float rainLevel = 1.0f - level.m_46722_(partialTick);
            return Float.valueOf(level.m_104811_(partialTick) * rainLevel);
        }).floatValue();
        if (starLight <= 0.0f) {
            return;
        }
        if (this.starBuffer == null) {
            return;
        }
        RenderSystem.setShaderColor((float)starLight, (float)starLight, (float)starLight, (float)starLight);
        FogRenderer.m_109017_();
        this.starBuffer.m_85921_();
        ShaderInstance shader = GameRenderer.m_172811_();
        if (shader == null) {
            return;
        }
        this.starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shader);
        VertexBuffer.m_85931_();
        setupFog.run();
    }

    public void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer renderedBuffer = this.drawStars(bufferBuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
    }

    public BufferBuilder.RenderedBuffer drawStars(BufferBuilder builder) {
        RandomSource random = RandomSource.m_216335_((long)10842L);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < this.renderer.stars(); ++i) {
            double x = random.m_188501_() * 2.0f - 1.0f;
            double y = random.m_188501_() * 2.0f - 1.0f;
            double z = random.m_188501_() * 2.0f - 1.0f;
            double scale = 0.15 + (double)random.m_188501_() * 0.1;
            double distance = x * x + y * y + z * z;
            if (distance >= 1.0 || distance <= 0.01) continue;
            distance = 1.0 / Math.sqrt(distance);
            double xScale = (x *= distance) * 100.0;
            double yScale = (y *= distance) * 100.0;
            double zScale = (z *= distance) * 100.0;
            double theta = Math.atan2(x, z);
            double sinTheta = Math.sin(theta);
            double cosTheta = Math.cos(theta);
            double phi = Math.atan2(Math.sqrt(x * x + z * z), y);
            double sinPhi = Math.sin(phi);
            double cosPhi = Math.cos(phi);
            double rot = random.m_188500_() * Math.PI * 2.0;
            double sinRot = Math.sin(rot);
            double cosRot = Math.cos(rot);
            int color = this.renderer.starColors().m_216829_(random).map(WeightedEntry.Wrapper::m_146310_).orElse(-1);
            for (int j = 0; j < 4; ++j) {
                double xOffset = (double)((j & 2) - 1) * scale;
                double yOffset = (double)((j + 1 & 2) - 1) * scale;
                double rotatedX = xOffset * cosRot - yOffset * sinRot;
                double rotatedY = yOffset * cosRot + xOffset * sinRot;
                double transformedX = rotatedX * sinPhi;
                double transformedY = -rotatedX * cosPhi;
                builder.m_5483_(xScale + transformedY * sinTheta - rotatedY * cosTheta, yScale + transformedX, zScale + rotatedY * sinTheta + transformedY * cosTheta).m_193479_(color).m_5752_();
            }
        }
        return builder.m_231175_();
    }
}

