/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.network.AbstractModMessage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ErrorReportMessage
extends AbstractModMessage {
    private final List<Component> _errors;
    private final BlockPos _position;

    public static ErrorReportMessage create(@Nullable BlockPos position, Component ... errors) {
        return new ErrorReportMessage(position, errors);
    }

    public static ErrorReportMessage create(@Nullable BlockPos position, List<Component> errors) {
        return new ErrorReportMessage(position, errors);
    }

    public ErrorReportMessage(FriendlyByteBuf buffer) {
        super(buffer);
        int count = buffer.readInt();
        this._errors = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            this._errors.add(buffer.m_130238_());
        }
        this._position = buffer.readBoolean() ? buffer.m_130135_() : null;
    }

    @Override
    public void encodeTo(FriendlyByteBuf buffer) {
        buffer.writeInt(this._errors.size());
        this._errors.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130083_(arg_0));
        if (null == this._position) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130064_(this._position);
        }
    }

    @Override
    public void processMessage(NetworkEvent.Context messageContext) {
        if (NetworkDirection.PLAY_TO_CLIENT == messageContext.getDirection()) {
            ZeroCore.getProxy().displayErrorToPlayer(this._position, this._errors);
        }
    }

    protected ErrorReportMessage(@Nullable BlockPos position, Component ... errors) {
        this(position, Lists.newArrayList((Object[])errors));
    }

    protected ErrorReportMessage(@Nullable BlockPos position, List<Component> errors) {
        this._errors = Lists.newArrayList(errors);
        this._position = position;
    }
}

