/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.module.ExpModule;
import com.yogpc.qp.machines.module.FilterModule;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.RepeatTickModuleItem;
import com.yogpc.qp.machines.module.ReplacerModule;
import com.yogpc.qp.utils.MapMulti;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.VisibleForTesting;

public class ModuleInventory
extends SimpleContainer
implements INBTSerializable<CompoundTag> {
    private final Consumer<ModuleInventory> onUpdate;
    private final Predicate<QuarryModule> filter;
    private final HasModuleInventory holder;

    public ModuleInventory(int slot, Consumer<ModuleInventory> onUpdate, Predicate<QuarryModule> filter, HasModuleInventory holder) {
        super(slot);
        this.onUpdate = onUpdate;
        this.filter = filter;
        this.holder = holder;
    }

    public ModuleInventory(int slot, Runnable onUpdate, Predicate<QuarryModule> filter, HasModuleInventory holder) {
        this(slot, (ModuleInventory t) -> onUpdate.run(), filter, holder);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof QuarryModuleProvider.Item) {
            QuarryModuleProvider.Item provider = (QuarryModuleProvider.Item)item;
            if (ItemStack.m_41656_((ItemStack)this.m_8020_(index), (ItemStack)stack)) {
                return true;
            }
            Set given = this.holder.getLoadedModules().stream().map(QuarryModule::moduleId).filter(Predicate.isEqual(Holder.ITEM_FILTER_MODULE.getRegistryName()).negate()).collect(Collectors.toSet());
            QuarryModule toAdd = provider.getModule(stack);
            return this.filter.test(toAdd) && !given.contains(toAdd.moduleId());
        }
        return false;
    }

    public List<QuarryModule> getModules() {
        return ModuleInventory.getModules(IntStream.range(0, this.m_6643_()).mapToObj(arg_0 -> ((ModuleInventory)this).m_8020_(arg_0)));
    }

    @VisibleForTesting
    static List<QuarryModule> getModules(Stream<ItemStack> stream) {
        return stream.filter(s -> s.m_41720_() instanceof QuarryModuleProvider.Item).map(s -> ((QuarryModuleProvider.Item)s.m_41720_()).getModule((ItemStack)s)).toList();
    }

    public void m_6596_() {
        super.m_6596_();
        this.onUpdate.accept(this);
        HasModuleInventory hasModuleInventory = this.holder;
        if (hasModuleInventory instanceof BlockEntity) {
            BlockEntity entity = (BlockEntity)hasModuleInventory;
            entity.m_6596_();
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("slot", this.m_6643_());
        tag.m_128365_("inventory", (Tag)this.m_7927_());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("inventory", 10);
        this.m_7797_(list);
    }

    public boolean m_6542_(Player player) {
        HasModuleInventory hasModuleInventory = this.holder;
        if (hasModuleInventory instanceof PowerTile) {
            PowerTile powerTile = (PowerTile)((Object)hasModuleInventory);
            return PowerTile.stillValid(powerTile, player);
        }
        return super.m_6542_(player);
    }

    public static List<QuarryModule> loadModulesFromTag(CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return Collections.emptyList();
        }
        return ModuleInventory.getModules(tag.m_128437_("inventory", 10).stream().mapMulti(MapMulti.cast(CompoundTag.class)).map(ItemStack::m_41712_));
    }

    public static interface HasModuleInventory {
        public ModuleInventory getModuleInventory();

        public Set<QuarryModule> getLoadedModules();

        default public boolean hasPumpModule() {
            return this.getLoadedModules().contains(QuarryModule.Constant.PUMP);
        }

        default public boolean hasBedrockModule() {
            return this.getLoadedModules().contains(QuarryModule.Constant.BEDROCK);
        }

        default public boolean hasFillerModule() {
            return this.getLoadedModules().contains(QuarryModule.Constant.FILLER);
        }

        default public Optional<ExpModule> getExpModule() {
            return this.getLoadedModules().stream().mapMulti(MapMulti.cast(ExpModule.class)).findFirst();
        }

        default public Optional<ReplacerModule> getReplacerModule() {
            return this.getLoadedModules().stream().mapMulti(MapMulti.cast(ReplacerModule.class)).findFirst();
        }

        default public Stream<FilterModule> getFilterModules() {
            return this.getLoadedModules().stream().mapMulti(MapMulti.cast(FilterModule.class));
        }

        default public int getRepeatWorkCount() {
            return this.getLoadedModules().stream().mapMulti(MapMulti.cast(RepeatTickModuleItem.RepeatTickModule.class)).mapToInt(RepeatTickModuleItem.RepeatTickModule::stackSize).sum() + 1;
        }
    }
}

