/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.machines.TraceQuarryWork;
import com.yogpc.qp.utils.MapStreamSyntax;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public record ItemConverter(List<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>> conversionMap) {
    public ItemConverter(Map<ItemKey, ItemKey> map) {
        this(map.entrySet().stream().map((? super T e) -> {
            Predicate predicate = Predicate.isEqual(e.getKey());
            Function<ItemKey, ItemKey> converter = i -> (ItemKey)e.getValue();
            return Map.entry(predicate, converter);
        }).toList());
    }

    public ItemStack map(ItemStack before) {
        if (this.conversionMap().isEmpty()) {
            return before;
        }
        ItemKey key = new ItemKey(before);
        Map.Entry<ItemKey, Integer> pair = this.mapToKey(key, before.m_41613_());
        return pair.getKey().toStack(pair.getValue());
    }

    public Map.Entry<ItemKey, Integer> mapToKey(ItemStack before) {
        return this.mapToKey(new ItemKey(before), before.m_41613_());
    }

    public Map.Entry<ItemKey, Integer> mapToKey(ItemKey before, int count) {
        ItemKey key = this.conversionMap().stream().filter(MapStreamSyntax.byKey(p -> p.test(before))).findFirst().map(Map.Entry::getValue).map((? super T f) -> ItemConverter.convert(f, before)).orElse(before);
        return Map.entry(key, count);
    }

    private static ItemKey convert(Function<ItemKey, ItemKey> func, ItemKey key) {
        LogFunction l;
        ItemKey converted = func.apply(key);
        if (!(func instanceof LogFunction) || !(l = (LogFunction)func).noLog()) {
            TraceQuarryWork.convertItem(key, converted);
        }
        return converted;
    }

    public ItemConverter combined(@Nullable ItemConverter other) {
        if (other == null || other.conversionMap.isEmpty()) {
            return this;
        }
        if (this.conversionMap.isEmpty()) {
            return other;
        }
        ArrayList<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>> newList = new ArrayList<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>>(this.conversionMap());
        newList.addAll(other.conversionMap());
        return new ItemConverter(newList);
    }

    public static ItemConverter defaultConverter() {
        if (((Boolean)QuarryPlus.config.common.convertDeepslateOres.get()).booleanValue()) {
            return ItemConverter.deepslateConverter();
        }
        return new ItemConverter(List.of());
    }

    public static ItemConverter deepslateConverter() {
        Predicate<ItemKey> predicate = i -> {
            String path = i.getId().m_135815_();
            return path.contains("deepslate") && path.contains("ore");
        };
        Function<ItemKey, ItemKey> function = i -> {
            String newPath = i.getId().m_135815_().replace("deepslate_", "").replace("_deepslate", "");
            ResourceLocation id = new ResourceLocation(i.getId().m_135827_(), newPath);
            if (ForgeRegistries.ITEMS.containsKey(id)) {
                return new ItemKey((Item)ForgeRegistries.ITEMS.getValue(id), i.nbt());
            }
            return null;
        };
        return new ItemConverter(List.of(Pair.of(predicate, function)));
    }

    public static ItemConverter advQuarryConverter() {
        if (!((Boolean)QuarryPlus.config.common.removeCommonMaterialsByCD.get()).booleanValue()) {
            return new ItemConverter(List.of());
        }
        NoLogFunction function = new NoLogFunction(itemKey -> ItemKey.EMPTY_KEY);
        return new ItemConverter(Stream.of(ItemConverter.tagPredicate((TagKey<Item>)Tags.Items.STONE), ItemConverter.tagPredicate((TagKey<Item>)Tags.Items.COBBLESTONE), ItemConverter.itemPredicate(Items.f_42329_), ItemConverter.itemPredicate(Items.f_42276_), ItemConverter.blockTagPredicate((TagKey<Block>)BlockTags.f_13061_), ItemConverter.blockTagPredicate((TagKey<Block>)BlockTags.f_13062_), ItemConverter.tagPredicate((TagKey<Item>)Tags.Items.SANDSTONE)).map((? super T p) -> Map.entry(p, function)).toList());
    }

    public static ItemConverter voidConverter(List<ItemKey> voidedItems) {
        return new ItemConverter(voidedItems.stream().map((? super T k) -> Map.entry(Predicate.isEqual(k), OneLogFunction.createEmpty())).toList());
    }

    static Predicate<ItemKey> tagPredicate(TagKey<Item> tag) {
        return itemKey -> itemKey.toStack(1).m_204117_(tag);
    }

    static Predicate<ItemKey> blockTagPredicate(TagKey<Block> tag) {
        return itemKey -> {
            BlockItem blockItem;
            Item patt5391$temp = itemKey.item();
            return patt5391$temp instanceof BlockItem && (blockItem = (BlockItem)patt5391$temp).m_40614_().m_49966_().m_204336_(tag);
        };
    }

    static Predicate<ItemKey> itemPredicate(Item item) {
        return itemKey -> itemKey.item() == item;
    }

    private static interface LogFunction
    extends Function<ItemKey, ItemKey> {
        public boolean noLog();
    }

    private record NoLogFunction(Function<ItemKey, ItemKey> function) implements LogFunction
    {
        @Override
        public ItemKey apply(ItemKey key) {
            return this.function.apply(key);
        }

        @Override
        public boolean noLog() {
            return true;
        }
    }

    private static class OneLogFunction
    implements LogFunction {
        private final Function<ItemKey, ItemKey> function;
        private boolean logged = false;

        private OneLogFunction(Function<ItemKey, ItemKey> function) {
            this.function = function;
        }

        static Function<ItemKey, ItemKey> create(Function<ItemKey, ItemKey> function) {
            return new OneLogFunction(function);
        }

        static Function<ItemKey, ItemKey> createEmpty() {
            return OneLogFunction.create(key -> ItemKey.EMPTY_KEY);
        }

        @Override
        public boolean noLog() {
            if (this.logged) {
                return true;
            }
            this.logged = true;
            return false;
        }

        @Override
        public ItemKey apply(ItemKey itemKey) {
            return this.function.apply(itemKey);
        }
    }
}

