/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.jei;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.EnergyCounter;
import com.yogpc.qp.machines.workbench.IngredientList;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

class WorkBenchRecipeCategory
implements IRecipeCategory<WorkbenchRecipe> {
    public static final RecipeType<WorkbenchRecipe> RECIPE_TYPE = RecipeType.create((String)"quarryplus", (String)"jei_workbenchplus", WorkbenchRecipe.class);
    private static final ResourceLocation backGround = new ResourceLocation("quarryplus", "textures/gui/workbench_jei2.png");
    private static final int xOff = 0;
    private static final int yOff = 0;
    private final IGuiHelper helper;
    private final IDrawableAnimated animateBar;

    WorkBenchRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        IDrawableStatic bar = helper.createDrawable(backGround, 0, 87, 160, 4);
        this.animateBar = helper.createAnimatedDrawable(bar, 300, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<WorkbenchRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Holder.BLOCK_WORKBENCH.m_49954_();
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(backGround, 0, 0, 167, 86);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Holder.BLOCK_WORKBENCH));
    }

    public void draw(WorkbenchRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animateBar.draw(guiGraphics, 4, 60);
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280056_(font, EnergyCounter.formatEnergyInFE(recipe.getRequiredEnergy()) + "FE", 36, 70, 0x404040, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WorkbenchRecipe recipe, IFocusGroup focuses) {
        List<List> input = recipe.inputs().stream().map(IngredientList::stackList).toList();
        List<ItemStack> output = Collections.singletonList(recipe.output);
        int x0 = 4;
        int o = 18;
        for (int i = 0; i < recipe.inputs().size(); ++i) {
            int xIndex = i % 9;
            int yIndex = i / 9;
            List slotInput = input.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, x0 + 18 * xIndex - 0, x0 + 18 * yIndex - 0).addItemStacks(slotInput);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, x0 - 0, x0 + 64 - 0).addItemStacks(output);
    }
}

