/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.network.CMessagePrayer;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEffects;

public final class ItemAnkhOfPrayer
extends ItemCastableMagic {
    private Multimap<Attribute, AttributeModifier> attributes;

    public ItemAnkhOfPrayer() {
        super("ankh_of_prayer", ItemAnkhOfPrayer.getBuilder().m_41499_(80).m_41486_(), () -> true);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        Player player = ModTombstone.PROXY.getClientPlayer();
        if (player != null) {
            if (!this.m_5812_(stack)) {
                int cd = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY);
                if (cd > 0) {
                    this.addInfo(tooltip, this.m_5524_() + ".use1", Component.m_237113_((String)("[" + TimeHelper.getTimeString(cd) + "]")).m_130948_(StyleType.TOOLTIP_DESC));
                }
            } else {
                this.addItemUse(tooltip, "2", new Object[0]);
            }
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (EntityHelper.isValidPlayer(player) && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_150930_((Item)this) && EntityHelper.noGlobalItemCooldown(player, this) && CooldownHandler.INSTANCE.noCooldown(player, CooldownType.NEXT_PRAY) && !EffectHelper.isPotionActive(target, ModEffects.prayer)) {
            int alignment = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
            if (alignment < 0) {
                if (target instanceof Villager) {
                    return this.handleInteractEntity(player, target, 2, target.m_9236_().m_46791_() == Difficulty.PEACEFUL ? LangKey.MESSAGE_DIFFICULTY_PEACEFUL : null);
                }
                @Nullable TamableType tamableType = TamableType.getType((Entity)target);
                if (tamableType == TamableType.UNDEAD) {
                    if (alignment < -2) {
                        return this.handleInteractEntity(player, target, 6, target.m_9236_().m_46791_() == Difficulty.PEACEFUL ? LangKey.MESSAGE_DIFFICULTY_PEACEFUL : (tamableType.getOwnerId((Entity)target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null));
                    }
                    if (alignment < -1) {
                        return this.handleInteractEntity(player, target, 4, target.m_9236_().m_46791_() == Difficulty.PEACEFUL ? LangKey.MESSAGE_DIFFICULTY_PEACEFUL : (tamableType.getOwnerId((Entity)target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null));
                    }
                }
            } else {
                if (target instanceof ZombieVillager) {
                    return this.handleInteractEntity(player, target, 3, null);
                }
                @Nullable TamableType tamableType = TamableType.getType((Entity)target);
                if (tamableType != null && tamableType != TamableType.UNDEAD) {
                    if (alignment > 2) {
                        return this.handleInteractEntity(player, target, 5, tamableType.getOwnerId((Entity)target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null);
                    }
                    if (alignment > 1) {
                        return this.handleInteractEntity(player, target, 0, tamableType.getOwnerId((Entity)target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null);
                    }
                }
                if (alignment > 0) {
                    return target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(protCap -> this.handleInteractEntity(player, target, 1, protCap.isActive() ? LangKey.MESSAGE_PRAY_OF_PROTECTION_FAILED : null)).orElse(InteractionResult.SUCCESS);
                }
            }
        }
        return this.m_7203_(player.m_9236_(), player, hand).m_19089_();
    }

    private InteractionResult handleInteractEntity(Player player, LivingEntity target, int prayType, @Nullable LangKey failKey) {
        if (failKey != null) {
            if (!player.m_9236_().m_5776_()) {
                failKey.sendSpecialMessage(player, new Object[0]);
            }
            EntityHelper.setGlobalItemCooldown(player, this, 10);
        } else {
            TARGET.put(player.m_36316_().getId(), target);
            player.m_6672_(InteractionHand.MAIN_HAND);
            if (!player.m_9236_().m_5776_()) {
                target.getPersistentData().m_128362_("prayer", player.m_36316_().getId());
                target.getPersistentData().m_128376_("pray_type", (short)prayType);
                int duration = 200;
                EffectHelper.addEffect(target, ModEffects.prayer, 200);
                PacketHandler.sendToAllTrackingPlayersAndSelf(new CMessagePrayer(target.m_19879_(), player.m_36316_().getId(), prayType, 200), target);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (CooldownHandler.INSTANCE.hasCooldown(player, CooldownType.NEXT_PRAY)) {
            return InteractionResultHolder.m_19096_((Object)heldStack);
        }
        return super.m_7203_(level, player, hand);
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        if (CooldownHandler.INSTANCE.noCooldown((Player)player, CooldownType.NEXT_PRAY)) {
            if (target != null && EffectHelper.isPotionActive(target, ModEffects.prayer)) {
                target.m_21195_(ModEffects.prayer);
                int alignment = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
                if (PrayerHelper.exorcism(player, target, alignment) || PrayerHelper.zombify(player, target, alignment) || PrayerHelper.dissonance(player, target, alignment) || PrayerHelper.undead(player, target, alignment) || PrayerHelper.protection(player, target, alignment) || PrayerHelper.harmonization(player, target, alignment) || PrayerHelper.empathy(player, target, alignment)) {
                    return true;
                }
            }
            PrayerHelper.onGrave(player, player.m_20183_());
            return true;
        }
        return false;
    }

    @Override
    protected ItemCastableMagic.CastingTarget getCastingTarget(ItemStack stack) {
        return ItemCastableMagic.CastingTarget.TARGET_OR_SELF;
    }

    @Override
    protected boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        Player player = ModTombstone.PROXY.getClientPlayer();
        if (player == null || EntityHelper.hasGlobalItemCooldown(player, stack)) {
            return false;
        }
        int cooldownToPray = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY);
        if (cooldownToPray > 0) {
            int maxTime = CooldownType.NEXT_PRAY.getMaxCooldown(player);
            int elapsedTime = maxTime - cooldownToPray;
            ItemCooldowns cd = player.m_36335_();
            cd.f_41516_ -= elapsedTime;
            cd.m_41524_((Item)this, maxTime);
            cd.f_41516_ += elapsedTime;
            return false;
        }
        return true;
    }

    @Override
    protected void produceParticleCasting(ItemStack stack, Player player) {
        ModTombstone.PROXY.produceParticleCasting(CastingType.PRAY, (LivingEntity)player, p -> !player.m_6117_() || player.m_21252_() == 1);
    }

    @Override
    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return stack.m_150930_((Item)this);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return stack.m_150930_((Item)this);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public int m_6473_() {
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            if (this.attributes != null) {
                return this.attributes;
            }
            if (ForgeMod.ENTITY_REACH.isPresent()) {
                this.attributes = ImmutableMultimap.builder().put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.fromString("a336c4e4-a0c4-4da9-ba45-4b7de7eb449d"), "Ankh range bonus", 10.0, AttributeModifier.Operation.ADDITION)).build();
                return this.attributes;
            }
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

