/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;

public final class EffectHelper {
    private static final Method METHOD_ON_EFFECT_REMOVED = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7285_", (Class[])new Class[]{MobEffectInstance.class});
    public static final Function<Random, Integer> RANDOM_EFFECT_LEVEL = random -> {
        int roll = random.nextInt(100) + 1;
        return roll < 10 ? 4 : (roll < 25 ? 3 : (roll < 45 ? 2 : (roll < 70 ? 1 : 0)));
    };

    public static int getDuration(@Nullable LivingEntity entity, @Nullable MobEffect effect) {
        MobEffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.m_21124_(effect)) != null ? effectInstance.m_19557_() : 0;
    }

    public static boolean isPotionActive(@Nullable LivingEntity entity, @Nullable MobEffect effect) {
        return EffectHelper.getDuration(entity, effect) > 0;
    }

    public static boolean isUnstableIntangibilityActive(@Nullable LivingEntity entity) {
        return TimeHelper.inIntervalAfter(EffectHelper.getDuration(entity, ModEffects.unstable_intangibility), 100, 79);
    }

    public static void capDuration(LivingEntity entity, MobEffect effect, int maxDuration) {
        MobEffectInstance effectInstance = (MobEffectInstance)entity.m_21221_().get(effect);
        if (EffectHelper.capEffect(effectInstance, maxDuration)) {
            EffectHelper.clearEffect(entity, effect);
            EffectHelper.addEffect(entity, effectInstance);
        }
    }

    private static boolean capEffect(@Nullable MobEffectInstance effectInstance, int maxDuration) {
        if (effectInstance == null) {
            return false;
        }
        if (effectInstance.m_19557_() < maxDuration) {
            return EffectHelper.capEffect(effectInstance.f_19510_, maxDuration);
        }
        effectInstance.f_19503_ = maxDuration;
        effectInstance.f_19510_ = null;
        return true;
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable MobEffect effect, int duration) {
        EffectHelper.addEffect(entity, effect, duration, 0, new boolean[0]);
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable MobEffect effect, int duration, int amplifier, boolean ... params) {
        if (entity != null && effect != null) {
            entity.m_7292_(new MobEffectInstance(effect, duration, amplifier, params.length == 0 || params[0], params.length <= 1 || params[1]));
        }
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable MobEffectInstance effectInstance) {
        if (entity != null && effectInstance != null && effectInstance.m_19544_() != null) {
            entity.m_7292_(effectInstance);
        }
    }

    public static void addGhostlyShape(Player player) {
        int duration = (Integer)SharedConfigTombstone.player_death.ghostlyShapeDuration.get();
        if (duration > 0) {
            EffectHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, duration * 20);
        }
    }

    public static boolean isPotionHidden(@Nullable LivingEntity entity, @Nullable MobEffect effect) {
        MobEffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.m_21124_(effect)) != null && effectInstance.m_19571_() && !effectInstance.m_19572_();
    }

    public static MobEffectInstance copyEffectWithHidden(MobEffectInstance effectInstance) {
        MobEffectInstance effectCopy = new MobEffectInstance(effectInstance);
        if (effectInstance.f_19510_ != null) {
            effectCopy.f_19510_ = EffectHelper.copyEffectWithHidden(effectInstance.f_19510_);
        }
        return effectCopy;
    }

    public static void modifyEffectDuration(MobEffectInstance effectInstance, Function<MobEffectInstance, Integer> function) {
        effectInstance.f_19503_ = function.apply(effectInstance);
        if (effectInstance.f_19510_ != null) {
            EffectHelper.modifyEffectDuration(effectInstance.f_19510_, function);
        }
    }

    public static boolean clearEffect(@Nullable LivingEntity entity, MobEffect effect) {
        if (entity != null && !entity.m_9236_().m_5776_()) {
            MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(entity, effect));
            MobEffectInstance effectInstance = entity.m_6234_(effect);
            if (effectInstance != null) {
                try {
                    METHOD_ON_EFFECT_REMOVED.invoke((Object)entity, effectInstance);
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private static void clearEffect(LivingEntity entity, Predicate<MobEffect> predic) {
        if (!entity.m_9236_().m_5776_()) {
            Iterator it = entity.m_21221_().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!predic.test((MobEffect)entry.getKey())) continue;
                try {
                    MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(entity, (MobEffect)entry.getKey()));
                    it.remove();
                    METHOD_ON_EFFECT_REMOVED.invoke((Object)entity, entry.getValue());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void clearBadEffects(@Nullable LivingEntity entity) {
        if (entity != null) {
            EffectHelper.clearEffect(entity, EffectHelper::isHarmful);
            if (entity.m_6060_()) {
                entity.m_20095_();
            }
            if (entity.m_146886_()) {
                entity.m_146915_(false);
            }
        }
    }

    @Nullable
    public static MobEffectInstance getRandomEffect(int duration, boolean isBad) {
        return EffectHelper.getRandomEffect(duration, isBad, true, RANDOM_EFFECT_LEVEL);
    }

    @Nullable
    public static MobEffectInstance getRandomEffect(int duration, boolean isBad, boolean acceptInstantEffect, Function<Random, Integer> functionEffectLevel) {
        return EffectHelper.getRandomEffect(duration, isBad ? EffectHelper::isBadEffect : EffectHelper::isAllowedEffect, acceptInstantEffect, functionEffectLevel);
    }

    @Nullable
    public static MobEffectInstance getRandomEffect(int duration, Predicate<MobEffect> predic, boolean acceptInstantEffect, Function<Random, Integer> functionEffectLevel) {
        if (!acceptInstantEffect) {
            predic = predic.and(effect -> !effect.m_8093_());
        }
        return RegistryHelper.findRandom(ForgeRegistries.MOB_EFFECTS, predic).map(effect -> new MobEffectInstance(effect, effect.m_8093_() ? 1 : duration, ((Integer)functionEffectLevel.apply(Helper.RANDOM)).intValue())).orElse(null);
    }

    public static void addRandomEffect(Player player, int duration, boolean withMessage, boolean isBad, boolean acceptInstantEffect) {
        MobEffectInstance effectInstance = EffectHelper.getRandomEffect(duration, isBad, acceptInstantEffect, RANDOM_EFFECT_LEVEL);
        if (effectInstance != null) {
            if (withMessage) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage(player, StyleType.MESSAGE_SPELL, new Object[]{effectInstance.m_19544_().m_19482_().m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL)});
            }
            EffectHelper.addEffect((LivingEntity)player, effectInstance);
        }
    }

    public static boolean isHarmful(@Nullable MobEffect effect) {
        return effect != null && !effect.m_19486_() && effect.m_19483_() != MobEffectCategory.NEUTRAL;
    }

    public static boolean isBadEffect(@Nullable MobEffect effect) {
        return EffectHelper.isHarmful(effect) && !Helper.containRL((List<String>)((List)ConfigTombstone.general.unhandledHarmfulEffects.get()), RegistryHelper.getRegistryName(effect));
    }

    public static boolean isBeneficial(@Nullable MobEffect effect) {
        return effect != null && effect.m_19486_();
    }

    public static boolean isAllowedEffect(@Nullable MobEffectInstance effectInstance) {
        return effectInstance != null && EffectHelper.isAllowedEffect(effectInstance.m_19544_());
    }

    public static boolean isAllowedEffect(@Nullable MobEffect effect) {
        return EffectHelper.isBeneficial(effect) && !Helper.containRL((List<String>)((List)ConfigTombstone.general.unhandledBeneficialEffects.get()), RegistryHelper.getRegistryName(effect));
    }

    public static ItemStack createMagicArrows(int count, MobEffect effect) {
        return EffectHelper.createMagicArrows(count, effect, 0);
    }

    public static ItemStack createMagicArrows(int count, MobEffect effect, int amplifier) {
        return EffectHelper.createMagicArrows(count, new MobEffectInstance(effect, 3200, amplifier));
    }

    public static ItemStack createMagicArrows(int count, MobEffectInstance ... effectInstances) {
        Arrays.stream(effectInstances).filter(e -> e.m_19544_().m_8093_()).forEach(e -> {
            e.f_19503_ = 1;
            e.f_19510_ = null;
        });
        return NBTStackHelper.setBoolean(NBTStackHelper.setInteger(PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42738_, count), List.of(effectInstances)), "CustomPotionColor", effectInstances.length > 1 ? -16777216 : effectInstances[0].m_19544_().m_19484_()), "enchanted_arrow", true);
    }

    public static ItemStack createRandomArrows(int count) {
        @Nullable MobEffectInstance effect = EffectHelper.getRandomEffect(3200, true);
        if (effect != null) {
            return EffectHelper.createMagicArrows(count, effect);
        }
        return new ItemStack((ItemLike)Items.f_42737_, count);
    }

    public static ItemStack createCursedArrows(int count) {
        ArrayList list = new ArrayList();
        IntStream.range(0, 5).forEach(i -> Optional.ofNullable(EffectHelper.getRandomEffect(3200, e -> EffectHelper.isBadEffect(e) && list.stream().noneMatch(instance -> instance.m_19544_() == e), true, RANDOM_EFFECT_LEVEL)).ifPresent(list::add));
        if (list.size() > 0) {
            return EffectHelper.createMagicArrows(count, list.toArray(new MobEffectInstance[0]));
        }
        return new ItemStack((ItemLike)Items.f_42737_, count);
    }

    public static String getPotency(int amplifier) {
        return amplifier <= 1 ? "" : Helper.getRomanNumber(amplifier);
    }
}

