/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

public final class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    public final Set<Location> ALLOWED_REMOVALS = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Location> GROUND_LOCATIONS = new ConcurrentHashMap<UUID, Location>();
    private static final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    private static final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    private static final String GRAVE_LOCATIONS_NBT_LIST = "tb_grave_locations";
    private static final String SOULBOUND_STACKS_NBT_LIST = "tb_soulbound_stacks";
    private static final String KEY_STACKS_NBT_LIST = "tb_key_stacks";
    private static final String LAST_OFFHAND_ITEM = "tb_last_offhand_item";
    private static final String LAST_GROUND_LOCATION = "tb_last_ground_location";

    private DeathHandler() {
    }

    public Location getLastGrave(MinecraftServer server, ServerPlayer player) {
        List<Location> graveLocations = this.getGraveList(player);
        for (Location lastGrave : graveLocations) {
            ServerLevel currentWorld;
            if (lastGrave.isOrigin() || (currentWorld = server.m_129880_(lastGrave.dim)) == null) continue;
            if (Helper.getPlayerGrave((Level)currentWorld, lastGrave.getPos()).isPresent()) {
                return lastGrave;
            }
            this.removeGrave(player, lastGrave);
        }
        return Location.ORIGIN;
    }

    public void removeGrave(ServerPlayer player, Location pos) {
        ListTag list = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Location loc = NBTStackHelper.getLocation((CompoundTag)it.next(), "location");
            if (!pos.equals(loc)) continue;
            it.remove();
            break;
        }
        if (list.size() > 20) {
            it = list.iterator();
            for (int removedCount = list.size() - 20; removedCount > 0 && it.hasNext(); --removedCount) {
                it.next();
                it.remove();
            }
        }
    }

    public List<Location> getGraveList(ServerPlayer player) {
        LinkedList<Location> graveLocations = new LinkedList<Location>();
        ListTag nbtList = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST);
        for (int i = nbtList.size() - 1; i >= 0; --i) {
            graveLocations.add(NBTStackHelper.getLocation(nbtList.m_128728_(i), "location"));
        }
        return graveLocations;
    }

    public void onPlayerDead(ServerPlayer player, DamageSource source) {
        int timeSinceDeath = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_));
        if (timeSinceDeath < TimeHelper.tickFromMinute(1)) {
            if (player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)) > 1) {
                ModTriggers.CHAIN_DEATH.trigger(player);
            }
        } else if (timeSinceDeath >= TimeHelper.tickFromHour(1)) {
            ModTriggers.STRONG_OR_CAREFUL.trigger(player);
            if (timeSinceDeath >= TimeHelper.tickFromHour(10)) {
                ModTriggers.ALMOST_UNKILLABLE.trigger(player);
            }
        }
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        persistentTag.m_128379_(IS_PLAYER_DEAD_NBT_BOOL, true);
        boolean hasPreservation = EffectHelper.isPotionActive((LivingEntity)player, ModEffects.preservation);
        if (hasPreservation || ((Boolean)ConfigTombstone.player_death.restoreEffectsOnDeath.get()).booleanValue()) {
            NBTStackHelper.setEffectlist(persistentTag, PRESERVED_EFFECTS_NBT_LIST, player.m_21220_().stream().filter(EffectHelper::isAllowedEffect));
        }
        this.storeExperience(player, source, hasPreservation, persistentTag);
        persistentTag.m_128359_(LAST_OFFHAND_ITEM, BuiltInRegistries.f_257033_.m_7981_((Object)player.m_21206_().m_41720_()).toString());
    }

    private void storeExperience(ServerPlayer player, DamageSource source, boolean hasPreservation, CompoundTag persistentTag) {
        int xpTotal = EntityHelper.getPlayerTotalXp((Player)player);
        if (!hasPreservation) {
            int toRemove;
            ServerPlayer killer;
            if ((Integer)SharedConfigTombstone.player_death.xpLossOnDeath.get() > 0) {
                xpTotal = Mth.m_14107_((double)((double)(xpTotal * Math.min(100 - (Integer)SharedConfigTombstone.player_death.xpLossOnDeath.get() + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.memento_mori) * 20, 100)) / 100.0));
            }
            if (xpTotal > 0 && Optional.ofNullable(player.m_20194_()).map(MinecraftServer::m_129799_).orElse(false).booleanValue() && EntityHelper.isKilledByOtherPlayer((Player)player, source) && (killer = (ServerPlayer)source.m_7639_()) != null && (toRemove = Mth.m_14107_((double)((double)(xpTotal * (Integer)ConfigTombstone.player_death.pvpStolenXp.get()) / 100.0))) > 0) {
                xpTotal -= toRemove;
                killer.m_6756_(toRemove);
                LangKey.MESSAGE_PVP_STEAL_EXPERIENCE.sendMessage((Player)player, toRemove, player.m_7755_());
            }
        }
        persistentTag.m_128405_("tb_experience_total", xpTotal);
        Pair<Integer, Float> pair = EntityHelper.getPlayerXpPair(xpTotal);
        persistentTag.m_128405_("tb_experience_level", ((Integer)pair.getLeft()).intValue());
        persistentTag.m_128350_("tb_experience_bar", ((Float)pair.getRight()).floatValue());
    }

    private void restoreSoulbounds(ServerPlayer player) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        NBTStackHelper.getListOrEmpty(persistentTag, SOULBOUND_STACKS_NBT_LIST).ifPresent(list -> list.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).filter(stack -> !stack.m_41619_()).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack)));
        persistentTag.m_128473_(SOULBOUND_STACKS_NBT_LIST);
        NBTStackHelper.getListOrEmpty(persistentTag, KEY_STACKS_NBT_LIST).ifPresent(list -> list.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).filter(stack -> !stack.m_41619_()).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack)));
        persistentTag.m_128473_(KEY_STACKS_NBT_LIST);
    }

    public boolean canRemovePlayerGrave(Level level, BlockPos pos) {
        return this.ALLOWED_REMOVALS.contains(new Location(pos, level));
    }

    public void removeAndEmptyPlayerGrave(Level level, BlockPos pos) {
        pos = pos.m_7949_();
        Location locationId = new Location(pos, level);
        this.ALLOWED_REMOVALS.add(locationId);
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        this.ALLOWED_REMOVALS.remove(locationId);
    }

    public void handleRespawn(ServerPlayer player) {
        this.restoreSoulbounds(player);
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        if (persistentTag.m_128471_(IS_PLAYER_DEAD_NBT_BOOL)) {
            this.restorePlayer(player, persistentTag);
        }
        player.f_36095_.m_38946_();
    }

    private void restorePlayer(ServerPlayer player, CompoundTag persistentTag) {
        if (PlayerPreference.get(player).getAutoEquipRule().equipOnRespawn()) {
            InventoryHelper.autoequip(player, new ItemStackHandler(player.m_150109_().f_35974_), Items.f_41852_);
        }
        EffectHelper.addGhostlyShape((Player)player);
        persistentTag.m_128473_(IS_PLAYER_DEAD_NBT_BOOL);
        List<MobEffectInstance> effectInstances = NBTStackHelper.getEffectList(persistentTag, PRESERVED_EFFECTS_NBT_LIST, EffectHelper::isAllowedEffect);
        if (!effectInstances.isEmpty()) {
            effectInstances.forEach(effectInstance -> EffectHelper.addEffect((LivingEntity)player, effectInstance));
            persistentTag.m_128473_(PRESERVED_EFFECTS_NBT_LIST);
        }
        if (persistentTag.m_128425_("tb_experience_total", 3)) {
            player.f_36079_ = persistentTag.m_128451_("tb_experience_total");
            player.f_36078_ = persistentTag.m_128451_("tb_experience_level");
            player.f_36080_ = persistentTag.m_128457_("tb_experience_bar");
            persistentTag.m_128473_("tb_experience_total");
            persistentTag.m_128473_("tb_experience_level");
            persistentTag.m_128473_("tb_experience_bar");
            player.f_8906_.m_9829_((Packet)new ClientboundSetExperiencePacket(player.f_36080_, player.f_36079_, player.f_36078_));
        }
    }

    public void handleSoulbound(ServerPlayer player, Collection<ItemEntity> loots) {
        loots.addAll(player.m_9236_().m_6443_(ItemEntity.class, Helper.createBounds(player.m_20183_(), ((Integer)ConfigTombstone.player_death.snifferRange.get()).intValue()), e -> e != null && (e.m_19749_() == null || player.m_36316_().getId().equals(e.m_19749_().m_20148_()))));
        this.storeSoulboundsOnBody(player, loots.iterator());
    }

    public void handleLoot(ServerPlayer player, Collection<ItemEntity> loots, DamageSource damageSource) {
        BlockState state;
        boolean hasGrave;
        int countDrop = loots.size();
        if (countDrop == 0) {
            LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
            return;
        }
        MinecraftServer server = Objects.requireNonNull(player.m_20194_());
        ServerLevel level = player.m_284548_();
        boolean isAllowedDimension = this.isAllowedDimensionForGraves(level);
        PlayerPreference playerPreference = PlayerPreference.get(player);
        BlockPos initPos = Helper.getCloserValidPos((Level)level, player.m_20183_());
        Location spawnPos = Location.ORIGIN;
        if (isAllowedDimension && ((Boolean)ConfigTombstone.player_death.allowToFillExistingGrave.get()).booleanValue()) {
            spawnPos = this.findExistingGraveLocation(server, player, initPos, countDrop);
        }
        boolean bl = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave) {
            if (isAllowedDimension) {
                spawnPos = new SpawnHelper(level, initPos).withPlayerPreference(playerPreference).findGravePlace();
                if (spawnPos.isOrigin() && (spawnPos = this.findGraveLocationFromLastGroundLocation(server, player, playerPreference)).isOrigin() && (spawnPos = this.findGraveLocationFromRespawnLocation(server, player, playerPreference)).isOrigin()) {
                    spawnPos = new Location(initPos, (Level)level);
                }
            } else {
                spawnPos = this.findGraveLocationFromRespawnLocation(server, player, playerPreference);
                if (spawnPos.isOrigin()) {
                    LangKey.MESSAGE_NO_GRAVE_DIMENSION.sendSpecialMessage((Player)player, new Object[0]);
                    return;
                }
            }
        }
        if (!hasGrave) {
            NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST).add((Object)NBTStackHelper.setLocation(new CompoundTag(), "location", spawnPos));
            ModTombstone.LOGGER.debug("A new grave of the player " + player.m_36316_().getName() + " was created at position [x:" + spawnPos.x + ", y:" + spawnPos.y + ", z:" + spawnPos.z + ", dim:" + spawnPos.getDimString() + "]");
            Direction facing = player.m_6350_().m_122424_();
            Block graveBlock = ModBlocks.PLAYER_GRAVES.get((Object)playerPreference.getFavoriteGrave());
            state = (BlockState)((BlockState)((BlockState)graveBlock.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing)).m_61124_((Property)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(playerPreference.getMarbleType().ordinal()));
            level = Objects.requireNonNull(server.m_129880_(spawnPos.dim));
            level.m_46597_(spawnPos.getPos(), state);
        } else {
            state = level.m_8055_(spawnPos.getPos());
        }
        BlockEntityPlayerGrave grave = Helper.getPlayerGrave((Level)level, spawnPos.getPos()).orElse(null);
        if (grave == null) {
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage((Player)player, new Object[0]);
            ModTombstone.LOGGER.debug((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getText(new Object[0]));
            return;
        }
        if (hasGrave) {
            grave.resetDeathTime();
        }
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        grave.setLastOffhandItem((Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)persistentTag.m_128461_(LAST_OFFHAND_ITEM))));
        persistentTag.m_128473_(LAST_OFFHAND_ITEM);
        boolean needAccess = (Integer)SharedConfigTombstone.player_death.decayTime.get() != 0 && (!server.m_129799_() || (Boolean)ConfigTombstone.player_death.pvpUnlockGrave.get() == false || !EntityHelper.isKilledByOtherPlayer((Player)player, damageSource));
        MutableComponent locked = Component.m_237113_((String)"[").m_7220_((Component)(needAccess ? LangKey.MESSAGE_LOCKED.getText(new Object[0]).m_130946_((String)((Integer)SharedConfigTombstone.player_death.decayTime.get() > 0 ? " " + SharedConfigTombstone.player_death.decayTime.get() + " min" : "")) : LangKey.MESSAGE_UNLOCKED.getText(new Object[0]))).m_130946_("]").m_6270_(needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON);
        player.m_213846_((Component)(hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getText(StyleType.MESSAGE_SPECIAL, new Object[0]).m_130946_(" ").m_7220_((Component)locked));
        player.m_213846_((Component)Component.m_237113_((String)"[x: ").m_130946_(String.valueOf(spawnPos.x)).m_130946_(", y: ").m_130946_(String.valueOf(spawnPos.y)).m_130946_(", z: ").m_130946_(String.valueOf(spawnPos.z)).m_130946_("]").m_7220_((Component)Component.m_237113_((String)" in ").m_130946_(spawnPos.getDimString())));
        Location finalSpawnPos = spawnPos;
        ListTag keyList = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), KEY_STACKS_NBT_LIST);
        boolean found = false;
        for (int i = 0; i < keyList.size(); ++i) {
            ItemStack key = ItemStack.m_41712_((CompoundTag)keyList.m_128728_(i));
            if (!ModItems.grave_key.getTombPos(key).equals(finalSpawnPos)) continue;
            ModItems.grave_key.reenchantOnDeath((Player)player, key);
            keyList.set(i, (Tag)key.serializeNBT());
            found = true;
            break;
        }
        if (!found && ModItems.grave_key.isEnabled()) {
            ItemStack key = ModItems.grave_key.createWithInfo((Player)player, finalSpawnPos);
            ModItems.grave_key.reenchantOnDeath((Player)player, key);
            keyList.add((Object)key.serializeNBT());
        }
        grave.setOwner((Player)player, TimeHelper.systemTime(), needAccess);
        IItemHandler itemHandler = grave.getInventory();
        loots.forEach(e -> e.m_32045_(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.m_32055_().m_41777_(), (boolean)false)));
        grave.m_6596_();
        level.m_7260_(spawnPos.getPos(), Blocks.f_50016_.m_49966_(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
        if (loots.size() <= itemHandler.getSlots()) {
            try {
                loots.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private Location findGraveLocationFromLastGroundLocation(MinecraftServer server, ServerPlayer player, PlayerPreference playerPreference) {
        ServerLevel world;
        Location lastGroundLocation = this.getGroundLocation(player);
        if (!lastGroundLocation.isOrigin() && (world = server.m_129880_(lastGroundLocation.dim)) != null) {
            return new SpawnHelper(world, lastGroundLocation.getPos()).withPlayerPreference(playerPreference).findGravePlace();
        }
        return Location.ORIGIN;
    }

    private Location findGraveLocationFromRespawnLocation(MinecraftServer server, ServerPlayer player, PlayerPreference playerPreference) {
        Location spawnPos;
        ServerLevel world;
        ResourceKey respawnDimension = player.m_8963_();
        BlockPos respawnPosition = player.m_8961_();
        if (respawnPosition != null && this.isAllowedDimensionForGraves((ResourceKey<Level>)respawnDimension) && (world = server.m_129880_(player.m_8963_())) != null && !(spawnPos = new SpawnHelper(world, respawnPosition).withPlayerPreference(playerPreference).findGravePlace()).isOrigin()) {
            return spawnPos;
        }
        ServerLevel overworld = server.m_129783_();
        return new SpawnHelper(overworld, overworld.m_220360_()).withPlayerPreference(playerPreference).findGravePlace();
    }

    private Location findExistingGraveLocation(MinecraftServer server, ServerPlayer player, BlockPos initPos, int countDrop) {
        ServerLevel currentLevel = player.m_284548_();
        Optional<BlockEntityPlayerGrave> playerGrave = currentLevel.f_151512_.stream().map(tileTicker -> {
            try {
                BlockEntity blockEntity = ((LevelChunk.BoundTickingBlockEntity)((LevelChunk.RebindableTickingBlockEntityWrapper)tileTicker).f_156444_).f_156428_;
                if (ModBlocks.isPlayerGrave(blockEntity.m_58900_().m_60734_())) {
                    return (BlockEntityPlayerGrave)blockEntity;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull).filter(t -> Helper.getDistanceSq((Vec3i)t.m_58899_(), (Vec3i)initPos) <= 400.0).filter(t -> t.getOwnerName().equals(player.m_36316_().getName()) && InventoryHelper.hasEnoughSlots(t.getInventory(), countDrop)).min(Comparator.comparingInt(a -> a.m_58899_().m_123333_((Vec3i)initPos)));
        if (playerGrave.isPresent()) {
            return new Location(playerGrave.get().m_58899_(), (Level)currentLevel);
        }
        Location lastGrave = this.getLastGrave(server, player);
        if (!lastGrave.isOrigin() && lastGrave.isSameDimension((Level)currentLevel) && Helper.getDistanceSq((Vec3i)lastGrave.getPos(), (Vec3i)initPos) <= 400.0 && Helper.getPlayerGrave((Level)currentLevel, lastGrave.getPos()).filter(t -> InventoryHelper.hasEnoughSlots(t.getInventory(), countDrop)).isPresent()) {
            return lastGrave;
        }
        return Location.ORIGIN;
    }

    private void storeSoulboundsOnBody(ServerPlayer player, Iterator<ItemEntity> it) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        ListTag keyList = NBTStackHelper.getListOrCreate(persistentTag, KEY_STACKS_NBT_LIST);
        ListTag stackList = NBTStackHelper.getListOrCreate(persistentTag, SOULBOUND_STACKS_NBT_LIST);
        while (it.hasNext()) {
            ItemStack stack;
            ItemEntity entityItem = it.next();
            if (entityItem == null || (stack = entityItem.m_32055_()).m_41619_()) {
                it.remove();
                continue;
            }
            if (!Helper.isSoulbound(stack)) continue;
            if (stack.m_150930_((Item)ModItems.grave_key)) {
                keyList.add((Object)stack.serializeNBT());
            } else {
                stackList.add((Object)stack.serializeNBT());
            }
            entityItem.m_32045_(ItemStack.f_41583_);
            it.remove();
        }
    }

    private boolean isAllowedDimensionForGraves(ServerLevel level) {
        return this.isAllowedDimensionForGraves((ResourceKey<Level>)level.m_46472_());
    }

    private boolean isAllowedDimensionForGraves(ResourceKey<Level> levelRK) {
        return !((List)ConfigTombstone.player_death.noGraveDimension.get()).contains(levelRK.m_135782_().toString());
    }

    public Location getGroundLocation(ServerPlayer player) {
        Location groundLocation = this.GROUND_LOCATIONS.get(player.m_20148_());
        if (groundLocation != null) {
            return groundLocation;
        }
        Location storedLocation = NBTStackHelper.getLocation(EntityHelper.getPersistentTag((Player)player), LAST_GROUND_LOCATION);
        if (!storedLocation.isOrigin()) {
            this.GROUND_LOCATIONS.put(player.m_20148_(), storedLocation);
        }
        return storedLocation;
    }

    public void setGroundLocations(MinecraftServer server) {
        if (!TimeHelper.atInterval((Level)server.m_129783_(), 20)) {
            return;
        }
        server.m_6846_().m_11314_().stream().filter(EntityHelper::isValidServerPlayer).filter(Entity::m_20096_).filter(p -> !p.m_21224_()).filter(p -> !p.m_20077_()).forEach(this::setGroundLocation);
    }

    private void setGroundLocation(ServerPlayer player) {
        this.GROUND_LOCATIONS.put(player.m_20148_(), new Location((Entity)player));
    }

    public void storeGroundLocation(ServerPlayer player) {
        Optional.ofNullable(this.GROUND_LOCATIONS.get(player.m_20148_())).ifPresent(location -> NBTStackHelper.setLocation(EntityHelper.getPersistentTag((Player)player), LAST_GROUND_LOCATION, location));
    }

    private void storeGroundLocations(MinecraftServer server) {
        server.m_6846_().m_11314_().stream().filter(EntityHelper::isValidServerPlayer).forEach(this::storeGroundLocation);
    }

    public void clear(MinecraftServer server) {
        this.ALLOWED_REMOVALS.clear();
        this.storeGroundLocations(server);
        this.GROUND_LOCATIONS.clear();
    }
}

