/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.inventory.menu;

import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.mixin.mixins.common.accessor.AbstractContainerMenuAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CurioSlot;

public class AccessoriesMenu
extends InventoryMenu {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final String[] AETHER_IDENTIFIERS = new String[]{"aether_pendant", "aether_cape", "aether_shield", "aether_ring", "aether_gloves", "aether_accessory"};
    public final LazyOptional<ICuriosItemHandler> curiosHandler;
    private final Player player;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
    private final ResultContainer craftResult = new ResultContainer();
    public final boolean hasButton;

    public AccessoriesMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, true);
    }

    public AccessoriesMenu(int containerId, Inventory playerInventory, boolean hasButton) {
        super(playerInventory, playerInventory.f_35978_.m_9236_().m_5776_(), playerInventory.f_35978_);
        AbstractContainerMenuAccessor abstractContainerMenuAccessor = (AbstractContainerMenuAccessor)((Object)this);
        abstractContainerMenuAccessor.aether$setMenuType((MenuType)AetherMenuTypes.ACCESSORIES.get());
        abstractContainerMenuAccessor.aether$setContainerId(containerId);
        abstractContainerMenuAccessor.aether$getRemoteSlots().clear();
        abstractContainerMenuAccessor.aether$getLastSlots().clear();
        this.f_38839_.clear();
        this.player = playerInventory.f_35978_;
        this.curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)this.player);
        this.hasButton = hasButton;
        this.m_38897_((Slot)new ResultSlot(playerInventory.f_35978_, this.craftMatrix, (Container)this.craftResult, 0, 154, 28));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.m_38897_(new Slot((Container)this.craftMatrix, j + i * 2, 116 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentSlotType = VALID_EQUIPMENT_SLOTS[k];
            this.m_38897_(new Slot((Container)playerInventory, 36 + (3 - k), 59, 8 + k * 18){

                public void m_5852_(ItemStack stack) {
                    ItemStack itemStack = this.m_7993_();
                    super.m_5852_(stack);
                    AccessoriesMenu.this.player.m_238392_(equipmentSlotType, itemStack, stack);
                }

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return stack.canEquip(equipmentSlotType, (Entity)AccessoriesMenu.this.player);
                }

                public boolean m_8010_(Player player) {
                    ItemStack itemStack = this.m_7993_();
                    return (itemStack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemStack)) && super.m_8010_(player);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[equipmentSlotType.m_20749_()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.m_38897_(new Slot((Container)playerInventory, 40, 116, 62){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        this.curiosHandler.ifPresent(curios -> {
            Map curioMap = curios.getCurios();
            int slots = 0;
            int xOffset = 77;
            int yOffset = 8;
            for (String identifier : AETHER_IDENTIFIERS) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curioMap.get(identifier);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (stacksHandler.isVisible()) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    if (!identifier.equals("aether_accessory")) {
                        this.m_38897_((Slot)new CurioSlot(this.player, stackHandler, i, identifier, xOffset, yOffset, stacksHandler.getRenders(), stacksHandler.canToggleRendering()));
                        yOffset += 18;
                        if (++slots % 3 != 0) continue;
                        xOffset += 18;
                        yOffset = 8;
                        continue;
                    }
                    if (slots == 6) {
                        xOffset = 77;
                    }
                    this.m_38897_((Slot)new CurioSlot(this.player, stackHandler, i, identifier, xOffset, 62, stacksHandler.getRenders(), stacksHandler.canToggleRendering()));
                    ++slots;
                    xOffset += 18;
                }
            }
        });
    }

    public void m_5816_(StackedContents contents) {
        this.craftMatrix.m_5809_(contents);
    }

    public void m_6650_() {
        this.craftMatrix.m_6211_();
        this.craftResult.m_6211_();
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipe) {
        return recipe.m_5818_((Container)this.craftMatrix, this.player.m_9236_());
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return this.craftMatrix.m_39347_();
    }

    public int m_6656_() {
        return this.craftMatrix.m_39346_();
    }

    public int m_6653_() {
        return 5;
    }

    public void m_6199_(Container container) {
        if (!this.player.m_9236_().m_5776_()) {
            ServerPlayer playerMP = (ServerPlayer)this.player;
            ItemStack itemStack = ItemStack.f_41583_;
            MinecraftServer server = this.player.m_9236_().m_7654_();
            if (server == null) {
                return;
            }
            Optional recipe = server.m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, this.player.m_9236_());
            if (recipe.isPresent()) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)recipe.get();
                if (this.craftResult.m_40135_(this.player.m_9236_(), playerMP, (Recipe)craftingRecipe)) {
                    itemStack = craftingRecipe.m_5874_((Container)this.craftMatrix, this.player.m_9236_().m_9598_());
                }
            }
            this.craftResult.m_6836_(0, itemStack);
            this.m_150404_(0, itemStack);
            playerMP.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, itemStack));
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.craftResult.m_6211_();
        if (!player.m_9236_().m_5776_()) {
            this.m_150411_(player, (Container)this.craftMatrix);
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemStack = itemStack1.m_41777_();
            EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
            Map curioTags = CuriosApi.getItemStackSlots((ItemStack)itemStack);
            if (index == 0) {
                if (!this.m_38903_(itemStack1, 9, 45, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack1, itemStack);
            } else if (index < 5) {
                if (!this.m_38903_(itemStack1, 9, 45, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index < 9) {
                if (!this.m_38903_(itemStack1, 9, 45, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(8 - equipmentSlot.m_20749_())).m_6657_()) {
                int i = 8 - equipmentSlot.m_20749_();
                if (!this.m_38903_(itemStack1, i, i + 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index < 46 && !curioTags.isEmpty() && !this.getEmptyCurioSlots(curioTags).isEmpty()) {
                for (int i : this.getEmptyCurioSlots(curioTags)) {
                    if (this.m_38903_(itemStack1, i, i + 1, false)) continue;
                    return ItemStack.f_41583_;
                }
            } else if (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(45)).m_6657_() ? !this.m_38903_(itemStack1, 45, 46, false) : (index < 36 ? !this.m_38903_(itemStack1, 36, 45, false) : (index < 45 ? !this.m_38903_(itemStack1, 9, 36, false) : !this.m_38903_(itemStack1, 9, 45, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack1);
            if (index == 0) {
                player.m_36176_(itemStack1, false);
            }
        }
        return itemStack;
    }

    private Set<Integer> getEmptyCurioSlots(Map<String, ISlotType> slotData) {
        HashSet<Integer> slots = new HashSet<Integer>();
        Iterator<String> iterator = slotData.keySet().iterator();
        while (iterator.hasNext()) {
            String identifier;
            switch (identifier = iterator.next()) {
                case "aether_pendant": {
                    slots.add(46);
                    break;
                }
                case "aether_cape": {
                    slots.add(47);
                    break;
                }
                case "aether_shield": {
                    slots.add(48);
                    break;
                }
                case "aether_ring": {
                    slots.addAll(Set.of(Integer.valueOf(49), Integer.valueOf(50)));
                    break;
                }
                case "aether_gloves": {
                    slots.add(51);
                    break;
                }
                case "aether_accessory": {
                    slots.addAll(Set.of(Integer.valueOf(52), Integer.valueOf(53)));
                }
            }
        }
        slots.removeIf(index -> ((Slot)this.f_38839_.get(index.intValue())).m_6657_());
        return slots;
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }
}

