/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageInputBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.TargetContentsFilterLogic;

public class HopperUpgradeWrapper
extends UpgradeWrapperBase<HopperUpgradeWrapper, HopperUpgradeItem>
implements ITickableUpgrade,
INeighborChangeListenerUpgrade {
    private Set<Direction> pullDirections = new LinkedHashSet<Direction>();
    private Set<Direction> pushDirections = new LinkedHashSet<Direction>();
    private boolean directionsInitialized = false;
    private final Map<Direction, ItemHandlerHolder> handlerCache = new EnumMap<Direction, ItemHandlerHolder>(Direction.class);
    private final ContentsFilterLogic inputFilterLogic;
    private final TargetContentsFilterLogic outputFilterLogic;
    private long coolDownTime = 0L;

    protected HopperUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputFilterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getInputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), "inputFilter");
        this.outputFilterLogic = new TargetContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getOutputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), "outputFilter");
        this.deserialize();
    }

    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        boolean done;
        this.initDirections(level, pos);
        if (this.coolDownTime > level.m_46467_()) {
            return;
        }
        for (Direction pushDirection : this.pushDirections) {
            done = false;
            for (LazyOptional<IItemHandler> itemHandler : this.getItemHandlers(level, pos, pushDirection, entity == null)) {
                if (!itemHandler.map(this::pushItems).orElse(false).booleanValue()) continue;
                done = true;
                break;
            }
            if (!done) {
                WorldlyContainer worldlyContainer;
                Iterator<LazyOptional<IItemHandler>> iterator = this.getWorldlyContainers(level, pos, pushDirection).iterator();
                while (iterator.hasNext() && !this.pushItemsToContainer((Container)(worldlyContainer = (WorldlyContainer)iterator.next()), pushDirection.m_122424_())) {
                }
            }
            if (done) continue;
            this.getEntityContainer(level, pos, pushDirection, entity).ifPresent(container -> this.pushItemsToContainer((Container)container, pushDirection.m_122424_()));
        }
        for (Direction pullDirection : this.pullDirections) {
            done = false;
            for (LazyOptional<IItemHandler> itemHandler : this.getItemHandlers(level, pos, pullDirection, entity == null)) {
                if (!itemHandler.map(this::pullItems).orElse(false).booleanValue()) continue;
                done = true;
                break;
            }
            if (!done) {
                for (WorldlyContainer worldlyContainer : this.getWorldlyContainers(level, pos, pullDirection)) {
                    if (!this.pullItemsFromContainer((Container)worldlyContainer, pullDirection.m_122424_())) continue;
                    done = true;
                    break;
                }
            }
            if (done) continue;
            this.getEntityContainer(level, pos, pullDirection, entity).ifPresent(container -> this.pullItemsFromContainer((Container)container, pullDirection.m_122424_()));
        }
        this.coolDownTime = level.m_46467_() + ((HopperUpgradeItem)this.upgradeItem).getTransferSpeedTicks();
    }

    private Optional<Container> getEntityContainer(Level level, BlockPos pos, Direction direction, @Nullable Entity entity) {
        List<BlockPos> list;
        Object object;
        BlockState storageState = level.m_8055_(pos);
        if (entity == null && (object = storageState.m_60734_()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)object;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.m_121945_(direction));
        }
        List<BlockPos> offsetPositions = list;
        ArrayList entities = new ArrayList();
        for (BlockPos offsetPosition : offsetPositions) {
            entities.addAll(level.m_6249_((Entity)null, new AABB(offsetPosition), e -> e != entity && EntitySelector.f_20405_.test(e)));
        }
        if (!entities.isEmpty()) {
            Collections.shuffle(entities);
            return Optional.of((Container)entities.get(0));
        }
        return Optional.empty();
    }

    private boolean pushItemsToContainer(Container worldlyContainer, Direction face) {
        ITrackedContentsItemHandler fromHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        this.outputFilterLogic.setInventory(EmptyHandler.INSTANCE);
        for (int slot = 0; slot < fromHandler.getSlots(); ++slot) {
            ItemStack extractedStack;
            ItemStack slotStack = fromHandler.getStackInSlot(slot);
            if (slotStack.m_41619_() || !this.outputFilterLogic.matchesFilter(slotStack) || (extractedStack = fromHandler.extractItem(slot, Math.min(worldlyContainer.m_6893_(), ((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize()), true)).m_41619_() || !this.pushStackToContainer(worldlyContainer, face, extractedStack, fromHandler, slot)) continue;
            return true;
        }
        return false;
    }

    private boolean pushStackToContainer(Container container, Direction face, ItemStack extractedStack, ITrackedContentsItemHandler fromHandler, int slotToExtractFrom) {
        for (int containerSlot = 0; containerSlot < container.m_6643_(); ++containerSlot) {
            int maxStackSize;
            int remainder;
            WorldlyContainer worldlyContainer;
            if (container instanceof WorldlyContainer && !(worldlyContainer = (WorldlyContainer)container).m_7155_(containerSlot, extractedStack, face)) continue;
            ItemStack existingStack = container.m_8020_(containerSlot);
            if (existingStack.m_41619_()) {
                container.m_6836_(containerSlot, extractedStack);
                fromHandler.extractItem(slotToExtractFrom, extractedStack.m_41613_(), false);
                return true;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)extractedStack) || (remainder = (maxStackSize = Math.min(container.m_6893_(), existingStack.m_41741_())) - existingStack.m_41613_()) <= 0) continue;
            int countToExtract = Math.min(extractedStack.m_41613_(), remainder);
            existingStack.m_41769_(countToExtract);
            container.m_6836_(containerSlot, existingStack);
            fromHandler.extractItem(slotToExtractFrom, countToExtract, false);
            return true;
        }
        return false;
    }

    private boolean pullItemsFromContainer(Container container, Direction face) {
        ITrackedContentsItemHandler toHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        for (int containerSlot = 0; containerSlot < container.m_6643_(); ++containerSlot) {
            ItemStack remainingStack;
            WorldlyContainer worldlyContainer;
            ItemStack stackToInsert = container.m_8020_(containerSlot).m_41777_();
            if (stackToInsert.m_41613_() > ((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize()) {
                stackToInsert.m_41764_(((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize());
            }
            if (stackToInsert.m_41619_() || container instanceof WorldlyContainer && !(worldlyContainer = (WorldlyContainer)container).m_7157_(containerSlot, stackToInsert, face) || !this.inputFilterLogic.matchesFilter(stackToInsert) || (remainingStack = InventoryHelper.insertIntoInventory((ItemStack)stackToInsert, (IItemHandler)toHandler, (boolean)false)).m_41613_() >= stackToInsert.m_41613_()) continue;
            container.m_7407_(containerSlot, stackToInsert.m_41613_() - remainingStack.m_41613_());
            return true;
        }
        return false;
    }

    private void initDirections(Level level, BlockPos pos) {
        if (this.upgrade.m_41782_() && (this.upgrade.m_41720_() != ModItems.HOPPER_UPGRADE.get() || this.directionsInitialized)) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            Direction horizontalDirection = storageBlock.getHorizontalDirection(state);
            VerticalFacing verticalFacing = storageBlock.getVerticalFacing(state);
            this.pullDirections.clear();
            this.pushDirections.clear();
            this.initDirections(BlockSide.BOTTOM.toDirection(horizontalDirection, verticalFacing), BlockSide.TOP.toDirection(horizontalDirection, verticalFacing));
            this.directionsInitialized = true;
        } else {
            this.initDirections(Direction.DOWN, Direction.UP);
        }
    }

    private List<WorldlyContainer> getWorldlyContainers(Level level, BlockPos pos, Direction direction) {
        List<BlockPos> list;
        BlockState storageState = level.m_8055_(pos);
        Block block = storageState.m_60734_();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.m_121945_(direction));
        }
        List<BlockPos> offsetPositions = list;
        ArrayList<WorldlyContainer> worldlyContainers = new ArrayList<WorldlyContainer>();
        offsetPositions.forEach(offsetPos -> {
            BlockState state = level.m_8055_(offsetPos);
            Block patt10163$temp = state.m_60734_();
            if (patt10163$temp instanceof WorldlyContainerHolder) {
                WorldlyContainerHolder worldlyContainerHolder = (WorldlyContainerHolder)patt10163$temp;
                worldlyContainers.add(worldlyContainerHolder.m_5840_(state, (LevelAccessor)level, offsetPos));
            }
        });
        return worldlyContainers;
    }

    private boolean pullItems(IItemHandler fromHandler) {
        return this.moveItems(fromHandler, (IItemHandler)this.storageWrapper.getInventoryForUpgradeProcessing(), (FilterLogic)this.inputFilterLogic);
    }

    private boolean pushItems(IItemHandler toHandler) {
        this.outputFilterLogic.setInventory(toHandler);
        return this.moveItems((IItemHandler)this.storageWrapper.getInventoryForUpgradeProcessing(), toHandler, (FilterLogic)this.outputFilterLogic);
    }

    private boolean moveItems(IItemHandler fromHandler, IItemHandler toHandler, FilterLogic filterLogic) {
        for (int slot = 0; slot < fromHandler.getSlots(); ++slot) {
            ItemStack remainder;
            ItemStack extractedStack;
            ItemStack slotStack = fromHandler.getStackInSlot(slot);
            if (slotStack.m_41619_() || !filterLogic.matchesFilter(slotStack) || (extractedStack = fromHandler.extractItem(slot, ((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize(), true)).m_41619_() || (remainder = InventoryHelper.insertIntoInventory((ItemStack)extractedStack, (IItemHandler)toHandler, (boolean)true)).m_41613_() >= extractedStack.m_41613_()) continue;
            InventoryHelper.insertIntoInventory((ItemStack)fromHandler.extractItem(slot, extractedStack.m_41613_() - remainder.m_41613_(), false), (IItemHandler)toHandler, (boolean)false);
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborChange(Level level, BlockPos pos, Direction direction) {
        if (!level.m_5776_() && (this.pushDirections.contains(direction) || this.pullDirections.contains(direction)) && this.needsCacheUpdate(level, pos, direction)) {
            this.updateCacheOnSide(level, pos, direction);
        }
    }

    private boolean needsCacheUpdate(Level level, BlockPos pos, Direction direction) {
        ItemHandlerHolder holder = this.handlerCache.get(direction);
        if (holder == null || holder.handlers().isEmpty()) {
            return !level.m_8055_(pos).m_60795_();
        }
        if (holder.refreshOnEveryNeighborChange()) {
            return true;
        }
        for (LazyOptional<IItemHandler> handler : holder.handlers()) {
            if (handler.isPresent()) continue;
            return true;
        }
        return false;
    }

    public void updateCacheOnSide(Level level, BlockPos pos, Direction direction) {
        List<BlockPos> list;
        if (!level.m_46749_(pos) || !level.m_46749_(pos.m_121945_(direction))) {
            this.handlerCache.remove(direction);
            return;
        }
        BlockState storageState = level.m_8055_(pos);
        Block block = storageState.m_60734_();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.m_121945_(direction));
        }
        List<BlockPos> offsetPositions = list;
        ArrayList<LazyOptional<IItemHandler>> caches = new ArrayList<LazyOptional<IItemHandler>>();
        AtomicBoolean refreshOnEveryNeighborChange = new AtomicBoolean(false);
        offsetPositions.forEach(offsetPos -> WorldHelper.getLoadedBlockEntity((Level)level, (BlockPos)offsetPos).ifPresent(blockEntity -> {
            LazyOptional lazyOptional;
            if (blockEntity instanceof StorageInputBlockEntity) {
                StorageInputBlockEntity input = (StorageInputBlockEntity)((Object)((Object)blockEntity));
                refreshOnEveryNeighborChange.set(true);
                blockEntity = input.getControllerPos().map(arg_0 -> ((Level)level).m_7702_(arg_0)).orElse((BlockEntity)blockEntity);
            }
            if ((lazyOptional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_())).isPresent()) {
                lazyOptional.addListener(l -> this.updateCacheOnSide(level, pos, direction));
                caches.add(lazyOptional);
            }
        }));
        this.handlerCache.put(direction, new ItemHandlerHolder(caches, refreshOnEveryNeighborChange.get()));
    }

    private List<LazyOptional<IItemHandler>> getItemHandlers(Level level, BlockPos pos, Direction direction, boolean useCache) {
        if (useCache && !this.handlerCache.containsKey(direction)) {
            this.updateCacheOnSide(level, pos, direction);
        }
        return this.handlerCache.containsKey(direction) ? this.handlerCache.get(direction).handlers() : Collections.emptyList();
    }

    public ContentsFilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public ContentsFilterLogic getOutputFilterLogic() {
        return this.outputFilterLogic;
    }

    public boolean isPullingFrom(Direction direction) {
        return this.pullDirections.contains(direction);
    }

    public boolean isPushingTo(Direction direction) {
        return this.pushDirections.contains(direction);
    }

    public void setPullingFrom(Direction direction, boolean shouldPull) {
        if (shouldPull) {
            this.pullDirections.add(direction);
        } else {
            this.pullDirections.remove(direction);
        }
        this.serializePullDirections();
    }

    public void setPushingTo(Direction direction, boolean isPushing) {
        if (isPushing) {
            this.pushDirections.add(direction);
        } else {
            this.pushDirections.remove(direction);
        }
        this.serializePushDirections();
    }

    private void serializePullDirections() {
        NBTHelper.putList((CompoundTag)this.upgrade.m_41784_(), (String)"pullDirections", this.pullDirections, d -> StringTag.m_129297_((String)d.m_7912_()));
        this.save();
    }

    private void serializePushDirections() {
        NBTHelper.putList((CompoundTag)this.upgrade.m_41784_(), (String)"pushDirections", this.pushDirections, d -> StringTag.m_129297_((String)d.m_7912_()));
        this.save();
    }

    public void deserialize() {
        this.pullDirections.clear();
        this.pushDirections.clear();
        if (this.upgrade.m_41782_()) {
            this.pullDirections = NBTHelper.getCollection((CompoundTag)this.upgrade.m_41784_(), (String)"pullDirections", (byte)8, t -> Optional.ofNullable(Direction.m_122402_((String)t.m_7916_())), HashSet::new).orElseGet(HashSet::new);
            this.pushDirections = NBTHelper.getCollection((CompoundTag)this.upgrade.m_41784_(), (String)"pushDirections", (byte)8, t -> Optional.ofNullable(Direction.m_122402_((String)t.m_7916_())), HashSet::new).orElseGet(HashSet::new);
        }
    }

    public void initDirections(Direction pushDirection, Direction pullDirection) {
        this.setPushingTo(pushDirection, true);
        this.setPullingFrom(pullDirection, true);
    }

    private record ItemHandlerHolder(List<LazyOptional<IItemHandler>> handlers, boolean refreshOnEveryNeighborChange) {
    }
}

