/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;

public class BarrelMaterialRecipe
extends CustomRecipe {
    public BarrelMaterialRecipe(ResourceLocation registryName, CraftingBookCategory category) {
        super(registryName, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        int barrelRow = -1;
        int barrelCol = -1;
        int minRowWithBlock = Integer.MAX_VALUE;
        int minColWithBlock = Integer.MAX_VALUE;
        int maxRowWithBlock = Integer.MIN_VALUE;
        int maxColWithBlock = Integer.MIN_VALUE;
        HashMap<Integer, Integer> rowCounts = new HashMap<Integer, Integer>();
        for (int row = 0; row < container.m_39346_(); ++row) {
            for (int col = 0; col < container.m_39347_(); ++col) {
                BlockItem blockItem;
                BlockItem blockItem2;
                ItemStack item = container.m_8020_(col + row * container.m_39347_());
                if (item.m_41619_()) continue;
                Item item2 = item.m_41720_();
                if (item2 instanceof BlockItem && (blockItem2 = (BlockItem)item2).m_40614_() instanceof BarrelBlock) {
                    if (barrelRow < 0) {
                        barrelRow = row;
                        barrelCol = col;
                        continue;
                    }
                    return false;
                }
                item2 = item.m_41720_();
                if (item2 instanceof BlockItem && Block.m_49916_((VoxelShape)(blockItem = (BlockItem)item2).m_40614_().m_49966_().m_60808_((BlockGetter)level, BlockPos.f_121853_))) {
                    boolean isBottomMiddleAndBottomLeftHasBlock;
                    boolean bl = isBottomMiddleAndBottomLeftHasBlock = barrelCol == col && barrelRow < row && rowCounts.getOrDefault(row, 0) > 0;
                    if (isBottomMiddleAndBottomLeftHasBlock) {
                        return false;
                    }
                    rowCounts.compute(row, (k, v) -> v == null ? 1 : v + 1);
                    if (row < minRowWithBlock) {
                        minRowWithBlock = row;
                    }
                    if (col < minColWithBlock) {
                        minColWithBlock = col;
                    }
                    if (row > maxRowWithBlock) {
                        maxRowWithBlock = row;
                    }
                    if (col <= maxColWithBlock) continue;
                    maxColWithBlock = col;
                    continue;
                }
                return false;
            }
        }
        if (barrelRow < 0 || rowCounts.isEmpty() || minRowWithBlock < barrelRow - 1 || maxRowWithBlock > barrelRow + 1 || minColWithBlock < barrelCol - 1 || maxColWithBlock > barrelCol + 1) {
            return false;
        }
        return rowCounts.getOrDefault(barrelRow - 1, 0) <= 3 && rowCounts.getOrDefault(barrelRow, 0) <= 2 && rowCounts.getOrDefault(barrelRow + 1, 0) <= 2;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        int barrelColumn = -1;
        int barrelRow = -1;
        ItemStack barrelStackCopy = ItemStack.f_41583_;
        for (int row = 0; row < container.m_39346_(); ++row) {
            for (int col = 0; col < container.m_39347_(); ++col) {
                BlockItem blockItem;
                Item item;
                ItemStack item2 = container.m_8020_(col + row * container.m_39347_());
                if (item2.m_41619_() || barrelColumn >= 0 || !((item = item2.m_41720_()) instanceof BlockItem) || !((blockItem = (BlockItem)item).m_40614_() instanceof BarrelBlock)) continue;
                barrelColumn = col;
                barrelRow = row;
                barrelStackCopy = item2.m_41777_();
                barrelStackCopy.m_41764_(1);
            }
        }
        EnumMap<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(barrelStackCopy));
        BarrelBlockItem.uncompactMaterials(materials);
        this.fillGridMaterials(container, barrelColumn, barrelRow, materials);
        BarrelMaterialRecipe.fillEmptyMaterialsWithDefaults(materials);
        BarrelBlockItem.compactMaterials(materials);
        BarrelBlockItem.setMaterials(barrelStackCopy, materials);
        BarrelBlockItem.removeCoveredTints(barrelStackCopy, materials);
        return barrelStackCopy;
    }

    private static void fillEmptyMaterialsWithDefaults(Map<BarrelMaterial, ResourceLocation> materials) {
        block0: for (BarrelMaterial material : BarrelMaterial.values()) {
            if (!material.isLeaf() || materials.containsKey((Object)material)) continue;
            for (BarrelMaterial fillFromDefault : BarrelMaterial.getFillFromDefaults(material)) {
                if (!materials.containsKey((Object)fillFromDefault)) continue;
                materials.put(material, materials.get((Object)fillFromDefault));
                continue block0;
            }
        }
    }

    private void fillGridMaterials(CraftingContainer container, int barrelColumn, int barrelRow, Map<BarrelMaterial, ResourceLocation> materials) {
        for (int row = 0; row < container.m_39346_(); ++row) {
            for (int col = 0; col < container.m_39347_(); ++col) {
                Item item;
                ItemStack item2 = container.m_8020_(col + row * container.m_39347_());
                if (row == barrelRow && col == barrelColumn || item2.m_41619_() || !((item = item2.m_41720_()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                List<BarrelMaterial> barrelMaterials = this.getBarrelMaterials(row, col, barrelRow, barrelColumn);
                boolean firstMaterial = true;
                for (BarrelMaterial barrelMaterial : barrelMaterials) {
                    if (!materials.containsKey((Object)barrelMaterial) || firstMaterial) {
                        materials.put(barrelMaterial, ForgeRegistries.BLOCKS.getKey((Object)blockItem.m_40614_()));
                    }
                    firstMaterial = false;
                }
            }
        }
    }

    private List<BarrelMaterial> getBarrelMaterials(int row, int col, int barrelRow, int barrelColumn) {
        if (row < barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.TOP);
            }
            if (col == barrelColumn) {
                return List.of(BarrelMaterial.TOP_INNER_TRIM, BarrelMaterial.TOP, BarrelMaterial.TOP_TRIM);
            }
            return List.of(BarrelMaterial.TOP_TRIM);
        }
        if (row == barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.SIDE);
            }
            return List.of(BarrelMaterial.SIDE_TRIM);
        }
        if (col < barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM);
        }
        if (col == barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM, BarrelMaterial.BOTTOM_TRIM);
        }
        return List.of(BarrelMaterial.BOTTOM_TRIM);
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModBlocks.BARREL_MATERIAL_RECIPE_SERIALIZER.get();
    }
}

