/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.CraftingContainerRecipeTransferHandlerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.SettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.StorageGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageSettingsScreen;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.FlatBarrelRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.ShulkerBoxFromChestRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.TierUpgradeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromVanillaShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

@JeiPlugin
public class StoragePlugin
implements IModPlugin {
    private static Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar = registration -> {};

    public static void setAdditionalCatalystRegistrar(Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar) {
        StoragePlugin.additionalCatalystRegistrar = additionalCatalystRegistrar;
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("sophisticatedstorage", "default");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        IIngredientSubtypeInterpreter woodStorageNbtInterpreter = (itemStack, context) -> {
            StringJoiner result = new StringJoiner(",");
            WoodStorageBlockItem.getWoodType(itemStack).ifPresent(woodName -> result.add("woodName:" + woodName));
            StorageBlockItem.getMainColorFromStack(itemStack).ifPresent(mainColor -> result.add("mainColor:" + mainColor));
            StorageBlockItem.getAccentColorFromStack(itemStack).ifPresent(accentColor -> result.add("accentColor:" + accentColor));
            return "{" + result + "}";
        };
        IIngredientSubtypeInterpreter barrelNbtInterpreter = (itemStack, context) -> {
            StringJoiner result = new StringJoiner(",");
            WoodStorageBlockItem.getWoodType(itemStack).ifPresent(woodName -> result.add("woodName:" + woodName));
            StorageBlockItem.getMainColorFromStack(itemStack).ifPresent(mainColor -> result.add("mainColor:" + mainColor));
            StorageBlockItem.getAccentColorFromStack(itemStack).ifPresent(accentColor -> result.add("accentColor:" + accentColor));
            result.add("flatTop:" + BarrelBlockItem.isFlatTop(itemStack));
            return "{" + result + "}";
        };
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.BARREL_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.COPPER_BARREL_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.IRON_BARREL_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.GOLD_BARREL_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.DIAMOND_BARREL_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.NETHERITE_BARREL_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.CHEST_ITEM.get()), woodStorageNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.COPPER_CHEST_ITEM.get()), woodStorageNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.IRON_CHEST_ITEM.get()), woodStorageNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.GOLD_CHEST_ITEM.get()), woodStorageNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.DIAMOND_CHEST_ITEM.get()), woodStorageNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.NETHERITE_CHEST_ITEM.get()), woodStorageNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_BARREL_1_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_BARREL_2_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_BARREL_3_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_BARREL_4_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get()), barrelNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get()), barrelNbtInterpreter);
        IIngredientSubtypeInterpreter shulkerBoxNbtInterpreter = (itemStack, context) -> {
            StringJoiner result = new StringJoiner(",");
            StorageBlockItem.getMainColorFromStack(itemStack).ifPresent(mainColor -> result.add("mainColor:" + mainColor));
            StorageBlockItem.getAccentColorFromStack(itemStack).ifPresent(accentColor -> result.add("accentColor:" + accentColor));
            return "{" + result + "}";
        };
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.SHULKER_BOX_ITEM.get()), shulkerBoxNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get()), shulkerBoxNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get()), shulkerBoxNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get()), shulkerBoxNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get()), shulkerBoxNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()), shulkerBoxNbtInterpreter);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(StorageScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<StorageScreen>(){

            public List<Rect2i> getGuiExtraAreas(StorageScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                gui.getUpgradeSlotsRectangle().ifPresent(ret::add);
                ret.addAll(gui.getUpgradeSettingsControl().getTabRectangles());
                gui.getSortButtonsRectangle().ifPresent(ret::add);
                return ret;
            }
        });
        registration.addGuiContainerHandler(StorageSettingsScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<StorageSettingsScreen>(){

            public List<Rect2i> getGuiExtraAreas(StorageSettingsScreen gui) {
                return new ArrayList<Rect2i>(gui.getSettingsTabControl().getTabRectangles());
            }
        });
        registration.addGhostIngredientHandler(StorageScreen.class, (IGhostIngredientHandler)new StorageGhostIngredientHandler());
        registration.addGhostIngredientHandler(SettingsScreen.class, (IGhostIngredientHandler)new SettingsGhostIngredientHandler());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.CRAFTING, DyeRecipesMaker.getRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, TierUpgradeRecipesMaker.getShapedCraftingRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, TierUpgradeRecipesMaker.getShapelessCraftingRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, ClientRecipeHelper.getAndTransformAvailableRecipes(ShulkerBoxFromVanillaShapelessRecipe.REGISTERED_RECIPES, ShulkerBoxFromVanillaShapelessRecipe.class, ClientRecipeHelper::copyShapelessRecipe));
        registration.addRecipes(RecipeTypes.CRAFTING, ShulkerBoxFromChestRecipesMaker.getRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, FlatBarrelRecipesMaker.getRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.CRAFTING_UPGRADE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.STONECUTTER_UPGRADE.get()), new RecipeType[]{RecipeTypes.STONECUTTING});
        additionalCatalystRegistrar.accept(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingContainerRecipeTransferHandlerBase<StorageContainerMenu, CraftingRecipe>(handlerHelper, stackHelper){

            public Class<StorageContainerMenu> getContainerClass() {
                return StorageContainerMenu.class;
            }

            public RecipeType<CraftingRecipe> getRecipeType() {
                return RecipeTypes.CRAFTING;
            }
        }, RecipeTypes.CRAFTING);
    }
}

