/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import org.joml.Vector3f;

public class LimitedBarrelRenderer
extends BarrelRenderer<LimitedBarrelBlockEntity> {
    public static final Material FILL_INDICATORS_TEXTURE = new Material(InventoryMenu.f_39692_, SophisticatedStorage.getRL("block/fill_indicators"));
    private static final float MULTIPLE_ITEMS_FONT_SCALE = 0.010416667f;
    private static final float SINGLE_ITEM_FONT_SCALE = 0.020833334f;
    private static final Style COUNT_DISPLAY_STYLE = Style.f_131099_.m_131150_(Minecraft.f_91058_).m_131136_(Boolean.valueOf(true));
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0625));
    private final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, Vec3.f_82478_);

    @Override
    public void render(LimitedBarrelBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        StorageBlockBase storageBlock;
        BlockState blockState;
        block5: {
            block4: {
                Block block;
                blockState = blockEntity.m_58900_();
                if (blockEntity.isPacked() || !((block = blockState.m_60734_()) instanceof StorageBlockBase)) break block4;
                storageBlock = (StorageBlockBase)block;
                if (blockEntity.hasDynamicRenderer() || blockEntity.shouldShowCounts() || this.holdsItemThatShowsUpgrades() || blockEntity.shouldShowUpgrades()) break block5;
            }
            return;
        }
        boolean flatTop = (Boolean)blockState.m_61143_((Property)BarrelBlock.FLAT_TOP);
        Direction horizontalFacing = (Direction)blockState.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING);
        this.renderItemCounts(blockEntity, poseStack, bufferSource, flatTop, horizontalFacing, (VerticalFacing)((Object)blockState.m_61143_(LimitedBarrelBlock.VERTICAL_FACING)), packedLight);
        if (blockEntity.m_58904_() != null) {
            packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_121945_(storageBlock.getFacing(blockState)));
        }
        this.renderFrontFace(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, blockState, flatTop, horizontalFacing);
        this.renderHiddenTier(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderHiddenLock(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderFrontFace(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BlockState blockState, boolean flatTop, Direction horizontalFacing) {
        if (blockEntity.hasDynamicRenderer() || this.holdsItemThatShowsUpgrades() || blockEntity.shouldShowUpgrades() || blockEntity.shouldShowFillLevels() || this.holdsItemThatShowsFillLevels()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(horizontalFacing));
            VerticalFacing verticalFacing = (VerticalFacing)((Object)blockState.m_61143_(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != VerticalFacing.NO) {
                poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection()));
            }
            poseStack.m_85837_(-0.5, -0.5, -(0.5 - (double)(flatTop ? 0.0f : 0.0625f)));
            if (blockEntity.hasDynamicRenderer()) {
                this.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop);
            }
            boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
            if (blockEntity.shouldShowUpgrades() || holdsItemThatShowsUpgrades) {
                this.renderUpgrades(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop, holdsItemThatShowsUpgrades);
            }
            if (blockEntity.shouldShowFillLevels() || this.holdsItemThatShowsFillLevels()) {
                this.renderFillLevels(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
            }
            poseStack.m_85849_();
        }
    }

    private void renderUpgrades(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean flatTop, boolean holdsItemThatShowsUpgrades) {
        if (flatTop) {
            this.flatDisplayItemRenderer.renderUpgradeItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
        } else {
            this.displayItemRenderer.renderUpgradeItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
        }
    }

    private void renderFillLevels(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, -0.001);
        List<Float> slotFillLevels = blockEntity.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotFillRatios();
        if (slotFillLevels.isEmpty()) {
            slotFillLevels = blockEntity.getSlotFillLevels();
        }
        int slots = slotFillLevels.size();
        boolean translucentRender = !blockEntity.shouldShowFillLevels() && this.holdsToolInToggleFillLevelDisplay();
        switch (slots) {
            case 1: {
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(0).floatValue(), 0.0625f, 0.0625f, true, translucentRender);
                break;
            }
            case 2: {
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(0).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(1).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
                break;
            }
            case 3: {
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(0).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(1).floatValue(), 0.875f, 0.0625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(2).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
                break;
            }
            case 4: {
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(0).floatValue(), 0.875f, 0.5625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(1).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(2).floatValue(), 0.875f, 0.0625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(3).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
            }
        }
        poseStack.m_85849_();
    }

    private void renderDisplayItems(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean flatTop) {
        if (flatTop) {
            this.flatDisplayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        } else {
            this.displayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        }
    }

    private void renderItemCounts(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, boolean flatTop, Direction horizontalFacing, VerticalFacing verticalFacing, int packedLight) {
        if (!blockEntity.shouldShowCounts()) {
            return;
        }
        if (blockEntity.m_58904_() != null) {
            packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_121945_(verticalFacing != VerticalFacing.NO ? verticalFacing.getDirection() : horizontalFacing));
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(horizontalFacing.m_122424_()));
        if (verticalFacing != VerticalFacing.NO) {
            poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection().m_122424_()));
        }
        poseStack.m_85837_(0.5, -0.5, 0.5);
        List<Integer> slotCounts = blockEntity.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotCounts();
        if (slotCounts.isEmpty()) {
            slotCounts = blockEntity.getSlotCounts();
        }
        float countDisplayYOffset = -(slotCounts.size() == 1 ? 0.25f : 0.11f);
        for (int displayItemIndex = 0; displayItemIndex < slotCounts.size(); ++displayItemIndex) {
            int count = slotCounts.get(displayItemIndex);
            if (count <= 0) continue;
            poseStack.m_85836_();
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, slotCounts.size());
            double xTranslation = -frontOffset.x();
            float yTranslation = frontOffset.y() + countDisplayYOffset;
            double zTranslation = 0.001 - (flatTop ? 0.0 : 0.046875);
            poseStack.m_85837_(xTranslation, (double)yTranslation, zTranslation);
            float scale = slotCounts.size() == 1 ? 0.020833334f : 0.010416667f;
            poseStack.m_85841_(scale, -scale, scale);
            MutableComponent countString = Component.m_237113_((String)CountAbbreviator.abbreviate((int)count, (int)(slotCounts.size() == 1 ? 6 : 5))).m_130948_(COUNT_DISPLAY_STYLE);
            Font font = Minecraft.m_91087_().f_91062_;
            float countDisplayXOffset = -font.m_92865_().m_92384_((FormattedText)countString) / 2.0f;
            poseStack.m_252880_(countDisplayXOffset, 0.0f, 0.0f);
            font.m_272077_((Component)countString, 0.0f, 0.0f, blockEntity.getSlotColor(displayItemIndex), false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderFillLevel(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float fillLevel, float x, float y, boolean large, boolean translucentRender) {
        VertexConsumer vertexConsumer;
        poseStack.m_85836_();
        poseStack.m_252880_(x + 0.0125f, y + 0.0125f, 0.0f);
        int barHeight = large ? 14 : 6;
        poseStack.m_85841_(0.0375f, fillLevel * 1.0f / 16.0f / 5.0f * (float)(barHeight * 5 - 2), 1.0f);
        poseStack.m_85836_();
        if (translucentRender) {
            TextureAtlasSprite sprite = FILL_INDICATORS_TEXTURE.m_119204_();
            vertexConsumer = sprite.m_118381_(bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)sprite.m_247685_())));
        } else {
            vertexConsumer = FILL_INDICATORS_TEXTURE.m_119194_(bufferSource, RenderType::m_110458_);
        }
        PoseStack.Pose pose = poseStack.m_85850_();
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        pose.m_252943_().transform(normal);
        float minU = large ? 0.0f : 0.0234375f;
        float maxV = large ? 0.53125f : 0.21875f;
        RenderHelper.renderQuad(vertexConsumer, pose.m_252922_(), normal, packedOverlay, packedLight, translucentRender ? 0.5f : 1.0f, minU, (1.0f - fillLevel) * maxV, minU + 0.0234375f, maxV);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }
}

