/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ChestRenderer
extends StorageRenderer<ChestBlockEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.4378125, new Vec3(-0.0625, 0.0, -0.0075));
    private final Map<ChestType, ChestSubRenderer> chestSubRenderers;

    public ChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ClientEventHandler.CHEST_LAYER);
        ChestSubRenderer singleChestRenderer = new ChestSubRenderer(ChestType.SINGLE, modelpart.m_171324_(LID), modelpart.m_171324_(BOTTOM), modelpart.m_171324_(LOCK));
        modelpart = context.m_173582_(ClientEventHandler.CHEST_RIGHT_LAYER);
        ChestSubRenderer doubleChestRightRenderer = new ChestSubRenderer(ChestType.RIGHT, modelpart.m_171324_(LID), modelpart.m_171324_(BOTTOM), modelpart.m_171324_(LOCK));
        modelpart = context.m_173582_(ClientEventHandler.CHEST_LEFT_LAYER);
        ChestSubRenderer doubleChestLeftRenderer = new ChestSubRenderer(ChestType.LEFT, modelpart.m_171324_(LID), modelpart.m_171324_(BOTTOM), modelpart.m_171324_(LOCK));
        this.chestSubRenderers = Map.of(ChestType.SINGLE, singleChestRenderer, ChestType.RIGHT, doubleChestRightRenderer, ChestType.LEFT, doubleChestLeftRenderer);
    }

    public static LayerDefinition createSingleBodyLayer(boolean addLock) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        if (addLock) {
            partDefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(15.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(ChestBlockEntity chestEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockstate = chestEntity.m_58900_();
        Optional<WoodType> woodType = chestEntity.getWoodType();
        ChestType chestType = (ChestType)blockstate.m_61143_(ChestBlock.TYPE);
        ChestSubRenderer subRenderer = this.chestSubRenderers.get(chestType);
        if (!subRenderer.setChestMaterialsFrom(woodType.orElse(WoodType.f_61833_), blockstate.m_60734_())) {
            return;
        }
        poseStack.m_85836_();
        Direction facing = (Direction)blockstate.m_61143_((Property)ChestBlock.FACING);
        float f = facing.m_122435_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        float lidAngle = chestEntity.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        StorageWrapper storageWrapper = chestEntity.getMainStorageWrapper();
        boolean hasMainColor = storageWrapper.hasMainColor();
        boolean hasAccentColor = storageWrapper.hasAccentColor();
        if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
            subRenderer.renderBottomAndLid(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, StorageTextureManager.ChestMaterial.BASE);
        }
        if (hasMainColor) {
            subRenderer.renderBottomAndLidWithTint(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, storageWrapper.getMainColor(), StorageTextureManager.ChestMaterial.TINTABLE_MAIN);
        }
        if (hasAccentColor) {
            subRenderer.renderBottomAndLidWithTint(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, storageWrapper.getAccentColor(), StorageTextureManager.ChestMaterial.TINTABLE_ACCENT);
        }
        if (chestEntity.shouldShowTier()) {
            subRenderer.renderTier(poseStack, bufferSource, lidAngle, packedLight, packedOverlay);
        } else if (this.holdsItemThatShowsHiddenTiers()) {
            subRenderer.renderHiddenTier(poseStack, bufferSource, packedLight, packedOverlay);
        }
        Optional displayItem = storageWrapper.getRenderInfo().getItemDisplayRenderInfo().getDisplayItem();
        if (displayItem.map(di -> di.getDisplaySide() != DisplaySide.FRONT).orElse(true).booleanValue()) {
            subRenderer.renderChestLock(poseStack, bufferSource, lidAngle, packedLight, packedOverlay);
        }
        if (chestEntity.isPacked()) {
            poseStack.m_85836_();
            poseStack.m_85837_(-0.005, -0.005, -0.005);
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            subRenderer.renderBottomAndLid(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, StorageTextureManager.ChestMaterial.PACKED);
            poseStack.m_85849_();
        } else if (chestEntity.m_58899_() == BlockPos.f_121853_ || this.shouldRenderFrontFace(chestEntity.m_58899_())) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_85836_();
            poseStack.m_85837_(-0.5, -0.5, -0.4375);
            if (chestEntity.isMainChest() && (chestEntity.shouldShowUpgrades() || this.holdsItemThatShowsUpgrades())) {
                poseStack.m_85836_();
                if (chestType == ChestType.LEFT) {
                    poseStack.m_252880_(1.0f, 0.0f, 0.0f);
                }
                this.displayItemRenderer.renderUpgradeItems(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(chestEntity));
                poseStack.m_85849_();
            }
            if (chestEntity.isMainChest()) {
                this.renderLocked(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, chestType, lidAngle);
            }
            poseStack.m_85849_();
            if (chestEntity.isMainChest()) {
                displayItem.ifPresent(di -> this.renderDisplayItem((RenderInfo.DisplayItem)di, poseStack, bufferSource, packedLight, packedOverlay, chestType));
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderDisplayItem(RenderInfo.DisplayItem displayItem, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, ChestType chestType) {
        DisplaySide displaySide = displayItem.getDisplaySide();
        if (displaySide == DisplaySide.LEFT) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            if (chestType == ChestType.LEFT) {
                poseStack.m_252880_(0.0f, 0.0f, -1.0f);
            }
        } else if (displaySide == DisplaySide.RIGHT) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            if (chestType == ChestType.RIGHT) {
                poseStack.m_252880_(0.0f, 0.0f, -1.0f);
            }
        } else if (displaySide == DisplaySide.FRONT) {
            if (chestType == ChestType.RIGHT) {
                poseStack.m_85837_(-0.5, 0.0, 0.0);
            } else if (chestType == ChestType.LEFT) {
                poseStack.m_85837_(0.5, 0.0, 0.0);
            }
        }
        poseStack.m_85837_(-0.5, -0.5, -0.4375);
        this.displayItemRenderer.renderDisplayItem(poseStack, bufferSource, packedLight, packedOverlay, displayItem);
    }

    private void renderLocked(ChestBlockEntity chestEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, ChestType chestType, float lidAngle) {
        poseStack.m_85836_();
        if (lidAngle > 0.0f) {
            poseStack.m_85837_(0.0, 0.5625, 0.875);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(lidAngle * 90.0f));
            poseStack.m_85837_(0.0, -0.5625, -0.875);
        }
        if (chestType == ChestType.LEFT) {
            poseStack.m_85837_(0.5, 0.0, 0.0);
        } else if (chestType == ChestType.RIGHT) {
            poseStack.m_85837_(-0.5, 0.0, 0.0);
        }
        LockRenderer.renderLock(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, 0.8125f, this::holdsToolInToggleLockOrLockDisplay);
        poseStack.m_85849_();
    }

    private boolean shouldRenderFrontFace(BlockPos chestPos) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        return Vec3.m_82512_((Vec3i)chestPos).m_82509_((Position)camera.m_90583_(), 32.0);
    }

    private static class ChestSubRenderer {
        private final ChestType chestType;
        private final ModelPart lidPart;
        private final ModelPart bottomPart;
        private final ModelPart lockPart;
        private Map<StorageTextureManager.ChestMaterial, Material> chestMaterials;
        private Material tierMaterial;

        public ChestSubRenderer(ChestType chestType, ModelPart lidPart, ModelPart bottomPart, ModelPart lockPart) {
            this.chestType = chestType;
            this.lidPart = lidPart;
            this.bottomPart = bottomPart;
            this.lockPart = lockPart;
        }

        private boolean setChestMaterialsFrom(WoodType woodType, Block block) {
            this.chestMaterials = StorageTextureManager.INSTANCE.getWoodChestMaterials(this.chestType, woodType);
            if (this.chestMaterials == null) {
                return false;
            }
            this.tierMaterial = this.getTierMaterial(block);
            return true;
        }

        private void renderHiddenTier(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
            TextureAtlasSprite sprite = this.tierMaterial.m_119204_();
            VertexConsumer translucentConsumer = sprite.m_118381_(bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)sprite.m_247685_())));
            poseStack.m_85836_();
            poseStack.m_85837_(-0.005, -0.005, -0.005);
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            this.lidPart.m_104306_(poseStack, translucentConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.5f);
            this.bottomPart.m_104306_(poseStack, translucentConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.5f);
            poseStack.m_85849_();
        }

        private void renderBottomAndLid(PoseStack poseStack, MultiBufferSource bufferSource, float lidAngle, int packedLight, int packedOverlay, StorageTextureManager.ChestMaterial chestMaterial) {
            VertexConsumer consumer = this.chestMaterials.get((Object)chestMaterial).m_119194_(bufferSource, RenderType::m_110452_);
            this.renderBottomAndLid(poseStack, lidAngle, packedLight, packedOverlay, consumer);
        }

        private void renderBottomAndLid(PoseStack poseStack, float lidAngle, int packedLight, int packedOverlay, VertexConsumer consumer) {
            this.lidPart.f_104203_ = -(lidAngle * 1.5707964f);
            this.lidPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.bottomPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        }

        private void renderBottomAndLidWithTint(PoseStack poseStack, MultiBufferSource bufferSource, float lidAngle, int packedLight, int packedOverlay, int tint, StorageTextureManager.ChestMaterial chestMaterial) {
            float tintRed = (float)(tint >> 16 & 0xFF) / 255.0f;
            float tingGreen = (float)(tint >> 8 & 0xFF) / 255.0f;
            float tintBlue = (float)(tint & 0xFF) / 255.0f;
            VertexConsumer consumer = this.chestMaterials.get((Object)chestMaterial).m_119194_(bufferSource, RenderType::m_110452_);
            this.lidPart.f_104203_ = -(lidAngle * 1.5707964f);
            this.lidPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
            this.bottomPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
        }

        private void renderChestLock(PoseStack poseStack, MultiBufferSource bufferSource, float lidAngle, int packedLight, int packedOverlay) {
            VertexConsumer consumer = this.tierMaterial.m_119194_(bufferSource, RenderType::m_110452_);
            this.lockPart.f_104203_ = -(lidAngle * 1.5707964f);
            this.lockPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        }

        private Material getTierMaterial(Block block) {
            if (block == ModBlocks.COPPER_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.COPPER_TIER);
            }
            if (block == ModBlocks.IRON_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.IRON_TIER);
            }
            if (block == ModBlocks.GOLD_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.GOLD_TIER);
            }
            if (block == ModBlocks.DIAMOND_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.DIAMOND_TIER);
            }
            if (block == ModBlocks.NETHERITE_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.NETHERITE_TIER);
            }
            return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.WOOD_TIER);
        }

        public void renderTier(PoseStack poseStack, MultiBufferSource bufferSource, float lidAngle, int packedLight, int packedOverlay) {
            VertexConsumer vertexconsumer = this.tierMaterial.m_119194_(bufferSource, RenderType::m_110452_);
            this.renderBottomAndLid(poseStack, lidAngle, packedLight, packedOverlay, vertexconsumer);
        }
    }
}

