/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.util.DecorationHelper;

public class DecorationTableBlockEntity
extends BlockEntity {
    public static final int TOP_INNER_TRIM_SLOT = 0;
    public static final int TOP_TRIM_SLOT = 1;
    public static final int SIDE_TRIM_SLOT = 2;
    public static final int BOTTOM_TRIM_SLOT = 3;
    public static final int TOP_CORE_SLOT = 4;
    public static final int SIDE_CORE_SLOT = 5;
    public static final int BOTTOM_CORE_SLOT = 6;
    public static final int RED_DYE_SLOT = 0;
    public static final int GREEN_DYE_SLOT = 1;
    public static final int BLUE_DYE_SLOT = 2;
    public static final Set<Item> STORAGES_WIHOUT_TOP_INNER_TRIM = Set.of((Item)ModBlocks.BARREL_ITEM.get(), (Item)ModBlocks.COPPER_BARREL_ITEM.get(), (Item)ModBlocks.IRON_BARREL_ITEM.get(), (Item)ModBlocks.GOLD_BARREL_ITEM.get(), (Item)ModBlocks.DIAMOND_BARREL_ITEM.get(), (Item)ModBlocks.NETHERITE_BARREL_ITEM.get(), (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get());
    private final Map<ResourceLocation, Integer> remainingParts = new HashMap<ResourceLocation, Integer>();
    private final ItemStackHandler decorativeBlocks = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem)) return false;
            BlockItem blockItem = (BlockItem)item;
            if (stack.m_41720_() instanceof StorageBlockItem) return false;
            if (!Block.m_49916_((VoxelShape)blockItem.m_40614_().m_49966_().m_60808_((BlockGetter)DecorationTableBlockEntity.this.f_58857_, BlockPos.f_121853_))) return false;
            return true;
        }
    };
    private final ItemStackHandler dyes = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_204117_(Tags.Items.DYES_RED);
                case 1 -> stack.m_204117_(Tags.Items.DYES_GREEN);
                case 2 -> stack.m_204117_(Tags.Items.DYES_BLUE);
                default -> false;
            };
        }
    };
    private ItemStack result = ItemStack.f_41583_;
    private final Map<Integer, Boolean> slotMaterialInheritance = new HashMap<Integer, Boolean>();
    private int accentColor = -1;
    private int mainColor = -1;
    private final Set<ResourceLocation> missingDyes = new HashSet<ResourceLocation>();
    private final ItemStackHandler storageBlock = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DecorationTableBlockEntity.this.updateResultAndSetChanged();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof StorageBlockItem || stack.m_41720_() instanceof PaintbrushItem;
        }
    };

    public void updateResultAndSetChanged() {
        this.updateResult();
        this.m_6596_();
    }

    private void updateResult() {
        this.missingDyes.clear();
        this.result = ItemStack.f_41583_;
        ItemStack storage = this.storageBlock.getStackInSlot(0);
        if (storage.m_41619_()) {
            return;
        }
        if (storage.m_41720_() instanceof PaintbrushItem) {
            this.updatePaintbrushResult(storage);
            return;
        }
        DecorationResult decorationResult = this.decorateStack(storage);
        this.result = decorationResult.result();
        this.missingDyes.addAll(decorationResult.missingDyes());
    }

    public boolean hasMaterials() {
        return !InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks);
    }

    public DecorationResult decorateStack(ItemStack storage) {
        if (!(!InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks) && storage.m_41720_() instanceof BarrelBlockItem && !this.isTintedStorage(storage) || !this.colorsTransparentOrSameAs(storage) && BarrelBlockItem.getMaterials(storage).isEmpty())) {
            return DecorationResult.EMPTY;
        }
        if (!(storage.m_41720_() instanceof BarrelBlockItem) || InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks) || this.isTintedStorage(storage)) {
            BlockItem blockItem;
            ItemStack result = storage.m_41777_();
            result.m_41764_(1);
            Item item = result.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item) instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)blockItem;
                if (this.mainColor != -1) {
                    tintableBlockItem.setMainColor(result, this.mainColor & 0xFFFFFF);
                }
                if (this.accentColor != -1) {
                    tintableBlockItem.setAccentColor(result, this.accentColor & 0xFFFFFF);
                }
            }
            Set<ResourceLocation> missingDyes = this.calculateMissingDyes(storage);
            return new DecorationResult(result, missingDyes);
        }
        if (InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks)) {
            return DecorationResult.EMPTY;
        }
        EnumMap<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(storage));
        BarrelBlockItem.uncompactMaterials(materials);
        this.setMaterialsFromDecorativeBlocks(materials, !STORAGES_WIHOUT_TOP_INNER_TRIM.contains(storage.m_41720_()));
        BarrelBlockItem.compactMaterials(materials);
        if (this.allMaterialsMatch(materials, BarrelBlockItem.getMaterials(storage))) {
            return DecorationResult.EMPTY;
        }
        ItemStack result = storage.m_41777_();
        result.m_41764_(1);
        BarrelBlockItem.removeCoveredTints(result, materials);
        BarrelBlockItem.setMaterials(result, materials);
        return new DecorationResult(result, Collections.emptySet());
    }

    private void updatePaintbrushResult(ItemStack paintbrush) {
        if (!InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks)) {
            EnumMap<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
            this.setMaterialsFromDecorativeBlocks(materials, true);
            BarrelBlockItem.compactMaterials(materials);
            if (this.allMaterialsMatch(materials, BarrelBlockItem.getMaterials(paintbrush))) {
                return;
            }
            this.result = paintbrush.m_41777_();
            this.result.m_41764_(1);
            PaintbrushItem.setBarrelMaterials(this.result, materials);
        } else {
            if (this.mainColor == -1 && this.accentColor == -1 || this.mainColor == PaintbrushItem.getMainColor(paintbrush) && this.accentColor == PaintbrushItem.getAccentColor(paintbrush)) {
                return;
            }
            this.result = paintbrush.m_41777_();
            this.result.m_41764_(1);
            if (this.mainColor != -1) {
                PaintbrushItem.setMainColor(this.result, this.mainColor);
            }
            if (this.accentColor != -1) {
                PaintbrushItem.setAccentColor(this.result, this.accentColor);
            }
        }
    }

    private boolean isTintedStorage(ItemStack storage) {
        return StorageBlockItem.getMainColorFromStack(storage).isPresent() || StorageBlockItem.getAccentColorFromStack(storage).isPresent();
    }

    private boolean allMaterialsMatch(Map<BarrelMaterial, ResourceLocation> newMaterials, Map<BarrelMaterial, ResourceLocation> currentMaterials) {
        if (newMaterials.size() != currentMaterials.size()) {
            return false;
        }
        for (Map.Entry<BarrelMaterial, ResourceLocation> entry : newMaterials.entrySet()) {
            if (entry.getValue().equals((Object)currentMaterials.get((Object)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private Set<ResourceLocation> calculateMissingDyes(ItemStack storage) {
        HashSet<ResourceLocation> missingDyes = new HashSet<ResourceLocation>();
        if (!(this.dyes.getStackInSlot(0).m_41619_() || this.dyes.getStackInSlot(1).m_41619_() || this.dyes.getStackInSlot(2).m_41619_())) {
            return missingDyes;
        }
        Map<ResourceLocation, Integer> partsNeeded = DecorationHelper.getDyePartsNeeded(this.mainColor, this.accentColor, StorageBlockItem.getMainColorFromStack(storage).orElse(-1), StorageBlockItem.getAccentColorFromStack(storage).orElse(-1)).entrySet().stream().map(entry -> Map.entry(((TagKey)entry.getKey()).f_203868_(), (Integer)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<ResourceLocation, Integer> entry2 : partsNeeded.entrySet()) {
            if (entry2.getKey().equals((Object)Tags.Items.DYES_RED.f_203868_()) && this.dyes.getStackInSlot(0).m_41619_()) {
                missingDyes.add(entry2.getKey());
                continue;
            }
            if (entry2.getKey().equals((Object)Tags.Items.DYES_GREEN.f_203868_()) && this.dyes.getStackInSlot(1).m_41619_()) {
                missingDyes.add(entry2.getKey());
                continue;
            }
            if (!entry2.getKey().equals((Object)Tags.Items.DYES_BLUE.f_203868_()) || !this.dyes.getStackInSlot(2).m_41619_()) continue;
            missingDyes.add(entry2.getKey());
        }
        return missingDyes;
    }

    public Set<ResourceLocation> getMissingDyes() {
        return this.missingDyes;
    }

    private boolean colorsTransparentOrSameAs(ItemStack storage) {
        return !(this.mainColor != -1 && this.mainColor != StorageBlockItem.getMainColorFromStack(storage).orElse(-1) || this.accentColor != -1 && this.accentColor != StorageBlockItem.getAccentColorFromStack(storage).orElse(-1));
    }

    private void setMaterialsFromDecorativeBlocks(Map<BarrelMaterial, ResourceLocation> materials, boolean supportsInnerTrim) {
        ResourceLocation topInnerTrimMaterialLocation = this.setMaterialFromBlock(0, null, materials, BarrelMaterial.TOP_INNER_TRIM, supportsInnerTrim);
        ResourceLocation topTrimMaterialLocation = this.setMaterialFromBlock(1, topInnerTrimMaterialLocation, materials, BarrelMaterial.TOP_TRIM, true);
        ResourceLocation sideTrimMaterialLocation = this.setMaterialFromBlock(2, topTrimMaterialLocation, materials, BarrelMaterial.SIDE_TRIM, true);
        this.setMaterialFromBlock(3, sideTrimMaterialLocation, materials, BarrelMaterial.BOTTOM_TRIM, true);
        ResourceLocation topMaterialLocation = this.setMaterialFromBlock(4, topTrimMaterialLocation, materials, BarrelMaterial.TOP, true);
        ResourceLocation sideMaterialLocation = this.setMaterialFromBlock(5, topMaterialLocation, materials, BarrelMaterial.SIDE, true);
        this.setMaterialFromBlock(6, sideMaterialLocation, materials, BarrelMaterial.BOTTOM, true);
    }

    @Nullable
    private ResourceLocation setMaterialFromBlock(int slotIndex, @Nullable ResourceLocation defaultMaterialLocation, Map<BarrelMaterial, ResourceLocation> materials, BarrelMaterial material, boolean addToMaterials) {
        ItemStack decorativeBlock = this.decorativeBlocks.getStackInSlot(slotIndex);
        ResourceLocation materialLocation = DecorationHelper.getMaterialLocation(decorativeBlock).orElse((ResourceLocation)(this.isSlotMaterialInherited(slotIndex) ? defaultMaterialLocation : null));
        if (materialLocation != null) {
            if (addToMaterials) {
                materials.put(material, materialLocation);
            }
            return materialLocation;
        }
        return null;
    }

    public DecorationTableBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.DECORATION_TABLE_BLOCK_ENTITY_TYPE.get(), pos, blockState);
    }

    public ItemStackHandler getDecorativeBlocks() {
        return this.decorativeBlocks;
    }

    public ItemStackHandler getDyes() {
        return this.dyes;
    }

    public ItemStackHandler getStorageBlock() {
        return this.storageBlock;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack extractResult(int count) {
        ItemStack result = this.getResult();
        if (result.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack extracted = result.m_41777_();
        extracted.m_41764_(count);
        if (count >= result.m_41613_()) {
            this.result = ItemStack.f_41583_;
        } else {
            result.m_41774_(count);
        }
        this.m_6596_();
        return extracted;
    }

    public boolean isSlotMaterialInherited(int slot) {
        return this.slotMaterialInheritance.getOrDefault(slot, true);
    }

    public ItemStack getInheritedItem(int childSlot) {
        while (this.isSlotMaterialInherited(childSlot)) {
            int parentSlot = this.getSlotInheritedFrom(childSlot);
            if (parentSlot == -1) {
                return ItemStack.f_41583_;
            }
            if (!this.decorativeBlocks.getStackInSlot(parentSlot).m_41619_()) {
                return this.decorativeBlocks.getStackInSlot(parentSlot);
            }
            childSlot = parentSlot;
        }
        return ItemStack.f_41583_;
    }

    public int getSlotInheritedFrom(int slot) {
        return switch (slot) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            case 4 -> 1;
            case 5 -> 4;
            case 6 -> 5;
            default -> -1;
        };
    }

    public void setSlotMaterialInheritance(int slot, boolean value) {
        if (value) {
            this.slotMaterialInheritance.remove(slot);
        } else {
            this.slotMaterialInheritance.put(slot, false);
        }
        this.updateResultAndSetChanged();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveData(tag);
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.decorativeBlocks.deserializeNBT(tag.m_128469_("decorativeBlocks"));
        this.dyes.deserializeNBT(tag.m_128469_("dyes"));
        this.storageBlock.deserializeNBT(tag.m_128469_("storageBlock"));
        this.result = tag.m_128441_("result") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")) : ItemStack.f_41583_;
        this.slotMaterialInheritance.clear();
        ListTag inheritance = tag.m_128437_("slotMaterialInheritance", 10);
        for (int i = 0; i < inheritance.size(); ++i) {
            CompoundTag slotTag = inheritance.m_128728_(i);
            this.slotMaterialInheritance.put(slotTag.m_128451_("slot"), slotTag.m_128471_("value"));
        }
        this.remainingParts.clear();
        ListTag remainingPartsTag = tag.m_128437_("remainingParts", 10);
        for (int i = 0; i < remainingPartsTag.size(); ++i) {
            CompoundTag partTag = remainingPartsTag.m_128728_(i);
            ResourceLocation key = ResourceLocation.m_135820_((String)partTag.m_128461_("key"));
            if (key == null) continue;
            this.remainingParts.put(key, partTag.m_128451_("value"));
        }
        this.mainColor = tag.m_128451_("mainColor");
        this.accentColor = tag.m_128451_("accentColor");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveData(tag);
    }

    private void saveData(CompoundTag tag) {
        tag.m_128365_("decorativeBlocks", (Tag)this.decorativeBlocks.serializeNBT());
        tag.m_128365_("dyes", (Tag)this.dyes.serializeNBT());
        tag.m_128365_("storageBlock", (Tag)this.storageBlock.serializeNBT());
        if (!this.result.m_41619_()) {
            tag.m_128365_("result", (Tag)this.result.m_41739_(new CompoundTag()));
        }
        ListTag inheritance = new ListTag();
        this.slotMaterialInheritance.forEach((slot, value) -> {
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128405_("slot", slot.intValue());
            slotTag.m_128379_("value", value.booleanValue());
            inheritance.add((Object)slotTag);
        });
        tag.m_128365_("slotMaterialInheritance", (Tag)inheritance);
        ListTag remainingPartsTag = new ListTag();
        this.remainingParts.forEach((key, value) -> {
            CompoundTag partTag = new CompoundTag();
            partTag.m_128359_("key", key.toString());
            partTag.m_128405_("value", value.intValue());
            remainingPartsTag.add((Object)partTag);
        });
        tag.m_128365_("remainingParts", (Tag)remainingPartsTag);
        tag.m_128405_("mainColor", this.mainColor);
        tag.m_128405_("accentColor", this.accentColor);
    }

    public void consumeIngredientsOnCraft() {
        if (this.getStorageBlock().getStackInSlot(0).m_41720_() instanceof PaintbrushItem) {
            return;
        }
        ItemStack storageStack = this.storageBlock.getStackInSlot(0);
        if (InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks)) {
            DecorationHelper.consumeDyes(this.mainColor, this.accentColor, this.remainingParts, List.of(this.dyes), StorageBlockItem.getMainColorFromStack(storageStack).orElse(-1), StorageBlockItem.getAccentColorFromStack(storageStack).orElse(-1), false);
        } else {
            Map<BarrelMaterial, ResourceLocation> originalMaterials = BarrelBlockItem.getUncompactedMaterials(storageStack);
            DecorationHelper.consumeMaterials(this.remainingParts, List.of(this.decorativeBlocks), originalMaterials, this.getMaterialsToApply(storageStack), false);
        }
        this.m_6596_();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public Map<ResourceLocation, Integer> getPartsNeeded() {
        HashMap<ResourceLocation, Integer> partsNeeded = new HashMap<ResourceLocation, Integer>();
        ItemStack storageStack = this.storageBlock.getStackInSlot(0);
        if (InventoryHelper.isEmpty((IItemHandler)this.decorativeBlocks) || !(storageStack.m_41720_() instanceof BarrelBlockItem)) {
            DecorationHelper.getDyePartsNeeded(this.mainColor, this.accentColor, StorageBlockItem.getMainColorFromStack(storageStack).orElse(-1), StorageBlockItem.getAccentColorFromStack(storageStack).orElse(-1)).forEach((tag, parts) -> partsNeeded.put(tag.f_203868_(), (Integer)parts));
        } else {
            partsNeeded.putAll(DecorationHelper.getMaterialPartsNeeded(BarrelBlockItem.getUncompactedMaterials(storageStack), this.getMaterialsToApply(storageStack)));
        }
        return partsNeeded;
    }

    private Map<BarrelMaterial, ResourceLocation> getMaterialsToApply(ItemStack storageStack) {
        EnumMap<BarrelMaterial, ResourceLocation> materialsToApply = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
        this.setMaterialsFromDecorativeBlocks(materialsToApply, !STORAGES_WIHOUT_TOP_INNER_TRIM.contains(storageStack.m_41720_()));
        return materialsToApply;
    }

    public int getMainColor() {
        return this.mainColor;
    }

    public void setMainColor(int mainColor) {
        this.mainColor = mainColor;
        this.updateResultAndSetChanged();
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
        this.updateResultAndSetChanged();
    }

    public Map<ResourceLocation, Integer> getPartsStored() {
        return this.remainingParts;
    }

    public void dropContents() {
        InventoryHelper.dropItems((ItemStackHandler)this.decorativeBlocks, (Level)this.f_58857_, (BlockPos)this.f_58858_);
        InventoryHelper.dropItems((ItemStackHandler)this.dyes, (Level)this.f_58857_, (BlockPos)this.f_58858_);
        InventoryHelper.dropItems((ItemStackHandler)this.storageBlock, (Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public record DecorationResult(ItemStack result, Set<ResourceLocation> missingDyes) {
        public static final DecorationResult EMPTY = new DecorationResult(ItemStack.f_41583_, Collections.emptySet());
    }
}

