/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestBlockEntity
extends WoodStorageBlockEntity {
    public static final String STORAGE_TYPE = "chest";
    public static final String DOUBLE_CHEST_MAIN_POS_TAG = "doubleMainPos";
    private final ChestLidController chestLidController = new ChestLidController();
    @javax.annotation.Nullable
    private BlockPos doubleMainPos = null;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            if (state.m_61143_(ChestBlock.TYPE) != ChestType.LEFT) {
                ChestBlockEntity.this.playSound(state, SoundEvents.f_11749_);
            }
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            if (state.m_61143_(ChestBlock.TYPE) != ChestType.LEFT) {
                ChestBlockEntity.this.playSound(state, SoundEvents.f_11747_);
            }
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int previousOpenCount, int openCount) {
            ChestBlockEntity.this.chestLidController.m_155377_(openCount > 0);
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof StorageContainerMenu) {
                StorageContainerMenu storageContainerMenu = (StorageContainerMenu)abstractContainerMenu;
                return storageContainerMenu.getStorageBlockEntity() == ChestBlockEntity.this;
            }
            return false;
        }

        public void m_155452_(Player player, Level level, BlockPos pos, BlockState state) {
            super.m_155452_(player, level, pos, state);
            if (ChestBlockEntity.this.isMainChest()) {
                ChestBlockEntity.runOnTheOtherPart(level, pos, state, (blockEntity, neighborPos) -> blockEntity.openersCounter.m_155452_(player, level, neighborPos, level.m_8055_(neighborPos)));
            }
        }

        public void m_155468_(Player player, Level level, BlockPos pos, BlockState state) {
            super.m_155468_(player, level, pos, state);
            if (ChestBlockEntity.this.isMainChest()) {
                ChestBlockEntity.runOnTheOtherPart(level, pos, state, (blockEntity, neighborPos) -> blockEntity.openersCounter.m_155468_(player, level, neighborPos, level.m_8055_(neighborPos)));
            }
        }
    };
    private boolean isDestroyedByPlayer = false;

    public void joinWithChest(ChestBlockEntity mainBE) {
        this.setMainPos(mainBE.m_58899_());
        this.expandAndMoveItemsAndSettings(mainBE);
        this.removeFromController();
        this.setNotLinked();
        this.tryToAddToController();
    }

    public void setMainPos(BlockPos doubleMainPos) {
        this.doubleMainPos = doubleMainPos;
        this.m_6596_();
    }

    private void expandAndMoveItemsAndSettings(ChestBlockEntity mainBE) {
        int n;
        InventoryHandler mainInventoryHandler = mainBE.getStorageWrapper().getInventoryHandler();
        int originalNumberOfSlots = mainInventoryHandler.getSlots();
        InventoryHandler thisInventoryHandler = this.getStorageWrapper().getInventoryHandler();
        Block block = mainBE.m_58900_().m_60734_();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        int inventorySlotDiff = 2 * n - mainInventoryHandler.getSlots();
        mainBE.changeStorageSize(inventorySlotDiff, 0);
        ChestBlockEntity.moveStacksToMain(thisInventoryHandler, mainInventoryHandler, originalNumberOfSlots);
        this.copySettings(this, mainBE, 0, originalNumberOfSlots);
        this.deleteSettingsFromSlot(this, 0);
        WorldHelper.notifyBlockUpdate((BlockEntity)mainBE);
    }

    private void copySettings(ChestBlockEntity from, ChestBlockEntity to, int startFromSlot, int slotOffset) {
        SettingsHandler mainSettingsHandler = to.getStorageWrapper().getSettingsHandler();
        from.getStorageWrapper().getSettingsHandler().getSettingsCategories().forEach((name, category) -> this.copyCategorySettings((ISettingsCategory)category, (ISettingsCategory<?>)mainSettingsHandler.getTypeCategory(category.getClass()), startFromSlot, slotOffset));
    }

    private void deleteSettingsFromSlot(ChestBlockEntity from, int startFromSlot) {
        from.getStorageWrapper().getSettingsHandler().getSettingsCategories().forEach((name, category) -> category.deleteSlotSettingsFrom(startFromSlot));
    }

    private <T extends ISettingsCategory<?>> void copyCategorySettings(ISettingsCategory<T> category, ISettingsCategory<?> mainCategory, int startFromSlot, int slotOffset) {
        category.copyTo(mainCategory, startFromSlot, slotOffset);
    }

    private static void moveStacksToMain(InventoryHandler thisInventoryHandler, InventoryHandler mainInventoryHandler, int originalNumberOfSlots) {
        int slot;
        int thisSlots = thisInventoryHandler.getSlots();
        int mainSlots = mainInventoryHandler.getSlots();
        for (slot = 0; slot < thisSlots && slot + originalNumberOfSlots < mainSlots; ++slot) {
            ItemStack slotStack = thisInventoryHandler.getStackInSlot(slot);
            if (slotStack.m_41619_()) continue;
            mainInventoryHandler.setStackInSlot(slot + originalNumberOfSlots, slotStack);
        }
        for (slot = 0; slot < thisSlots; ++slot) {
            thisInventoryHandler.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    public void syncTogglesFrom(ChestBlockEntity chestBE) {
        if (chestBE.isLocked() != this.isLocked()) {
            this.toggleJustMyLock();
        }
        if (chestBE.shouldShowLock() != this.shouldShowLock()) {
            this.toggleJustMyLockVisibility();
        }
        if (chestBE.shouldShowTier() != this.shouldShowTier()) {
            this.toggleJustMyTierVisiblity();
        }
        if (chestBE.shouldShowUpgrades() != this.shouldShowUpgrades()) {
            this.toggleJustMyUpgradesVisiblity();
        }
    }

    @Override
    public void dropContents() {
        if (this.isDestroyedByPlayer && this.m_58900_().m_61143_(ChestBlock.TYPE) != ChestType.SINGLE) {
            if (this.doubleMainPos != null) {
                this.moveMyStacksFromMain();
            } else {
                this.moveOtherPartStacksToIt();
            }
        }
        super.dropContents();
    }

    @Override
    public void onNeighborChange(BlockPos neighborPos) {
        Direction direction = this.getNeighborDirection(neighborPos);
        if (direction == null) {
            return;
        }
        this.getMainStorageWrapper().getUpgradeHandler().getWrappersThatImplement(INeighborChangeListenerUpgrade.class).forEach(upgrade -> upgrade.onNeighborChange(this.f_58857_, this.f_58858_, direction));
    }

    private void moveOtherPartStacksToIt() {
        ChestBlockEntity.runOnTheOtherPart(this.f_58857_, this.m_58899_(), this.m_58900_(), (be, pos) -> {
            int firstIndex;
            be.removeDoubleMainPos();
            InventoryHandler mainInventoryHandler = this.getStorageWrapper().getInventoryHandler();
            for (int slot = firstIndex = mainInventoryHandler.getSlots() / 2; slot < mainInventoryHandler.getSlots(); ++slot) {
                ItemStack slotStack = mainInventoryHandler.getStackInSlot(slot);
                be.getStorageWrapper().getInventoryHandler().setSlotStack(slot - firstIndex, slotStack.m_41620_(slotStack.m_41741_()));
            }
            this.copySettings(this, (ChestBlockEntity)be, firstIndex, -firstIndex);
            be.removeControllerPos();
            be.tryToAddToController();
            be.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
            WorldHelper.notifyBlockUpdate((BlockEntity)be);
        });
    }

    private void moveMyStacksFromMain() {
        this.f_58857_.m_141902_(this.doubleMainPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(mainBE -> {
            int n;
            int firstIndex;
            StorageWrapper mainStorageWrapper = mainBE.getStorageWrapper();
            InventoryHandler mainInventoryHandler = mainStorageWrapper.getInventoryHandler();
            for (int slot = firstIndex = mainInventoryHandler.getSlots() / 2; slot < mainInventoryHandler.getSlots(); ++slot) {
                this.getStorageWrapper().getInventoryHandler().setSlotStack(slot - firstIndex, mainInventoryHandler.getStackInSlot(slot));
                mainInventoryHandler.setSlotStack(slot, ItemStack.f_41583_);
            }
            Block patt8926$temp = mainBE.m_58900_().m_60734_();
            if (patt8926$temp instanceof StorageBlockBase) {
                StorageBlockBase storageBlock = (StorageBlockBase)patt8926$temp;
                n = storageBlock.getNumberOfInventorySlots();
            } else {
                n = 0;
            }
            int inventorySlotDiff = n - mainInventoryHandler.getSlots();
            mainBE.changeStorageSize(inventorySlotDiff, 0);
            this.deleteSettingsFromSlot((ChestBlockEntity)mainBE, firstIndex);
            ((ItemDisplaySettingsCategory)mainStorageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).setDisplaySide(DisplaySide.FRONT);
            mainStorageWrapper.getUpgradeHandler().refreshUpgradeWrappers();
            WorldHelper.notifyBlockUpdate((BlockEntity)mainBE);
        });
    }

    public boolean hasStorageData() {
        return this.isMainChest();
    }

    @Override
    protected ContainerOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    public ChestBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, (BlockEntityType<? extends StorageBlockEntity>)((BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()));
    }

    public static void lidAnimateTick(ChestBlockEntity chestBlockEntity) {
        chestBlockEntity.chestLidController.m_155374_();
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    @Override
    public void toggleLock() {
        super.toggleLock();
        if (this.f_58857_ != null) {
            ChestBlockEntity.runOnTheOtherPart(this.f_58857_, this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), (be, pos) -> be.toggleJustMyLock());
        }
    }

    private void toggleJustMyLock() {
        super.toggleLock();
    }

    @Override
    public void toggleLockVisibility() {
        super.toggleLockVisibility();
        if (this.f_58857_ != null) {
            ChestBlockEntity.runOnTheOtherPart(this.f_58857_, this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), (be, pos) -> be.toggleJustMyLockVisibility());
        }
    }

    private void toggleJustMyLockVisibility() {
        super.toggleLockVisibility();
    }

    @Override
    public void toggleTierVisiblity() {
        super.toggleTierVisiblity();
        if (this.f_58857_ != null) {
            ChestBlockEntity.runOnTheOtherPart(this.f_58857_, this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), (be, pos) -> be.toggleJustMyTierVisiblity());
        }
    }

    private void toggleJustMyTierVisiblity() {
        super.toggleTierVisiblity();
    }

    @Override
    public void toggleUpgradesVisiblity() {
        super.toggleUpgradesVisiblity();
        if (this.f_58857_ != null) {
            ChestBlockEntity.runOnTheOtherPart(this.f_58857_, this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), (be, pos) -> be.toggleJustMyUpgradesVisiblity());
        }
    }

    private void toggleJustMyUpgradesVisiblity() {
        super.toggleUpgradesVisiblity();
    }

    private static void runOnTheOtherPart(Level level, BlockPos pos, BlockState state, BiConsumer<ChestBlockEntity, BlockPos> execute) {
        ChestType chestType = (ChestType)state.m_61143_(ChestBlock.TYPE);
        if (chestType == ChestType.SINGLE) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)ChestBlock.FACING);
        BlockPos neighborPos = chestType == ChestType.RIGHT ? pos.m_121945_(facing.m_122428_()) : pos.m_121945_(facing.m_122427_());
        level.m_141902_(neighborPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(chestBlockEntity -> execute.accept((ChestBlockEntity)chestBlockEntity, neighborPos));
    }

    public void removeDoubleMainPos() {
        this.doubleMainPos = null;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        if (this.doubleMainPos != null) {
            return this.f_58857_.m_141902_(this.doubleMainPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(be -> be.getCapability(cap, side)).orElseGet(LazyOptional::empty);
        }
        return super.getCapability(cap, side);
    }

    public boolean isMainChest() {
        return this.doubleMainPos == null;
    }

    @Override
    public void loadSynchronizedData(CompoundTag tag) {
        super.loadSynchronizedData(tag);
        this.doubleMainPos = NBTHelper.getLong((CompoundTag)tag, (String)DOUBLE_CHEST_MAIN_POS_TAG).map(BlockPos::m_122022_).orElse(null);
    }

    @Override
    protected void saveSynchronizedData(CompoundTag tag) {
        super.saveSynchronizedData(tag);
        if (this.doubleMainPos != null) {
            tag.m_128356_(DOUBLE_CHEST_MAIN_POS_TAG, this.doubleMainPos.m_121878_());
        }
    }

    @Override
    public CompoundTag getStorageContentsTag() {
        CompoundTag tag = super.getStorageContentsTag();
        tag.m_128473_(DOUBLE_CHEST_MAIN_POS_TAG);
        return tag;
    }

    @Override
    protected ItemStack addWrappedStorageStackData(ItemStack cloneItemStack, BlockState state) {
        ItemStack ret = super.addWrappedStorageStackData(cloneItemStack, state);
        if (state.m_61143_(ChestBlock.TYPE) != ChestType.SINGLE) {
            ChestBlockItem.setDoubleChest(ret, true);
        }
        return ret;
    }

    public StorageWrapper getMainStorageWrapper() {
        if (this.doubleMainPos != null) {
            return this.f_58857_.m_141902_(this.doubleMainPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(StorageBlockEntity::getStorageWrapper).orElseGet(this::getStorageWrapper);
        }
        return this.getStorageWrapper();
    }

    @javax.annotation.Nullable
    public ChestBlockEntity getMainChestBlockEntity() {
        if (this.doubleMainPos != null) {
            return this.f_58857_.m_141902_(this.doubleMainPos, (BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).orElse(null);
        }
        return this;
    }

    @Override
    public boolean canBeLinked() {
        return this.isMainChest() && super.canBeLinked();
    }

    public void dropSecondPartContents(ChestBlock chestBlock, BlockPos dropPosition) {
        InventoryHandler invHandler = this.getStorageWrapper().getInventoryHandler();
        ArrayList<ItemStack> dropItems = new ArrayList<ItemStack>();
        for (int slot = chestBlock.getNumberOfInventorySlots(); slot < invHandler.getSlots(); ++slot) {
            ItemStack slotStack = invHandler.getStackInSlot(slot);
            if (slotStack.m_41619_()) continue;
            dropItems.add(slotStack.m_41777_());
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_(), () -> dropItems.forEach(itemStack -> Containers.m_18992_((Level)serverLevel, (double)dropPosition.m_123341_(), (double)dropPosition.m_123342_(), (double)dropPosition.m_123343_(), (ItemStack)itemStack))));
        }
        int inventorySlotDiff = chestBlock.getNumberOfInventorySlots() - invHandler.getSlots();
        this.changeStorageSize(inventorySlotDiff, 0);
        this.deleteSettingsFromSlot(this, chestBlock.getNumberOfInventorySlots());
        ((ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).setDisplaySide(DisplaySide.FRONT);
        this.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public void setDestroyedByPlayer() {
        this.isDestroyedByPlayer = true;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (!this.isBeingUpgraded() && this.m_58900_().m_61143_(ChestBlock.TYPE) == ChestType.SINGLE) {
            Block block = this.m_58900_().m_60734_();
            if (block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                if (this.getStorageWrapper().getInventoryHandler().getSlots() > chestBlock.getNumberOfInventorySlots()) {
                    this.dropSecondPartContents(chestBlock, this.f_58858_);
                }
            }
            if (!this.isMainChest()) {
                this.removeDoubleMainPos();
            }
        }
    }

    public void changeSlots(int newSlots) {
        if (this.hasStorageData()) {
            super.changeSlots(newSlots);
        }
    }
}

