/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
        this.subProviders = providers;
    }

    public String m_6055_() {
        return "Utilitarian Block Loot Table datagen";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.f_243941_().get()).m_245126_((resourceLocation, builder) -> {
            builder.m_287223_(resourceLocation);
            if (map.put(resourceLocation, builder.m_79165_(providerEntry.f_244144_()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree(entry.getValue()), (Path)this.pathProvider.m_245731_((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();

        public LootProvider() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            for (DyeColor color : DyeColor.values()) {
                this.m_245724_((Block)NoSolicitingModule.SOLICITING_CARPET.get(color).get());
                this.m_245724_((Block)NoSolicitingModule.TRAPPED_SOLICITING_CARPET.get(color).get());
            }
            this.m_245724_((Block)NoSolicitingModule.NO_SOLICITING_BANNER.get());
            this.dropOther((Block)NoSolicitingModule.NO_SOLICITING_WALL_BANNER.get(), (Block)NoSolicitingModule.NO_SOLICITING_BANNER.get());
            this.m_245724_((Block)UtilityBlockModule.FLUID_HOPPER_BLOCK.get());
            this.m_245724_((Block)UtilityBlockModule.REDSTONE_CLOCK_BLOCK.get());
        }

        protected void m_247577_(Block block, LootTable.Builder builder) {
            super.m_247577_(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void m_246481_(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.m_247577_(block, builderFunction.apply(block));
        }

        public void m_245724_(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genOptionalBlockDrop);
            this.m_247577_(block, func.apply(block));
        }

        public void dropOther(@NotNull Block block, @NotNull Block otherBlock) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genOptionalBlockDrop);
            this.m_247577_(block, func.apply(otherBlock));
        }

        public void dropNothing(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genBlankBlockDrop);
            this.m_247577_(block, func.apply(block));
        }

        protected static LootTable.Builder genOptionalBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = LootItem.m_79579_((ItemLike)block).m_79080_(ExplosionCondition.m_81661_());
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(builder));
        }

        protected static LootTable.Builder genBlankBlockDrop(Block block) {
            return LootTable.m_79147_();
        }
    }
}

