/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.data;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.book.conditions.BookAdvancementCondition;
import com.klikli_dev.modonomicon.book.conditions.BookAndCondition;
import com.klikli_dev.modonomicon.book.conditions.BookCategoryHasVisibleEntriesCondition;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryReadCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryUnlockedCondition;
import com.klikli_dev.modonomicon.book.conditions.BookFalseCondition;
import com.klikli_dev.modonomicon.book.conditions.BookModLoadedCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.conditions.BookOrCondition;
import com.klikli_dev.modonomicon.book.conditions.BookTrueCondition;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.entries.CategoryLinkBookEntry;
import com.klikli_dev.modonomicon.book.entries.ContentBookEntry;
import com.klikli_dev.modonomicon.book.page.BookBlastingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookCampfireCookingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookCraftingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookEmptyPage;
import com.klikli_dev.modonomicon.book.page.BookEntityPage;
import com.klikli_dev.modonomicon.book.page.BookImagePage;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.book.page.BookSmeltingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmithingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmokingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSpotlightPage;
import com.klikli_dev.modonomicon.book.page.BookStonecuttingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.data.BookEntryJsonLoader;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.NetworkLoader;
import com.klikli_dev.modonomicon.multiblock.DenseMultiblock;
import com.klikli_dev.modonomicon.multiblock.SparseMultiblock;
import com.klikli_dev.modonomicon.multiblock.matcher.AnyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.BlockMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.BlockStateMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.BlockStatePropertyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.klikli_dev.modonomicon.multiblock.matcher.PredicateMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.TagMatcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class LoaderRegistry {
    private static final Map<ResourceLocation, BookEntryJsonLoader<? extends BookEntry>> entryTypeJsonLoaders = new ConcurrentHashMap<ResourceLocation, BookEntryJsonLoader<? extends BookEntry>>();
    private static final Map<ResourceLocation, NetworkLoader<? extends BookEntry>> entryTypeNetworkLoaders = new ConcurrentHashMap<ResourceLocation, NetworkLoader<? extends BookEntry>>();
    private static final Map<ResourceLocation, JsonLoader<? extends BookPage>> pageJsonLoaders = new ConcurrentHashMap<ResourceLocation, JsonLoader<? extends BookPage>>();
    private static final Map<ResourceLocation, NetworkLoader<? extends BookPage>> pageNetworkLoaders = new ConcurrentHashMap<ResourceLocation, NetworkLoader<? extends BookPage>>();
    private static final Map<ResourceLocation, JsonLoader<? extends BookCondition>> conditionJsonLoaders = new ConcurrentHashMap<ResourceLocation, JsonLoader<? extends BookCondition>>();
    private static final Map<ResourceLocation, NetworkLoader<? extends BookCondition>> conditionNetworkLoaders = new ConcurrentHashMap<ResourceLocation, NetworkLoader<? extends BookCondition>>();
    private static final Map<ResourceLocation, JsonLoader<? extends Multiblock>> multiblockJsonLoaders = new ConcurrentHashMap<ResourceLocation, JsonLoader<? extends Multiblock>>();
    private static final Map<ResourceLocation, NetworkLoader<? extends Multiblock>> multiblockNetworkLoaders = new ConcurrentHashMap<ResourceLocation, NetworkLoader<? extends Multiblock>>();
    private static final Map<ResourceLocation, JsonLoader<? extends StateMatcher>> stateMatcherJsonLoaders = new ConcurrentHashMap<ResourceLocation, JsonLoader<? extends StateMatcher>>();
    private static final Map<ResourceLocation, NetworkLoader<? extends StateMatcher>> stateMatcherNetworkLoaders = new ConcurrentHashMap<ResourceLocation, NetworkLoader<? extends StateMatcher>>();
    private static final Map<ResourceLocation, TriPredicate<BlockGetter, BlockPos, BlockState>> predicates = new ConcurrentHashMap<ResourceLocation, TriPredicate<BlockGetter, BlockPos, BlockState>>();

    public static void registerLoaders() {
        LoaderRegistry.registerDefaultBookEntryTypes();
        LoaderRegistry.registerDefaultPageLoaders();
        LoaderRegistry.registerDefaultConditionLoaders();
        LoaderRegistry.registerDefaultPredicates();
        LoaderRegistry.registerDefaultStateMatcherLoaders();
        LoaderRegistry.registerDefaultMultiblockLoaders();
    }

    private static void registerDefaultBookEntryTypes() {
        LoaderRegistry.registerEntryType(ModonomiconConstants.Data.EntryType.CONTENT, ContentBookEntry::fromJson, ContentBookEntry::fromNetwork);
        LoaderRegistry.registerEntryType(ModonomiconConstants.Data.EntryType.CATEGORY_LINK, CategoryLinkBookEntry::fromJson, CategoryLinkBookEntry::fromNetwork);
    }

    private static void registerDefaultPageLoaders() {
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.TEXT, BookTextPage::fromJson, BookTextPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.MULTIBLOCK, BookMultiblockPage::fromJson, BookMultiblockPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.CRAFTING_RECIPE, BookCraftingRecipePage::fromJson, BookCraftingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.SMELTING_RECIPE, BookSmeltingRecipePage::fromJson, BookSmeltingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.SMOKING_RECIPE, BookSmokingRecipePage::fromJson, BookSmokingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.CAMPFIRE_COOKING_RECIPE, BookCampfireCookingRecipePage::fromJson, BookCampfireCookingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.BLASTING_RECIPE, BookBlastingRecipePage::fromJson, BookBlastingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.STONECUTTING_RECIPE, BookStonecuttingRecipePage::fromJson, BookStonecuttingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.SMITHING_RECIPE, BookSmithingRecipePage::fromJson, BookSmithingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.SPOTLIGHT, BookSpotlightPage::fromJson, BookSpotlightPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.EMPTY, BookEmptyPage::fromJson, BookEmptyPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.ENTITY, BookEntityPage::fromJson, BookEntityPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.IMAGE, BookImagePage::fromJson, BookImagePage::fromNetwork);
    }

    private static void registerDefaultConditionLoaders() {
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.NONE, BookNoneCondition::fromJson, BookNoneCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.ADVANCEMENT, BookAdvancementCondition::fromJson, BookAdvancementCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.ENTRY_UNLOCKED, BookEntryUnlockedCondition::fromJson, BookEntryUnlockedCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.ENTRY_READ, BookEntryReadCondition::fromJson, BookEntryReadCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.OR, BookOrCondition::fromJson, BookOrCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.AND, BookAndCondition::fromJson, BookAndCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.TRUE, BookTrueCondition::fromJson, BookTrueCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.FALSE, BookFalseCondition::fromJson, BookFalseCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.MOD_LOADED, BookModLoadedCondition::fromJson, BookModLoadedCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.CATEGORY_HAS_VISIBLE_ENTRIES, BookCategoryHasVisibleEntriesCondition::fromJson, BookCategoryHasVisibleEntriesCondition::fromNetwork);
    }

    private static void registerDefaultMultiblockLoaders() {
        LoaderRegistry.registerMultiblockLoader(DenseMultiblock.TYPE, DenseMultiblock::fromJson, DenseMultiblock::fromNetwork);
        LoaderRegistry.registerMultiblockLoader(SparseMultiblock.TYPE, SparseMultiblock::fromJson, SparseMultiblock::fromNetwork);
    }

    private static void registerDefaultStateMatcherLoaders() {
        LoaderRegistry.registerStateMatcherLoader(AnyMatcher.TYPE, AnyMatcher::fromJson, AnyMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(BlockMatcher.TYPE, BlockMatcher::fromJson, BlockMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(BlockStateMatcher.TYPE, BlockStateMatcher::fromJson, BlockStateMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(BlockStatePropertyMatcher.TYPE, BlockStatePropertyMatcher::fromJson, BlockStatePropertyMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(DisplayOnlyMatcher.TYPE, DisplayOnlyMatcher::fromJson, DisplayOnlyMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(PredicateMatcher.TYPE, PredicateMatcher::fromJson, PredicateMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(TagMatcher.TYPE, TagMatcher::fromJson, TagMatcher::fromNetwork);
    }

    private static void registerDefaultPredicates() {
        LoaderRegistry.registerPredicate(Matchers.AIR.getPredicateId(), (getter, pos, state) -> state.m_60795_());
        LoaderRegistry.registerPredicate(Modonomicon.loc("non_solid"), (getter, pos, state) -> !state.m_280296_());
    }

    public static void registerEntryType(ResourceLocation id, BookEntryJsonLoader<? extends BookEntry> jsonLoader, NetworkLoader<? extends BookEntry> networkLoader) {
        entryTypeJsonLoaders.put(id, jsonLoader);
        entryTypeNetworkLoaders.put(id, networkLoader);
    }

    public static void registerPageLoader(ResourceLocation id, JsonLoader<? extends BookPage> jsonLoader, NetworkLoader<? extends BookPage> networkLoader) {
        pageJsonLoaders.put(id, jsonLoader);
        pageNetworkLoaders.put(id, networkLoader);
    }

    public static void registerConditionLoader(ResourceLocation id, JsonLoader<? extends BookCondition> jsonLoader, NetworkLoader<? extends BookCondition> networkLoader) {
        conditionJsonLoaders.put(id, jsonLoader);
        conditionNetworkLoaders.put(id, networkLoader);
    }

    public static void registerMultiblockLoader(ResourceLocation id, JsonLoader<? extends Multiblock> jsonLoader, NetworkLoader<? extends Multiblock> networkLoader) {
        multiblockJsonLoaders.put(id, jsonLoader);
        multiblockNetworkLoaders.put(id, networkLoader);
    }

    public static void registerStateMatcherLoader(ResourceLocation id, JsonLoader<? extends StateMatcher> jsonLoader, NetworkLoader<? extends StateMatcher> networkLoader) {
        stateMatcherJsonLoaders.put(id, jsonLoader);
        stateMatcherNetworkLoaders.put(id, networkLoader);
    }

    public static void registerPredicate(ResourceLocation id, TriPredicate<BlockGetter, BlockPos, BlockState> predicate) {
        predicates.put(id, predicate);
    }

    public static BookEntryJsonLoader<? extends BookEntry> getEntryJsonLoader(ResourceLocation id) {
        BookEntryJsonLoader<? extends BookEntry> loader = entryTypeJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for entry type " + id);
        }
        return loader;
    }

    public static NetworkLoader<? extends BookEntry> getEntryNetworkLoader(ResourceLocation id) {
        NetworkLoader<? extends BookEntry> loader = entryTypeNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for entry type " + id);
        }
        return loader;
    }

    public static JsonLoader<? extends StateMatcher> getStateMatcherJsonLoader(ResourceLocation id) {
        JsonLoader<? extends StateMatcher> loader = stateMatcherJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for state matcher type " + id);
        }
        return loader;
    }

    public static NetworkLoader<? extends StateMatcher> getStateMatcherNetworkLoader(ResourceLocation id) {
        NetworkLoader<? extends StateMatcher> loader = stateMatcherNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for state matcher type " + id);
        }
        return loader;
    }

    public static TriPredicate<BlockGetter, BlockPos, BlockState> getPredicate(ResourceLocation id) {
        TriPredicate<BlockGetter, BlockPos, BlockState> predicate = predicates.get(id);
        if (predicate == null) {
            throw new IllegalArgumentException("No predicated registered for id " + id);
        }
        return predicate;
    }

    public static JsonLoader<? extends BookPage> getPageJsonLoader(ResourceLocation id) {
        JsonLoader<? extends BookPage> loader = pageJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for page type " + id);
        }
        return loader;
    }

    public static NetworkLoader<? extends BookPage> getPageNetworkLoader(ResourceLocation id) {
        NetworkLoader<? extends BookPage> loader = pageNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for page type " + id);
        }
        return loader;
    }

    public static JsonLoader<? extends BookCondition> getConditionJsonLoader(ResourceLocation id) {
        JsonLoader<? extends BookCondition> loader = conditionJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for condition type " + id);
        }
        return loader;
    }

    public static NetworkLoader<? extends BookCondition> getConditionNetworkLoader(ResourceLocation id) {
        NetworkLoader<? extends BookCondition> loader = conditionNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for condition type " + id);
        }
        return loader;
    }

    public static JsonLoader<? extends Multiblock> getMultiblockJsonLoader(ResourceLocation id) {
        JsonLoader<? extends Multiblock> loader = multiblockJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for multiblock type " + id);
        }
        return loader;
    }

    public static NetworkLoader<? extends Multiblock> getMultiblockNetworkLoader(ResourceLocation id) {
        NetworkLoader<? extends Multiblock> loader = multiblockNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for multiblock type " + id);
        }
        return loader;
    }
}

