/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.util.Holder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class EnergyBarWidget
extends AbstractButtonWidget {
    private static final ResourceLocation BARS = new ResourceLocation("wirelesschargers", "textures/screen/energy_bars.png");
    private final Supplier<Integer> energy;
    private final Supplier<Integer> capacity;

    public EnergyBarWidget(int x, int y, int width, int height, Supplier<Integer> energy, Supplier<Integer> capacity) {
        super(x, y, width, height, () -> EnergyFormat.cycleEnergyType((!Screen.m_96638_() ? 1 : 0) != 0));
        this.energy = energy;
        this.capacity = capacity;
    }

    public Component getNarrationMessage() {
        Holder tooltip = new Holder();
        this.getTooltips(arg_0 -> ((Holder)tooltip).set(arg_0));
        return (Component)tooltip.get();
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        float percentage;
        ScreenUtils.bindTexture((ResourceLocation)BARS);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)(this.isFocused() ? 0.09090909f : 0.0f), (float)0.0f, (float)0.09090909f, (float)1.0f);
        int energy = this.energy.get();
        int capacity = this.capacity.get();
        float f = percentage = capacity == 0 ? 1.0f : Math.max(Math.min((float)energy / (float)capacity, 1.0f), 0.0f);
        if (percentage != 0.0f) {
            ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)((float)this.y + (float)this.height * (1.0f - percentage)), (float)this.width, (float)((float)this.height * percentage), (float)0.27272728f, (float)(1.0f - percentage), (float)0.09090909f, (float)percentage);
        }
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        MutableComponent energy = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.energy.get())).color(ChatFormatting.GOLD).get();
        MutableComponent capacity = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.capacity.get())).color(ChatFormatting.GOLD).string(" " + EnergyFormat.formatUnit()).color(ChatFormatting.GRAY).get();
        tooltips.accept((Component)TextComponents.translation((String)"wirelesschargers.screen.stored_energy", (Object[])new Object[]{energy, capacity}).color(ChatFormatting.GRAY).get());
    }
}

