/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;

public class ModParticles
implements RegistryClass {
    private static final DeferredRegister<ParticleType<?>> REGISTRY = RegUtil.create(ForgeRegistries.PARTICLE_TYPES);
    public static final RegistryObject<ParticleType<ParticleSpellCloudData>> SPELL_CLOUD = REGISTRY.register("spell_cloud", () -> new ParticleType<ParticleSpellCloudData>(false, (ParticleOptions.Deserializer)new ParticleSpellCloudData.Deserializer()){

        public Codec<ParticleSpellCloudData> m_7652_() {
            return ParticleSpellCloudData.codec();
        }
    });

    @Override
    public void init(IEventBus bus) {
    }

    public record ParticleSpellCloudData(int color) implements ParticleOptions
    {
        @Nonnull
        public ParticleType<?> m_6012_() {
            return (ParticleType)SPELL_CLOUD.get();
        }

        public static Codec<ParticleSpellCloudData> codec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(obj -> obj.color)).apply((Applicative)instance, ParticleSpellCloudData::new));
        }

        public void m_7711_(@Nonnull FriendlyByteBuf buf) {
            buf.writeInt(this.color);
        }

        @Nonnull
        public String m_5942_() {
            return String.format("%d", this.color);
        }

        public static class Deserializer
        implements ParticleOptions.Deserializer<ParticleSpellCloudData> {
            @Nonnull
            public ParticleSpellCloudData fromCommand(@Nonnull ParticleType<ParticleSpellCloudData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
                reader.skipWhitespace();
                int color = reader.readInt();
                return new ParticleSpellCloudData(color);
            }

            @Nonnull
            public ParticleSpellCloudData fromNetwork(@Nonnull ParticleType<ParticleSpellCloudData> type, FriendlyByteBuf buf) {
                return new ParticleSpellCloudData(buf.readInt());
            }
        }
    }
}

