/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import tamaized.voidscape.entity.SpellBoltEntity;

public class RenderSpellBolt<T extends SpellBoltEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voidscape", "textures/entity/spells/mage/bolt.png");
    private final int color;

    public RenderSpellBolt(EntityRendererProvider.Context context, int color) {
        super(context);
        this.color = color;
    }

    private void vertex(VertexConsumer buffer, Matrix4f vertex, Matrix3f normals, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        buffer.m_252986_(vertex, x, y, z);
        buffer.m_85950_(red, green, blue, alpha);
        buffer.m_7421_(texU, texV);
        buffer.m_85969_(lightmapUV);
        buffer.m_252939_(normals, normalX, normalY, normalZ);
        buffer.m_5752_();
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110460_((ResourceLocation)this.getTextureLocation(entityIn), (boolean)true));
        matrixStackIn.m_85836_();
        PoseStack.Pose stack = matrixStackIn.m_85850_();
        Matrix4f v = stack.m_252922_();
        Matrix3f n = stack.m_252943_();
        float size = 0.5f;
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        for (int i = 0; i < 8; ++i) {
            int deg = (45 * i + ((SpellBoltEntity)((Object)entityIn)).f_19797_ * 2) % 360;
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_((float)deg));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)deg));
            this.vertex(buffer, v, n, -0.5f, -0.5f, 0.0f, red, green, blue, 0.75f, 0.0f, 0.0f, 0xF000F0, OverlayTexture.f_118083_, 0.0f, 1.0f, 0.0f);
            this.vertex(buffer, v, n, -0.5f, 0.5f, 0.0f, red, green, blue, 0.75f, 0.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, 0.0f, 1.0f, 0.0f);
            this.vertex(buffer, v, n, 0.5f, 0.5f, 0.0f, red, green, blue, 0.75f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, 0.0f, 1.0f, 0.0f);
            this.vertex(buffer, v, n, 0.5f, -0.5f, 0.0f, red, green, blue, 0.75f, 1.0f, 0.0f, 0xF000F0, OverlayTexture.f_118083_, 0.0f, 1.0f, 0.0f);
        }
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(T entityIn) {
        return TEXTURE;
    }
}

