/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Cached;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.api.storage.IInventoryTracker;
import mcjty.rftoolsbase.api.storage.IModularStorage;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.InventoriesItemSource;
import mcjty.rftoolsstorage.craftinggrid.StorageCraftingTools;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageContainer;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.storage.GlobalStorageItemWrapper;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class ModularStorageTileEntity
extends GenericTileEntity
implements IInventoryTracker,
CraftingGridProvider,
JEIRecipeAcceptor,
IModularStorage {
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);
    @Cap(type=CapType.ITEMS)
    private final LazyOptional<IItemHandler> globalHandler = LazyOptional.of(this::createGlobalHandler);
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Modular Storage").containerSupplier((windowId, player) -> new ModularStorageContainer((int)windowId, this.m_58899_(), this, (Player)player)).itemHandler(() -> (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h).orElseThrow(RuntimeException::new)).setupSync((GenericTileEntity)this));
    private GlobalStorageItemWrapper globalWrapper;
    private final ItemStackHandler cardHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            if (slot == 0) {
                if (ModularStorageTileEntity.this.globalWrapper != null) {
                    StorageInfo info = ModularStorageTileEntity.this.getStorageInfo();
                    ModularStorageTileEntity.this.globalWrapper.setInfo(info);
                }
            } else if (slot == 2) {
                ModularStorageTileEntity.this.filterCache.clear();
            }
            ModularStorageTileEntity.this.m_6596_();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (ModularStorageTileEntity.this.locked) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (ModularStorageTileEntity.this.locked) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private final CraftingGrid craftingGrid = new CraftingGrid();
    private String sortMode = "";
    private String viewMode = "";
    private boolean groupMode = false;
    private String filter = "";
    private boolean locked = false;
    public static final Key<String> PARAM_FILTER = new Key("filter", Type.STRING);
    public static final Key<String> PARAM_VIEWMODE = new Key("viewmode", Type.STRING);
    public static final Key<String> PARAM_SORTMODE = new Key("sortmode", Type.STRING);
    public static final Key<Boolean> PARAM_GROUPMODE = new Key("groupmode", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_LOCKED = new Key("locked", Type.BOOLEAN);
    @ServerCommand
    public static final Command<?> CMD_SETTINGS = Command.create((String)"storage.settings", (te, player, params) -> {
        te.setFilter((String)params.get(PARAM_FILTER));
        te.setViewMode((String)params.get(PARAM_VIEWMODE));
        te.setSortMode((String)params.get(PARAM_SORTMODE));
        te.setGroupMode((Boolean)params.get(PARAM_GROUPMODE));
        te.setLocked((Boolean)params.get(PARAM_LOCKED));
        te.m_6596_();
    });
    @ServerCommand
    public static final Command<?> CMD_CLEARGRID = Command.create((String)"clearGrid", (te, player, params) -> te.clearGrid());
    @ServerCommand
    public static final Command<?> CMD_CYCLE = Command.create((String)"cycle", (te, player, params) -> te.cycle());
    @ServerCommand
    public static final Command<?> CMD_COMPACT = Command.create((String)"compact", (te, player, params) -> te.compact());

    public ModularStorageTileEntity(BlockPos pos, BlockState state) {
        super(ModularStorageModule.TYPE_MODULAR_STORAGE.get(), pos, state);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.m_6596_();
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setStackInSlot(i, stacks.get(i));
        }
        this.m_6596_();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.m_6596_();
    }

    @Override
    @Nonnull
    public List<Pair<ItemStack, Integer>> craft(Player player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IItemHandler)new InvWrapper((Container)player.m_150109_()), 0);
        this.globalHandler.ifPresent(h -> itemSource.add((IItemHandler)h, 0));
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        return Collections.emptyList();
    }

    public boolean isGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(boolean groupMode) {
        this.groupMode = groupMode;
        this.m_6596_();
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
        this.m_6596_();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.m_6596_();
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
        this.m_6596_();
    }

    public int getRenderLevel() {
        return 0;
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
    }

    public void syncInventoryFromServer(String sortMode, String viewMode, boolean groupMode, String filter, boolean locked) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
        this.locked = locked;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.sortMode = tagCompound.m_128461_("sortMode");
        this.viewMode = tagCompound.m_128461_("viewMode");
        this.groupMode = tagCompound.m_128471_("groupMode");
        this.filter = tagCompound.m_128461_("filter");
        this.craftingGrid.readFromNBT(tagCompound.m_128469_("grid"));
    }

    protected void loadCaps(CompoundTag tagCompound) {
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            CompoundTag infoTag = tagCompound.m_128469_("Info");
            this.cardHandler.deserializeNBT(infoTag.m_128469_("Cards"));
            this.locked = infoTag.m_128441_("locked") ? infoTag.m_128471_("locked") : !this.cardHandler.getStackInSlot(0).m_41619_();
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128359_("sortMode", this.sortMode);
        tagCompound.m_128359_("viewMode", this.viewMode);
        tagCompound.m_128379_("groupMode", this.groupMode);
        tagCompound.m_128359_("filter", this.filter);
        tagCompound.m_128365_("grid", (Tag)this.craftingGrid.writeToNBT());
    }

    protected void saveCaps(CompoundTag tagCompound) {
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.m_128365_("Cards", (Tag)this.cardHandler.serializeNBT());
        infoTag.m_128379_("locked", this.locked);
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.m_6596_();
    }

    public void setLocked(boolean locked) {
        ItemStack card;
        this.locked = locked;
        if (!this.f_58857_.f_46443_ && !(card = this.cardHandler.getStackInSlot(0)).m_41619_()) {
            card.m_41784_().m_128405_("infoAmount", this.getNumStacks());
            StorageEntry storage = this.globalWrapper.getStorage();
            if (storage != null) {
                card.m_41784_().m_128356_("infoCreateTime", storage.getCreationTime());
                card.m_41784_().m_128356_("infoUpdateTime", storage.getUpdateTime());
            }
        }
        this.m_6596_();
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void cycle() {
    }

    private void compact() {
        if (!this.locked) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.globalWrapper.getSlots(); ++i) {
            ItemStack stack = this.globalWrapper.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
            this.globalWrapper.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (ItemStack stack : stacks) {
            ItemHandlerHelper.insertItem((IItemHandler)this.globalWrapper, (ItemStack)stack, (boolean)false);
        }
        this.m_6596_();
    }

    @Nonnull
    public StorageInfo getStorageInfo() {
        ItemStack storageCard = this.cardHandler.getStackInSlot(0);
        if (storageCard.m_41619_()) {
            return StorageInfo.EMPTY;
        }
        return StorageModuleItem.getStorageInfo(storageCard);
    }

    public int getVersion() {
        return this.getStorageInfo().version();
    }

    public int getMaxSize() {
        StorageInfo info = this.getStorageInfo();
        return info.size();
    }

    private Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.cardHandler.getStackInSlot(2));
    }

    @Nonnull
    private IItemHandlerModifiable createGlobalHandler() {
        StorageInfo info = this.getStorageInfo();
        if (this.globalWrapper == null) {
            this.globalWrapper = new GlobalStorageItemWrapper(info, this.f_58857_.f_46443_){

                @Override
                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    boolean rc = super.isItemValid(slot, stack);
                    if (!rc) {
                        return false;
                    }
                    if (!ModularStorageTileEntity.this.cardHandler.getStackInSlot(2).m_41619_() && ModularStorageTileEntity.this.filterCache.get() != null) {
                        return ((Predicate)ModularStorageTileEntity.this.filterCache.get()).test(stack);
                    }
                    return true;
                }

                @Override
                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    if (!ModularStorageTileEntity.this.locked) {
                        return stack;
                    }
                    return super.insertItem(slot, stack, simulate);
                }

                @Override
                @Nonnull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (!ModularStorageTileEntity.this.locked) {
                        return ItemStack.f_41583_;
                    }
                    return super.extractItem(slot, amount, simulate);
                }
            };
            if (!this.f_58857_.f_46443_) {
                this.globalWrapper.setListener((version, slot) -> {
                    ItemStack storageSlot = this.cardHandler.getStackInSlot(0);
                    if (storageSlot.m_41720_() instanceof StorageModuleItem) {
                        storageSlot.m_41784_().m_128405_("version", version);
                    }
                    this.markDirtyQuick();
                });
            }
        } else {
            this.globalWrapper.setInfo(info);
        }
        return this.globalWrapper;
    }

    public IItemHandler getCardHandler() {
        return this.cardHandler;
    }

    public int getNumStacks() {
        int cnt = 0;
        if (this.globalWrapper == null) {
            this.createGlobalHandler();
        }
        for (int i = 0; i < this.globalWrapper.getSlots(); ++i) {
            if (this.globalWrapper.getStackInSlot(i).m_41619_()) continue;
            ++cnt;
        }
        return cnt;
    }
}

