/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.taglist;

import appeng.api.stacks.AEKey;
import appeng.util.prioritylist.IPartitionList;
import com.glodblock.github.extendedae.common.me.taglist.TagExpParser;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TagPriorityList
implements IPartitionList {
    private static final Map<TagPriorityList, Runnable> INVALIDATOR = new WeakHashMap<TagPriorityList, Runnable>();
    private Set<TagKey<?>> whiteSet;
    private Set<TagKey<?>> blackSet;
    private final String tagExpWhite;
    private final String tagExpBlack;
    private final Reference2BooleanMap<Object> memory = new Reference2BooleanOpenHashMap();

    public TagPriorityList(Set<TagKey<?>> whiteKeys, Set<TagKey<?>> blackKeys, String tagExpWhite, String tagExpBlack) {
        this.whiteSet = whiteKeys;
        this.blackSet = blackKeys;
        this.tagExpWhite = tagExpWhite;
        this.tagExpBlack = tagExpBlack;
        INVALIDATOR.put(this, () -> {
            this.whiteSet = TagExpParser.getMatchingOre(this.tagExpWhite);
            this.blackSet = TagExpParser.getMatchingOre(this.tagExpBlack);
            this.memory.clear();
        });
    }

    public static void reset() {
        for (Map.Entry<TagPriorityList, Runnable> e : INVALIDATOR.entrySet()) {
            e.getValue().run();
        }
    }

    public boolean isListed(AEKey input) {
        Object key = input.getPrimaryKey();
        return this.memory.computeIfAbsent(key, this::eval);
    }

    public boolean isEmpty() {
        return this.tagExpBlack.isEmpty() && this.tagExpWhite.isEmpty();
    }

    public Iterable<AEKey> getItems() {
        return List.of();
    }

    private boolean eval(@NotNull Object obj) {
        Holder refer = null;
        if (obj instanceof Item) {
            Item item = (Item)obj;
            refer = ForgeRegistries.ITEMS.getHolder((Object)item).orElse(null);
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            refer = ForgeRegistries.FLUIDS.getHolder((Object)fluid).orElse(null);
        }
        if (refer != null) {
            if (this.whiteSet.isEmpty()) {
                return false;
            }
            boolean pass = refer.m_203616_().anyMatch(this.whiteSet::contains);
            if (pass) {
                if (!this.blackSet.isEmpty()) {
                    return refer.m_203616_().noneMatch(this.blackSet::contains);
                }
                return true;
            }
        }
        return false;
    }
}

