/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.gregtechceu.gtceu.utils.ToolItemHelper;
import com.lowdragmc.lowdraglib.LDLib;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTUtil {
    public static final Direction[] DIRECTIONS = Direction.values();

    @Nullable
    public static Direction determineWrenchingSide(Direction facing, float x, float y, float z) {
        Direction opposite = facing.m_122424_();
        switch (facing) {
            case DOWN: 
            case UP: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return Direction.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return Direction.EAST;
                }
                if ((double)z < 0.25) {
                    return Direction.NORTH;
                }
                if ((double)z > 0.75) {
                    return Direction.SOUTH;
                }
                return facing;
            }
            case NORTH: 
            case SOUTH: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.EAST;
                }
                if ((double)y < 0.25) {
                    return Direction.DOWN;
                }
                if ((double)y > 0.75) {
                    return Direction.UP;
                }
                return facing;
            }
            case WEST: 
            case EAST: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.NORTH;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.SOUTH;
                }
                if ((double)y < 0.25) {
                    return Direction.DOWN;
                }
                if ((double)y > 0.75) {
                    return Direction.UP;
                }
                return facing;
            }
        }
        return null;
    }

    @Nullable
    public static Direction getFacingToNeighbor(@NotNull BlockPos main, @NotNull BlockPos neighbor) {
        int difX = neighbor.m_123341_() - main.m_123341_();
        int difY = neighbor.m_123342_() - main.m_123342_();
        int difZ = neighbor.m_123343_() - main.m_123343_();
        if (difX != 0) {
            if (difY != 0 || difZ != 0 || difX != 1 && difX != -1) {
                return null;
            }
            return difX > 0 ? Direction.EAST : Direction.WEST;
        }
        if (difY != 0) {
            if (difZ != 0 || difY != 1 && difY != -1) {
                return null;
            }
            return difY > 0 ? Direction.UP : Direction.DOWN;
        }
        if (difZ != 0) {
            if (difZ != 1 && difZ != -1) {
                return null;
            }
            return difZ > 0 ? Direction.SOUTH : Direction.NORTH;
        }
        return null;
    }

    public static float getExplosionPower(long voltage) {
        return GTUtil.getTierByVoltage(voltage) + 1;
    }

    public static int nearestLesserOrEqual(@NotNull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] <= value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static int nearestLesser(@NotNull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] < value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static byte getTierByVoltage(long voltage) {
        if (voltage > Integer.MAX_VALUE) {
            return 14;
        }
        return GTUtil.getOCTierByVoltage(voltage);
    }

    public static byte getOCTierByVoltage(long voltage) {
        if (voltage <= GTValues.V[0]) {
            return 0;
        }
        return (byte)(62 - Long.numberOfLeadingZeros(voltage - 1L) >> 1);
    }

    public static byte getFloorTierByVoltage(long voltage) {
        if (voltage < GTValues.V[1]) {
            return 0;
        }
        if (voltage == GTValues.VEX[30]) {
            return 30;
        }
        return (byte)(60 - Long.numberOfLeadingZeros(voltage) >> 1);
    }

    public static ItemStack copy(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            return stack.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack copyAmount(int amount, ItemStack ... stacks) {
        ItemStack stack = GTUtil.copy(stacks);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (amount > 64) {
            amount = 64;
        } else if (amount == -1) {
            amount = 111;
        } else if (amount < 0) {
            amount = 0;
        }
        stack.m_41764_(amount);
        return stack;
    }

    public static FluidStack copyAmount(int amount, FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        FluidStack stack = fluidStack.copy();
        stack.setAmount(amount);
        return stack;
    }

    public static <M> M selectItemInList(int index, M replacement, List<M> list, Class<M> minClass) {
        if (list.isEmpty()) {
            return replacement;
        }
        M maybeResult = list.size() <= index ? list.get(list.size() - 1) : (index < 0 ? list.get(0) : list.get(index));
        if (maybeResult != null) {
            return maybeResult;
        }
        return replacement;
    }

    public static <M> M getItem(List<? extends M> list, int index, M replacement) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return replacement;
    }

    public static <T> int getRandomItem(RandomSource random, List<? extends Map.Entry<Integer, T>> randomList, int size) {
        if (randomList.isEmpty()) {
            return -1;
        }
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            Map.Entry<Integer, T> entry = randomList.get(i);
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + entry.getKey());
            }
            baseOffsets[i] = currentIndex += entry.getKey().intValue();
        }
        int randomValue = random.m_188503_(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    public static <T> int getRandomItem(List<? extends Map.Entry<Integer, T>> randomList, int size) {
        return GTUtil.getRandomItem(GTValues.RNG, randomList, size);
    }

    public static <T, R> Class<T> getActualTypeParameter(Class<? extends R> thisClass, int index) {
        Type type = thisClass.getGenericSuperclass();
        return (Class)((ParameterizedType)type).getActualTypeArguments()[index];
    }

    public static boolean isShiftDown() {
        if (LDLib.isClient()) {
            long id = Minecraft.m_91087_().m_91268_().m_85439_();
            return InputConstants.m_84830_((long)id, (int)340) || InputConstants.m_84830_((long)id, (int)340);
        }
        return false;
    }

    public static boolean isCtrlDown() {
        if (LDLib.isClient()) {
            long id = Minecraft.m_91087_().m_91268_().m_85439_();
            return InputConstants.m_84830_((long)id, (int)341) || InputConstants.m_84830_((long)id, (int)345);
        }
        return false;
    }

    public static boolean isAltDown() {
        if (LDLib.isClient()) {
            long id = Minecraft.m_91087_().m_91268_().m_85439_();
            return InputConstants.m_84830_((long)id, (int)342) || InputConstants.m_84830_((long)id, (int)346);
        }
        return false;
    }

    public static boolean isFluidStackAmountDivisible(FluidStack fluidStack, int divisor) {
        return fluidStack.getAmount() % divisor == 0 && fluidStack.getAmount() % divisor != fluidStack.getAmount() && fluidStack.getAmount() / divisor != 0;
    }

    public static boolean isItemStackCountDivisible(ItemStack itemStack, int divisor) {
        return itemStack.m_41613_() % divisor == 0 && itemStack.m_41613_() % divisor != itemStack.m_41613_() && itemStack.m_41613_() / divisor != 0;
    }

    public static int getItemBurnTime(Item item) {
        return ForgeHooks.getBurnTime((ItemStack)item.m_7968_(), (RecipeType)RecipeType.f_44108_);
    }

    public static int getPumpBiomeModifier(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return -1;
        }
        if (biome.m_203656_(BiomeTags.f_207602_) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207604_) || biome.m_203656_(BiomeTags.f_207605_)) {
            return 1000;
        }
        if (biome.m_203656_(Tags.Biomes.IS_SWAMP) || biome.m_203656_(Tags.Biomes.IS_WET)) {
            return 800;
        }
        if (biome.m_203656_(BiomeTags.f_207610_)) {
            return 350;
        }
        if (biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            return 300;
        }
        if (biome.m_203656_(Tags.Biomes.IS_PLAINS) || biome.m_203656_(BiomeTags.f_207611_)) {
            return 250;
        }
        if (biome.m_203656_(Tags.Biomes.IS_COLD)) {
            return 175;
        }
        if (biome.m_203656_(CustomTags.IS_SANDY)) {
            return 170;
        }
        return 100;
    }

    public static DyeColor determineDyeColor(int rgbColor) {
        float[] c = GradientUtil.getRGB(rgbColor);
        HashMap<Double, DyeColor> distances = new HashMap<Double, DyeColor>();
        for (DyeColor dyeColor : DyeColor.values()) {
            float[] c2 = GradientUtil.getRGB(dyeColor.m_41071_());
            double distance = (c[0] - c2[0]) * (c[0] - c2[0]) + (c[1] - c2[1]) * (c[1] - c2[1]) + (c[2] - c2[2]) * (c[2] - c2[2]);
            distances.put(distance, dyeColor);
        }
        double min = (Double)Collections.min(distances.keySet());
        return (DyeColor)distances.get(min);
    }

    public static int convertRGBtoARGB(int colorValue) {
        return GTUtil.convertRGBtoARGB(colorValue, 255);
    }

    public static int convertRGBtoARGB(int colorValue, int opacity) {
        if ((colorValue >> 24 & 0xFF) != 0) {
            return colorValue;
        }
        return opacity << 24 | colorValue;
    }

    @Nullable
    public static Fluid getMoltenFluid(@NotNull Material material) {
        if (material.hasProperty(PropertyKey.ALLOY_BLAST)) {
            return material.getProperty(PropertyKey.FLUID).getStorage().get(FluidStorageKeys.MOLTEN);
        }
        if (!TagPrefix.ingotHot.doGenerateItem(material) && material.hasProperty(PropertyKey.FLUID)) {
            return material.getProperty(PropertyKey.FLUID).getStorage().get(FluidStorageKeys.LIQUID);
        }
        return null;
    }

    public static int getFluidColor(FluidStack fluid) {
        return IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid);
    }

    public static boolean canSeeSunClearly(Level world, BlockPos blockPos) {
        if (!world.m_45527_(blockPos.m_7494_())) {
            return false;
        }
        Biome biome = (Biome)world.m_204166_(blockPos.m_7494_()).m_203334_();
        if (world.m_46471_() && (biome.m_198906_(blockPos.m_7494_()) || biome.m_198904_(blockPos.m_7494_()))) {
            return false;
        }
        if (world.m_204166_(blockPos.m_7494_()).m_203656_(BiomeTags.f_215818_)) {
            return false;
        }
        ResourceLocation javdVoidBiome = new ResourceLocation("javd", "void");
        if (GTCEu.isJAVDLoaded() && world.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome).equals((Object)javdVoidBiome)) {
            return !world.m_46461_();
        }
        return world.m_46461_();
    }

    public static void appendHazardTooltips(Material material, List<Component> tooltipComponents) {
        if (!ConfigHolder.INSTANCE.gameplay.hazardsEnabled || !material.hasProperty(PropertyKey.HAZARD)) {
            return;
        }
        if (GTUtil.isShiftDown()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"gtceu.medical_condition.description_shift"));
            tooltipComponents.add((Component)Component.m_237115_((String)("gtceu.medical_condition." + material.getProperty(PropertyKey.HAZARD).condition.name)));
            tooltipComponents.add((Component)Component.m_237115_((String)"gtceu.hazard_trigger.description"));
            tooltipComponents.add((Component)Component.m_237115_((String)("gtceu.hazard_trigger." + material.getProperty(PropertyKey.HAZARD).hazardTrigger.name())));
            return;
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"gtceu.medical_condition.description"));
    }

    public static CompoundTag saveItemStack(ItemStack itemStack, CompoundTag compoundTag) {
        ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
        compoundTag.m_128359_("id", resourceLocation.toString());
        compoundTag.m_128405_("Count", itemStack.m_41613_());
        if (itemStack.m_41783_() != null) {
            compoundTag.m_128365_("tag", (Tag)itemStack.m_41783_().m_6426_());
        }
        return compoundTag;
    }

    public static ItemStack loadItemStack(CompoundTag compoundTag) {
        try {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(compoundTag.m_128461_("id")));
            int count = compoundTag.m_128451_("Count");
            ItemStack stack = new ItemStack((ItemLike)item, count);
            if (compoundTag.m_128425_("tag", 10)) {
                stack.m_41751_(compoundTag.m_128469_("tag"));
                if (stack.m_41783_() != null) {
                    stack.m_41720_().m_142312_(stack.m_41783_());
                }
            }
            if (stack.m_41720_().m_41465_()) {
                stack.m_41721_(stack.m_41773_());
            }
            return stack;
        }
        catch (RuntimeException var2) {
            GTCEu.LOGGER.debug("Tried to load invalid item: {}", (Object)compoundTag, (Object)var2);
            return ItemStack.f_41583_;
        }
    }

    public static Tuple<ItemStack, MutableComponent> getMaintenanceText(byte flag) {
        return switch (flag) {
            case 0 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.WRENCH), (Object)Component.m_237115_((String)"gtceu.top.maintenance.wrench"));
            case 1 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.SCREWDRIVER), (Object)Component.m_237115_((String)"gtceu.top.maintenance.screwdriver"));
            case 2 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.SOFT_MALLET), (Object)Component.m_237115_((String)"gtceu.top.maintenance.soft_mallet"));
            case 3 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.HARD_HAMMER), (Object)Component.m_237115_((String)"gtceu.top.maintenance.hard_hammer"));
            case 4 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.WIRE_CUTTER), (Object)Component.m_237115_((String)"gtceu.top.maintenance.wire_cutter"));
            default -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.CROWBAR), (Object)Component.m_237115_((String)"gtceu.top.maintenance.crowbar"));
        };
    }

    public static void addPotionTooltip(List<Pair<MobEffectInstance, Float>> effects, List<Component> list) {
        if (!effects.isEmpty()) {
            list.add((Component)Component.m_237115_((String)"gtceu.tooltip.potion.header"));
        }
        effects.forEach(pair -> {
            MobEffectInstance effect = (MobEffectInstance)pair.getFirst();
            float probability = ((Float)pair.getSecond()).floatValue();
            list.add((Component)Component.m_237110_((String)"gtceu.tooltip.potion.each", (Object[])new Object[]{Component.m_237115_((String)effect.m_19576_()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), Component.m_237115_((String)("enchantment.level." + (effect.m_19564_() + 1))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), Component.m_237113_((String)String.valueOf(effect.m_19557_())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), Component.m_237113_((String)String.valueOf(100.0f * probability)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN))}));
        });
    }
}

