/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.google.common.base.CaseFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattingUtil {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.ROOT);
    public static final DecimalFormat DECIMAL_FORMAT_0F = new DecimalFormat(",###");
    public static final DecimalFormat DECIMAL_FORMAT_1F = new DecimalFormat("#,##0.#");
    public static final DecimalFormat DECIMAL_FORMAT_2F = new DecimalFormat("#,##0.##");
    public static final DecimalFormat DECIMAL_FORMAT_SIC = new DecimalFormat("0E00");
    private static final int SMALL_DOWN_NUMBER_BASE = 8320;
    private static final int SMALL_UP_NUMBER_BASE = 8304;
    private static final int SMALL_UP_NUMBER_ONE = 185;
    private static final int SMALL_UP_NUMBER_TWO = 178;
    private static final int SMALL_UP_NUMBER_THREE = 179;
    private static final int NUMBER_BASE = 48;

    public static String toSmallUpNumbers(String string) {
        return FormattingUtil.checkNumbers(string, 8304, true);
    }

    public static String toSmallDownNumbers(String string) {
        return FormattingUtil.checkNumbers(string, 8320, false);
    }

    @NotNull
    private static String checkNumbers(String string, int smallUpNumberBase, boolean isUp) {
        char[] charArray = string.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            int relativeIndex = charArray[i] - 48;
            if (relativeIndex < 0 || relativeIndex > 9) continue;
            if (isUp) {
                if (relativeIndex == 1) {
                    charArray[i] = 185;
                    continue;
                }
                if (relativeIndex == 2) {
                    charArray[i] = 178;
                    continue;
                }
                if (relativeIndex == 3) {
                    charArray[i] = 179;
                    continue;
                }
            }
            int newChar = smallUpNumberBase + relativeIndex;
            charArray[i] = (char)newChar;
        }
        return new String(charArray);
    }

    public static String toLowerCaseUnderscore(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i != 0 && (Character.isUpperCase(string.charAt(i)) || Character.isDigit(string.charAt(i - 1)) ^ Character.isDigit(string.charAt(i)))) {
                result.append("_");
            }
            result.append(Character.toLowerCase(string.charAt(i)));
        }
        return result.toString();
    }

    public static String toLowerCaseUnder(String string) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, string);
    }

    public static String toEnglishName(Object internalName) {
        return Arrays.stream(internalName.toString().toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static String toRomanNumeral(int number) {
        return "I".repeat(number).replace("IIIII", "V").replace("IIII", "IV").replace("VV", "X").replace("VIV", "IX").replace("XXXXX", "L").replace("XXXX", "XL").replace("LL", "C").replace("LXL", "XC").replace("CCCCC", "D").replace("CCCC", "CD").replace("DD", "M").replace("DCD", "CM");
    }

    public static String lowerUnderscoreToUpperCamel(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '_') continue;
            if (i == 0 || string.charAt(i - 1) == '_') {
                result.append(Character.toUpperCase(string.charAt(i)));
                continue;
            }
            result.append(string.charAt(i));
        }
        return result.toString();
    }

    public static String formatPercent(double number) {
        return String.format("%,.2f", number);
    }

    public static String formatNumbers(int number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(double number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(Object number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumberReadable(long number) {
        return FormattingUtil.formatNumberReadable(number, false);
    }

    public static String formatNumberReadable(long number, boolean milli) {
        return FormattingUtil.formatNumberReadable(number, milli, DECIMAL_FORMAT_1F, null);
    }

    public static String formatNumberReadable2F(double number, boolean milli) {
        return FormattingUtil.formatNumberReadable(number, milli, DECIMAL_FORMAT_2F, null);
    }

    public static String formatNumberReadable(double number, boolean milli, NumberFormat fmt, @Nullable String unit) {
        StringBuilder sb = new StringBuilder();
        if (number < 0.0) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            milli = false;
            number /= 1000.0;
        }
        int exp = 0;
        if (number >= 1000.0) {
            exp = (int)Math.log10(number) / 3;
            if (exp > 7) {
                exp = 7;
            }
            if (exp > 0) {
                number /= Math.pow(1000.0, exp);
            }
        }
        sb.append(fmt.format(number));
        if (exp > 0) {
            sb.append("kMGTPEZ".charAt(exp - 1));
        } else if (milli && number != 0.0) {
            sb.append('m');
        }
        if (unit != null) {
            sb.append(unit);
        }
        return sb.toString();
    }

    public static String formatBuckets(long mB) {
        return FormattingUtil.formatNumberReadable(mB, true, DECIMAL_FORMAT_2F, "B");
    }

    @NotNull
    public static String formatNumber2Places(float number) {
        return DECIMAL_FORMAT_2F.format(number);
    }

    @NotNull
    public static String formatNumber2Places(double number) {
        return DECIMAL_FORMAT_2F.format(number);
    }

    public static Component formatPercentage2Places(String langKey, float percentage) {
        return Component.m_237110_((String)langKey, (Object[])new Object[]{FormattingUtil.formatNumber2Places(percentage)}).m_130940_(ChatFormatting.YELLOW);
    }

    public static void combineComponents(MutableComponent c1, Component c2) {
        if (!FormattingUtil.isEmptyComponent((Component)c1) && !FormattingUtil.isEmptyComponent(c2)) {
            c1.m_130946_(", ").m_7220_(c2);
        } else {
            c1.m_7220_(c2);
        }
    }

    private static boolean isEmptyComponent(Component component) {
        return component.m_214077_() == ComponentContents.f_237124_ && component.m_7360_().isEmpty();
    }
}

