/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class BreadthFirstBlockSearch {
    public static Set<BlockPos> search(Predicate<BlockPos> value, BlockPos start, int limit) {
        HashSet<BlockPos> alreadyVisited = new HashSet<BlockPos>();
        HashSet<BlockPos> valid = new HashSet<BlockPos>();
        int iteration = 0;
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty()) {
            BlockPos currentNode = (BlockPos)queue.remove();
            if (value.test(currentNode)) {
                if (limit < iteration++) break;
                valid.add(currentNode);
                continue;
            }
            alreadyVisited.add(currentNode);
            queue.addAll(BreadthFirstBlockSearch.getNeighbors(currentNode));
            queue.removeAll(alreadyVisited);
        }
        return valid;
    }

    public static Collection<BlockPos> getNeighbors(BlockPos pos) {
        HashSet<BlockPos> neighbors = new HashSet<BlockPos>();
        for (Direction dir : GTUtil.DIRECTIONS) {
            neighbors.add(pos.m_121945_(dir));
        }
        return neighbors;
    }

    public static <T extends BlockEntity> Set<T> conditionalBlockEntitySearch(Class<T> clazz, T start, TriPredicate<T, T, Direction> condition, int blockLimit, int iterationLimit) {
        Level level = start.m_58904_();
        if (level == null) {
            return Set.of();
        }
        HashSet<BlockEntity> passed = new HashSet<BlockEntity>();
        ObjectArrayFIFOQueue queue = new ObjectArrayFIFOQueue(16);
        queue.enqueue((Object)new ImmutableTriple(null, start, null));
        int iterations = 0;
        while (!queue.isEmpty() && iterations < iterationLimit && passed.size() < blockLimit) {
            Triple tuple = (Triple)queue.dequeue();
            BlockEntity next = (BlockEntity)tuple.getMiddle();
            if (passed.contains(next)) continue;
            if (condition.test((Object)((BlockEntity)tuple.getLeft()), (Object)((BlockEntity)tuple.getMiddle()), (Object)((Direction)tuple.getRight()))) {
                passed.add(next);
                for (Direction direction : Direction.values()) {
                    BlockEntity casted;
                    BlockEntity neighbor = level.m_7702_(next.m_58899_().m_121945_(direction));
                    if (!clazz.isInstance(neighbor) || passed.contains(casted = (BlockEntity)clazz.cast(neighbor))) continue;
                    queue.enqueue((Object)new ImmutableTriple((Object)next, (Object)casted, (Object)direction));
                }
            }
            ++iterations;
        }
        return passed;
    }

    public static Set<BlockPos> conditionalBlockPosSearch(BlockPos start, BiPredicate<BlockPos, BlockPos> condition, int blockLimit, int iterationLimit) {
        HashSet<BlockPos> passed = new HashSet<BlockPos>();
        ObjectArrayFIFOQueue queue = new ObjectArrayFIFOQueue(16);
        queue.enqueue((Object)new Tuple(null, (Object)start));
        int iterations = 0;
        while (!queue.isEmpty() && iterations < iterationLimit && passed.size() < blockLimit) {
            Tuple tuple = (Tuple)queue.dequeue();
            BlockPos next = (BlockPos)tuple.m_14419_();
            if (passed.contains(next)) continue;
            if (condition.test((BlockPos)tuple.m_14418_(), (BlockPos)tuple.m_14419_())) {
                passed.add(next);
                BreadthFirstBlockSearch.getNeighbors(next).forEach(neighbor -> {
                    if (!passed.contains(neighbor)) {
                        queue.enqueue((Object)new Tuple((Object)next, neighbor));
                    }
                });
            }
            ++iterations;
        }
        return passed;
    }
}

