/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.xei.widgets;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedButtonWidget;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.recipe.condition.DimensionCondition;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public class GTRecipeWidget
extends WidgetGroup {
    public static final String RECIPE_CONTENT_GROUP_ID = "recipeContentGroup";
    public static final Pattern RECIPE_CONTENT_GROUP_ID_REGEX = Pattern.compile("^recipeContentGroup$");
    public static final int LINE_HEIGHT = 10;
    private final int xOffset;
    private final GTRecipe recipe;
    private final List<LabelWidget> recipeParaTexts = new ArrayList<LabelWidget>();
    private final int minTier;
    private int tier;
    private int yOffset;
    private LabelWidget voltageTextWidget;

    public GTRecipeWidget(GTRecipe recipe) {
        super(GTRecipeWidget.getXOffset(recipe), 0, recipe.recipeType.getRecipeUI().getJEISize().width, recipe.recipeType.getRecipeUI().getJEISize().height);
        this.recipe = recipe;
        this.xOffset = GTRecipeWidget.getXOffset(recipe);
        this.minTier = RecipeHelper.getRecipeEUtTier(recipe);
        this.setRecipeWidget();
        this.setTierToMin();
        this.initializeRecipeTextWidget();
        this.addButtons();
    }

    private static int getXOffset(GTRecipe recipe) {
        if (recipe.recipeType.getRecipeUI().getOriginalWidth() != recipe.recipeType.getRecipeUI().getJEISize().width) {
            return (recipe.recipeType.getRecipeUI().getJEISize().width - recipe.recipeType.getRecipeUI().getOriginalWidth()) / 2;
        }
        return 0;
    }

    private void setRecipeWidget() {
        int yOffset;
        this.setClientSideWidget();
        Table storages = Tables.newCustomTable(new EnumMap(IO.class), LinkedHashMap::new);
        Table contents = Tables.newCustomTable(new EnumMap(IO.class), LinkedHashMap::new);
        this.collectStorage(storages, contents, this.recipe);
        WidgetGroup group = this.recipe.recipeType.getRecipeUI().createUITemplate(ProgressWidget.JEIProgress, storages, this.recipe.data.m_6426_(), this.recipe.conditions);
        this.addSlots(contents, group, this.recipe);
        Size size = group.getSize();
        group.setId(RECIPE_CONTENT_GROUP_ID);
        this.getWidgetsById(RECIPE_CONTENT_GROUP_ID_REGEX).forEach(arg_0 -> ((GTRecipeWidget)this).removeWidget(arg_0));
        this.addWidget((Widget)group);
        long EUt = RecipeHelper.getInputEUt(this.recipe);
        if (EUt == 0L) {
            EUt = RecipeHelper.getOutputEUt(this.recipe);
        }
        this.yOffset = yOffset = 5 + size.height;
        yOffset += EUt > 0L ? 20 : 0;
        if (this.recipe.data.m_128471_("duration_is_total_cwu")) {
            yOffset -= 10;
        }
        MutableInt yOff = new MutableInt(yOffset);
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : this.recipe.inputs.entrySet()) {
            entry.getKey().addXEIInfo(this, this.xOffset, this.recipe, entry.getValue(), false, true, yOff);
        }
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : this.recipe.tickInputs.entrySet()) {
            entry.getKey().addXEIInfo(this, this.xOffset, this.recipe, entry.getValue(), true, true, yOff);
        }
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : this.recipe.outputs.entrySet()) {
            entry.getKey().addXEIInfo(this, this.xOffset, this.recipe, entry.getValue(), false, false, yOff);
        }
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : this.recipe.tickOutputs.entrySet()) {
            entry.getKey().addXEIInfo(this, this.xOffset, this.recipe, entry.getValue(), true, false, yOff);
        }
        for (RecipeCondition recipeCondition : this.recipe.conditions) {
            if (recipeCondition.getTooltips() == null) continue;
            if (recipeCondition instanceof DimensionCondition) {
                DimensionCondition dimCondition = (DimensionCondition)recipeCondition;
                this.addWidget((Widget)dimCondition.setupDimensionMarkers(this.recipe.recipeType.getRecipeUI().getJEISize().width - this.xOffset - 44, this.recipe.recipeType.getRecipeUI().getJEISize().height - 32).setBackgroundTexture(IGuiTexture.EMPTY));
                continue;
            }
            this.addWidget((Widget)new LabelWidget(3 - this.xOffset, yOffset += 10, recipeCondition.getTooltips().getString()));
        }
        for (Function function : this.recipe.recipeType.getDataInfos()) {
            this.addWidget((Widget)new LabelWidget(3 - this.xOffset, yOffset += 10, (String)function.apply(this.recipe.data)));
        }
        this.recipe.recipeType.getRecipeUI().appendJEIUI(this.recipe, this);
    }

    private void initializeRecipeTextWidget() {
        String tierText = GTValues.VNF[this.tier];
        int textsY = this.yOffset - 10;
        int duration = this.recipe.duration;
        long inputEUt = RecipeHelper.getInputEUt(this.recipe);
        long outputEUt = RecipeHelper.getOutputEUt(this.recipe);
        List<Component> texts = GTRecipeWidget.getRecipeParaText(this.recipe, duration, inputEUt, outputEUt);
        for (Component text : texts) {
            LabelWidget labelWidget = new LabelWidget(3 - this.xOffset, textsY += 10, text).setTextColor(-1).setDropShadow(true);
            this.addWidget((Widget)labelWidget);
            this.recipeParaTexts.add(labelWidget);
        }
        if (inputEUt > 0L) {
            LabelWidget voltageTextWidget = new LabelWidget(this.getVoltageXOffset() - this.xOffset, this.getSize().height - 10, tierText).setTextColor(-1).setDropShadow(false);
            if (this.recipe.recipeType.isOffsetVoltageText()) {
                voltageTextWidget.setSelfPositionY(this.getSize().height - this.recipe.recipeType.getVoltageTextOffset());
            }
            this.addWidget(new ButtonWidget(voltageTextWidget.getPositionX(), voltageTextWidget.getPositionY(), voltageTextWidget.getSizeWidth(), voltageTextWidget.getSizeHeight(), cd -> this.setRecipeOC(cd.button, cd.isShiftClick)).setHoverTooltips(new Component[]{Component.m_237110_((String)"gtceu.oc.tooltip.0", (Object[])new Object[]{GTValues.VNF[this.minTier]}), Component.m_237115_((String)"gtceu.oc.tooltip.1"), Component.m_237115_((String)"gtceu.oc.tooltip.2"), Component.m_237115_((String)"gtceu.oc.tooltip.3"), Component.m_237115_((String)"gtceu.oc.tooltip.4")}));
            this.voltageTextWidget = voltageTextWidget;
            this.addWidget((Widget)this.voltageTextWidget);
        }
    }

    @NotNull
    private static List<Component> getRecipeParaText(GTRecipe recipe, int duration, long inputEUt, long outputEUt) {
        ArrayList<Component> texts = new ArrayList<Component>();
        if (!recipe.data.m_128471_("hide_duration")) {
            texts.add((Component)Component.m_237110_((String)"gtceu.recipe.duration", (Object[])new Object[]{FormattingUtil.formatNumbers((float)duration / 20.0f)}));
        }
        long EUt = inputEUt;
        boolean isOutput = false;
        if (EUt == 0L) {
            EUt = outputEUt;
            isOutput = true;
        }
        if (EUt > 0L) {
            long euTotal = EUt * (long)duration;
            if (recipe.data.m_128471_("duration_is_total_cwu") && recipe.tickInputs.containsKey(CWURecipeCapability.CAP)) {
                int minimumCWUt = Math.max(recipe.tickInputs.get(CWURecipeCapability.CAP).stream().map(Content::getContent).mapToInt(CWURecipeCapability.CAP::of).sum(), 1);
                texts.add((Component)Component.m_237110_((String)"gtceu.recipe.max_eu", (Object[])new Object[]{FormattingUtil.formatNumbers(euTotal / (long)minimumCWUt)}));
            } else {
                texts.add((Component)Component.m_237110_((String)"gtceu.recipe.total", (Object[])new Object[]{FormattingUtil.formatNumbers(euTotal)}));
            }
            texts.add((Component)Component.m_237110_((String)(!isOutput ? "gtceu.recipe.eu" : "gtceu.recipe.eu_inverted"), (Object[])new Object[]{FormattingUtil.formatNumbers(EUt)}));
        }
        return texts;
    }

    private void addButtons() {
        int x = this.getSize().width - this.xOffset - 18;
        int y = this.getSize().height - 30;
        this.addWidget(new PredicatedButtonWidget(x, y, 15, 15, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("ID")}), cd -> Minecraft.m_91087_().f_91068_.m_90911_(this.recipe.id.toString()), () -> !FMLLoader.isProduction(), !FMLLoader.isProduction()).setHoverTooltips(new String[]{"click to copy: " + this.recipe.id}));
    }

    private int getVoltageXOffset() {
        int n = this.getSize().width;
        int x = n - (switch (this.tier) {
            case 0, 6, 7, 9, 10, 12 -> 20;
            case 13, 14 -> 22;
            case 11 -> 18;
            case 5 -> 12;
            default -> 14;
        });
        if (!LDLib.isEmiLoaded()) {
            x -= 3;
        }
        return x;
    }

    public void setRecipeOC(int button, boolean isShiftClick) {
        OverclockingLogic oc = OverclockingLogic.NON_PERFECT_OVERCLOCK;
        if (button == 0) {
            this.setTier(this.tier + 1);
        } else if (button == 1) {
            this.setTier(this.tier - 1);
        } else if (button == 2) {
            this.setTierToMin();
        }
        if (isShiftClick) {
            oc = OverclockingLogic.PERFECT_OVERCLOCK;
        }
        this.setRecipeTextWidget(oc);
        this.setRecipeWidget();
    }

    private void setRecipeTextWidget(OverclockingLogic logic) {
        long inputEUt = RecipeHelper.getInputEUt(this.recipe);
        int duration = this.recipe.duration;
        String tierText = GTValues.VNF[this.tier];
        if (this.tier > this.minTier && inputEUt != 0L) {
            int ocs = this.tier - this.minTier;
            if (this.minTier == 0) {
                --ocs;
            }
            OverclockingLogic.OCParams params = new OverclockingLogic.OCParams(inputEUt, this.recipe.duration, ocs, 1);
            OverclockingLogic.OCResult result = logic.runOverclockingLogic(params, GTValues.V[this.tier]);
            duration = (int)((double)duration * result.durationMultiplier());
            inputEUt = (long)((double)inputEUt * result.eutMultiplier());
            tierText = tierText.formatted(ChatFormatting.ITALIC);
        }
        List<Component> texts = GTRecipeWidget.getRecipeParaText(this.recipe, duration, inputEUt, 0L);
        for (int i = 0; i < texts.size(); ++i) {
            this.recipeParaTexts.get(i).setComponent(texts.get(i));
        }
        this.voltageTextWidget.setText(tierText);
        this.voltageTextWidget.setSelfPositionX(this.getVoltageXOffset() - this.xOffset);
        this.detectAndSendChanges();
        this.updateScreen();
    }

    public static void setConsumedChance(Content content, ChanceLogic logic, List<Component> tooltips, int recipeTier, int chanceTier, ChanceBoostFunction function) {
        if (content.chance < ChanceLogic.getMaxChancedValue()) {
            int boostedChance = function.getBoostedChance(content, recipeTier, chanceTier);
            if (boostedChance == 0) {
                tooltips.add((Component)Component.m_237115_((String)"gtceu.gui.content.chance_nc"));
            } else {
                float baseChanceFloat = 100.0f * (float)content.chance / (float)content.maxChance;
                float boostedChanceFloat = 100.0f * (float)boostedChance / (float)content.maxChance;
                if (logic != ChanceLogic.NONE && logic != ChanceLogic.OR) {
                    tooltips.add((Component)Component.m_237110_((String)"gtceu.gui.content.chance_base_logic", (Object[])new Object[]{FormattingUtil.formatNumber2Places(baseChanceFloat), logic.getTranslation()}).m_130940_(ChatFormatting.YELLOW));
                } else {
                    tooltips.add(FormattingUtil.formatPercentage2Places("gtceu.gui.content.chance_base", baseChanceFloat));
                }
                if (content.tierChanceBoost != 0) {
                    String key = "gtceu.gui.content.chance_tier_boost_" + (content.tierChanceBoost > 0 ? "plus" : "minus");
                    tooltips.add(FormattingUtil.formatPercentage2Places(key, Math.abs(100.0f * (float)content.tierChanceBoost / (float)content.maxChance)));
                }
                if (logic != ChanceLogic.NONE && logic != ChanceLogic.OR) {
                    tooltips.add((Component)Component.m_237110_((String)"gtceu.gui.content.chance_boosted_logic", (Object[])new Object[]{FormattingUtil.formatNumber2Places(boostedChanceFloat), logic.getTranslation()}).m_130940_(ChatFormatting.YELLOW));
                } else {
                    tooltips.add(FormattingUtil.formatPercentage2Places("gtceu.gui.content.chance_boosted", boostedChanceFloat));
                }
            }
        }
    }

    private void setTier(int tier) {
        this.tier = Mth.m_14045_((int)tier, (int)this.minTier, (int)14);
    }

    private void setTierToMin() {
        this.setTier(this.minTier);
    }

    public void collectStorage(Table<IO, RecipeCapability<?>, Object> extraTable, Table<IO, RecipeCapability<?>, List<Content>> extraContents, GTRecipe recipe) {
        List<Content> contents;
        RecipeCapability<?> cap;
        Object2ObjectLinkedOpenHashMap inputCapabilities = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipe.inputs.entrySet()) {
            RecipeCapability<?> recipeCapability = entry.getKey();
            List<Content> contents2 = entry.getValue();
            extraContents.put((Object)IO.IN, recipeCapability, contents2);
            inputCapabilities.put(recipeCapability, recipeCapability.createXEIContainerContents(contents2, recipe, IO.IN));
        }
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipe.tickInputs.entrySet()) {
            RecipeCapability<?> recipeCapability = entry.getKey();
            List<Content> contents2 = entry.getValue();
            extraContents.put((Object)IO.IN, recipeCapability, contents2);
            inputCapabilities.put(recipeCapability, recipeCapability.createXEIContainerContents(contents2, recipe, IO.IN));
        }
        for (Map.Entry<RecipeCapability<Object>, List<Content>> entry : inputCapabilities.entrySet()) {
            while (entry.getValue().size() < recipe.recipeType.getMaxInputs(entry.getKey())) {
                entry.getValue().add(null);
            }
            Object object = entry.getKey().createXEIContainer(entry.getValue());
            if (object == null) continue;
            extraTable.put((Object)IO.IN, entry.getKey(), object);
        }
        Object2ObjectLinkedOpenHashMap outputCapabilities = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipe.outputs.entrySet()) {
            cap = entry.getKey();
            contents = entry.getValue();
            extraContents.put((Object)IO.OUT, cap, contents);
            outputCapabilities.put(cap, cap.createXEIContainerContents(contents, recipe, IO.OUT));
        }
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipe.tickOutputs.entrySet()) {
            cap = entry.getKey();
            contents = entry.getValue();
            extraContents.put((Object)IO.OUT, cap, contents);
            outputCapabilities.put(cap, cap.createXEIContainerContents(contents, recipe, IO.OUT));
        }
        for (Map.Entry entry : outputCapabilities.entrySet()) {
            while (((List)entry.getValue()).size() < recipe.recipeType.getMaxOutputs((RecipeCapability)entry.getKey())) {
                ((List)entry.getValue()).add(null);
            }
            Object container = ((RecipeCapability)entry.getKey()).createXEIContainer((List)entry.getValue());
            if (container == null) continue;
            extraTable.put((Object)IO.OUT, (Object)((RecipeCapability)entry.getKey()), container);
        }
    }

    public void addSlots(Table<IO, RecipeCapability<?>, List<Content>> contentTable, WidgetGroup group, GTRecipe recipe) {
        for (Map.Entry capabilityEntry : contentTable.rowMap().entrySet()) {
            IO io = (IO)capabilityEntry.getKey();
            for (Map.Entry contentsEntry : ((Map)capabilityEntry.getValue()).entrySet()) {
                RecipeCapability cap = (RecipeCapability)contentsEntry.getKey();
                int nonTickCount = (io == IO.IN ? recipe.getInputContents(cap) : recipe.getOutputContents(cap)).size();
                List contents = (List)contentsEntry.getValue();
                WidgetUtils.widgetByIdForEach(group, "^%s_[0-9]+$".formatted(cap.slotName(io)), cap.getWidgetClass(), widget -> {
                    int index = WidgetUtils.widgetIdIndex(widget);
                    if (index >= 0 && index < contents.size()) {
                        Content content = (Content)contents.get(index);
                        cap.applyWidgetInfo((Widget)widget, index, true, io, null, recipe.getType(), recipe, content, null, this.minTier, this.tier);
                        widget.setOverlay(content.createOverlay(index >= nonTickCount, this.minTier, this.tier, recipe.getType().getChanceFunction()));
                    }
                });
            }
        }
    }
}

