/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.xei.handlers.fluid;

import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidStackList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CycleFluidEntryHandler
implements IFluidHandlerModifiable {
    private final List<FluidEntryList> entries;
    private List<List<FluidStack>> unwrapped = null;

    public CycleFluidEntryHandler(List<FluidEntryList> entries) {
        this.entries = new ArrayList<FluidEntryList>(entries);
    }

    public List<List<FluidStack>> getUnwrapped() {
        if (this.unwrapped == null) {
            this.unwrapped = this.entries.stream().map(CycleFluidEntryHandler::getStacksNullable).collect(Collectors.toCollection(ArrayList::new));
        }
        return this.unwrapped;
    }

    private static List<FluidStack> getStacksNullable(FluidEntryList list) {
        if (list == null) {
            return null;
        }
        return list.getStacks();
    }

    public FluidEntryList getEntry(int index) {
        return this.entries.get(index);
    }

    public int getTanks() {
        return this.entries.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        List<FluidStack> stackList = this.getUnwrapped().get(tank);
        return stackList == null || stackList.isEmpty() ? FluidStack.EMPTY : stackList.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % stackList.size()));
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        if (tank >= 0 && tank < this.entries.size()) {
            this.entries.set(tank, FluidStackList.of(fluidStack));
            this.unwrapped = null;
        }
    }

    public int getTankCapacity(int tank) {
        return this.getFluidInTank(tank).getAmount();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return false;
    }

    public List<FluidEntryList> getEntries() {
        return this.entries;
    }
}

