/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.integration.top.element.FluidStackElement;
import com.gregtechceu.gtceu.integration.top.element.FluidStyle;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import java.util.List;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RecipeOutputProvider
extends CapabilityInfoProvider<RecipeLogic> {
    public ResourceLocation getID() {
        return GTCEu.id("recipe_output_info");
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos blockPos, @Nullable Direction direction) {
        return GTCapabilityHelper.getRecipeLogic(level, blockPos, direction);
    }

    @Override
    protected void addProbeInfo(RecipeLogic recipeLogic, IProbeInfo iProbeInfo, Player player, BlockEntity blockEntity, IProbeHitData iProbeHitData) {
        GTRecipe recipe;
        if (recipeLogic.isWorking() && (recipe = recipeLogic.getLastRecipe()) != null) {
            List<FluidStack> outputFluids;
            IProbeInfo verticalPane = iProbeInfo.vertical(iProbeInfo.defaultLayoutStyle().spacing(0));
            verticalPane.text(CompoundText.create().info((Component)Component.m_237115_((String)"gtceu.top.recipe_output").m_130946_(" ")));
            List<ItemStack> outputItems = RecipeHelper.getOutputItems(recipe);
            if (!outputItems.isEmpty()) {
                this.addItemInfo(verticalPane, outputItems);
            }
            if (!(outputFluids = RecipeHelper.getOutputFluids(recipe)).isEmpty()) {
                this.addFluidInfo(verticalPane, outputFluids);
            }
        }
    }

    private void addItemInfo(IProbeInfo verticalPane, List<ItemStack> outputItems) {
        for (ItemStack itemOutput : outputItems) {
            if (itemOutput == null || itemOutput.m_41619_()) continue;
            IProbeInfo horizontalPane = verticalPane.horizontal(verticalPane.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.item(itemOutput, new ItemStyle().width(16).height(16)).text(" ").itemLabel(itemOutput);
        }
    }

    private void addFluidInfo(IProbeInfo verticalPane, List<FluidStack> outputFluids) {
        for (FluidStack fluidOutput : outputFluids) {
            if (fluidOutput == null || fluidOutput.isEmpty()) continue;
            IProbeInfo horizontalPane = verticalPane.horizontal(verticalPane.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.element((IElement)new FluidStackElement(fluidOutput, new FluidStyle())).text(" ").text(fluidOutput.getDisplayName());
        }
    }
}

